/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.entities;

import com.eucalyptus.bootstrap.Databases;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.entities.PersistenceContexts;
import com.eucalyptus.entities.PersistenceExceptions;
import com.eucalyptus.entities.RecoverablePersistenceException;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionInternalException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Ats;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.HasNaturalId;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.Parameters;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.LockModeType;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.transaction.Synchronization;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;
import org.hibernate.Cache;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.Transaction;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.ejb.EntityManagerFactoryImpl;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.proxy.HibernateProxy;

@ConfigurableClass(root="bootstrap.tx", description="Parameters controlling transaction behaviour.")
public class Entities {
    @ConfigurableField(description="Maximum number of times a transaction may be retried before giving up.", initial="5")
    public static Integer CONCURRENT_UPDATE_RETRIES = 10;
    private static final boolean CLEANUP_TX_SESSION = Boolean.valueOf(System.getProperty("com.eucalyptus.entities.cleanupTxSession", "true"));
    private static com.google.common.cache.Cache<String, String> txLog = CacheBuilder.newBuilder().weakKeys().softValues().build();
    private static Logger LOG = Logger.getLogger(Entities.class);
    private static ThreadLocal<String> txRootThreadLocal = new ThreadLocal();
    private static ThreadLocal<ConcurrentMap<String, CascadingTx>> txStateThreadLocal = new ThreadLocal<ConcurrentMap<String, CascadingTx>>(){

        @Override
        protected ConcurrentMap<String, CascadingTx> initialValue() {
            return Maps.newConcurrentMap();
        }
    };

    static String lookatPersistenceContext(Object obj) throws RuntimeException {
        Class type = Classes.typeOf(obj);
        Ats ats = Ats.inClassHierarchy(type);
        PersistenceContext persistenceContext = null;
        if (!ats.has(PersistenceContext.class)) {
            throw new RuntimeException("Attempting to create an entity wrapper instance for non persistent type: " + type + ".  Class hierarchy contains: \n" + ats.toString());
        }
        persistenceContext = ats.get(PersistenceContext.class);
        return persistenceContext.name();
    }

    public static boolean hasTransaction(Object obj) {
        String ctx = Entities.lookatPersistenceContext(obj);
        CascadingTx tx = (CascadingTx)txStateThreadLocal.get().get(ctx);
        if (tx == null) {
            return false;
        }
        if (tx.isActive()) {
            return true;
        }
        Entities.cleanStrandedTx(tx);
        return false;
    }

    private static CascadingTx getTransaction(Object obj) {
        if (Entities.hasTransaction(obj)) {
            return (CascadingTx)txStateThreadLocal.get().get(Entities.lookatPersistenceContext(obj));
        }
        throw new NoSuchElementException("Failed to find active transaction for persistence context: " + Entities.lookatPersistenceContext(obj) + " and object: " + obj);
    }

    public static void removeTransaction(CascadingTx tx) {
        String txId = Entities.makeTxRootName(tx);
        txLog.invalidate((Object)(txStateThreadLocal.toString() + tx.getRecord().getPersistenceContext()));
        txStateThreadLocal.get().remove(tx.getRecord().getPersistenceContext());
        if (txId.equals(txStateThreadLocal.get())) {
            for (Map.Entry e : txStateThreadLocal.get().entrySet()) {
                Entities.cleanStrandedTx((CascadingTx)e.getValue());
            }
            txStateThreadLocal.get().clear();
            txStateThreadLocal.remove();
        }
    }

    private static void cleanStrandedTx(CascadingTx txValue) {
        LOG.error((Object)("Found stranded transaction: " + txValue.getRecord().getPersistenceContext() + " started at: " + txValue.getRecord().getStack()));
        try {
            txValue.rollback();
        }
        catch (Exception ex) {
            LOG.trace((Object)ex, (Throwable)ex);
        }
    }

    private static String makeTxRootName(CascadingTx tx) {
        return txStateThreadLocal.toString() + tx.getRecord().getPersistenceContext();
    }

    private static CascadingTx createTransaction(Object obj) throws RecoverablePersistenceException, RuntimeException {
        String ctx = Entities.lookatPersistenceContext(obj);
        CascadingTx ret = new CascadingTx(ctx);
        try {
            ret.begin();
            if (txRootThreadLocal.get() == null) {
                String txId = Entities.makeTxRootName(ret);
                LOG.trace((Object)("Creating root entry for transaction tree: " + txId + " at: \n" + Threads.currentStackString()));
                txRootThreadLocal.set(txId);
            }
            txStateThreadLocal.get().put(ctx, ret);
            return ret;
        }
        catch (RuntimeException ex) {
            ret.rollback();
            throw ex;
        }
    }

    @Deprecated
    public static EntityTransaction get(Object obj) {
        if (Entities.hasTransaction(obj)) {
            CascadingTx tx = Entities.getTransaction(obj);
            EntityTransaction etx = tx.join();
            return etx;
        }
        return Entities.createTransaction(obj);
    }

    public static TransactionResource transactionFor(Object obj) {
        return new TransactionResource(Entities.get(obj));
    }

    public static TransactionResource distinctTransactionFor(Object obj) {
        if (Entities.hasTransaction(obj)) {
            throw new IllegalStateException("Found existing transaction for context " + Entities.lookatPersistenceContext(obj));
        }
        return new TransactionResource(Entities.get(obj));
    }

    public static <R> R transaction(Object obj, Closure<R> closure) {
        try (TransactionResource transactionResource = Entities.transactionFor(obj);){
            Object object = closure.call((Object)transactionResource);
            return (R)object;
        }
    }

    public static <R> R distinctTransaction(Object obj, Closure<R> closure) throws IllegalStateException {
        if (Entities.hasTransaction(obj)) {
            throw new IllegalStateException("Found existing transaction for context " + Entities.lookatPersistenceContext(obj));
        }
        return Entities.transaction(obj, closure);
    }

    public static <T> void flush(T object) {
        Entities.getTransaction(object).txState.getEntityManager().flush();
    }

    public static <T> List<T> query(T example) {
        return Entities.query(example, false);
    }

    public static <T> List<T> query(T example, boolean readOnly) {
        Example qbe = Example.create(example);
        List resultList = Entities.getTransaction(example).getTxState().getSession().createCriteria(example.getClass()).setReadOnly(readOnly).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).setCacheable(true).add((Criterion)qbe).list();
        return Lists.newArrayList((Iterable)Sets.newHashSet((Iterable)resultList));
    }

    public static <T> List<T> query(T example, boolean readOnly, Criterion criterion, Map<String, String> aliases) {
        Example qbe = Example.create(example);
        Criteria criteria = Entities.getTransaction(example).getTxState().getSession().createCriteria(example.getClass()).setReadOnly(readOnly).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).setCacheable(true).add((Criterion)qbe).add(criterion);
        for (Map.Entry<String, String> aliasEntry : aliases.entrySet()) {
            criteria.createAlias(aliasEntry.getKey(), aliasEntry.getValue());
        }
        List resultList = criteria.list();
        return Lists.newArrayList((Iterable)Sets.newHashSet((Iterable)resultList));
    }

    public static <T> List<T> query(T example, boolean readOnly, int maxResults) {
        Example qbe = Example.create(example);
        List resultList = Entities.getTransaction(example).getTxState().getSession().createCriteria(example.getClass()).setReadOnly(readOnly).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).setCacheable(true).add((Criterion)qbe).setMaxResults(maxResults).setFetchSize(maxResults).list();
        return Lists.newArrayList((Iterable)Sets.newHashSet((Iterable)resultList));
    }

    public static <T> List<T> query(T example, QueryOptions options) {
        Example qbe = Entities.setOptions(Example.create(example), options);
        List resultList = Entities.setOptions(Entities.getTransaction(example).getTxState().getSession().createCriteria(example.getClass()), options).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).add((Criterion)qbe).list();
        return Lists.newArrayList((Iterable)Sets.newLinkedHashSet((Iterable)resultList));
    }

    private static Criteria setOptions(Criteria criteria, QueryOptions options) {
        Criterion criterion;
        Boolean readonly;
        Boolean cacheable;
        Integer fetchSize;
        Integer maxResults = options.getMaxResults();
        if (maxResults != null) {
            criteria.setMaxResults(maxResults.intValue());
        }
        if ((fetchSize = options.getFetchSize()) != null) {
            criteria.setFetchSize(fetchSize.intValue());
        }
        if ((cacheable = options.getCacheable()) != null) {
            criteria.setCacheable(cacheable.booleanValue());
        }
        if ((readonly = options.getReadonly()) != null) {
            criteria.setReadOnly(readonly.booleanValue());
        }
        if ((criterion = options.getCriterion()) != null) {
            criteria.add(criterion);
        }
        return criteria;
    }

    private static Example setOptions(Example example, QueryOptions options) {
        if (options.getMatchMode() != null) {
            example.enableLike(options.getMatchMode());
        }
        return example;
    }

    public static QueryOptionsBuilder queryOptions() {
        return new QueryOptionsBuilder();
    }

    public static <T> T uniqueResult(T example) throws TransactionException, NoSuchElementException {
        try {
            Object pk = Entities.resolvePrimaryKey(example);
            String natId = Entities.resolveNaturalId(example);
            if (pk != null) {
                return Entities.maybePrimaryKey(example);
            }
            if (natId != null) {
                return Entities.maybeNaturalId(example);
            }
            return Entities.maybeDefinitelyExample(example);
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            Logs.extreme().trace((Object)ex, (Throwable)ex);
            RecoverablePersistenceException newEx = PersistenceExceptions.throwFiltered(ex);
            throw new TransactionInternalException(newEx.getMessage(), newEx);
        }
    }

    public static void evict(Object obj) {
        Entities.getTransaction(obj).getTxState().getSession().evict(obj);
    }

    public static void evictCache(Object obj) {
        String ctx = Entities.lookatPersistenceContext(obj);
        EntityManagerFactoryImpl emf = PersistenceContexts.getEntityManagerFactory(ctx);
        Cache cache = emf.getSessionFactory().getCache();
        cache.evictQueryRegions();
        cache.evictDefaultQueryRegion();
        cache.evictCollectionRegions();
        cache.evictEntityRegions();
        LOG.debug((Object)("Evicted cache for " + obj));
    }

    private static <T> String resolveNaturalId(T example) {
        if (example instanceof HasNaturalId && ((HasNaturalId)example).getNaturalId() != null) {
            return ((HasNaturalId)example).getNaturalId();
        }
        return null;
    }

    private static <T> T maybeDefinitelyExample(T example) throws HibernateException, NoSuchElementException {
        Object ret = Entities.getTransaction(example).getTxState().getSession().createCriteria(example.getClass()).add((Criterion)Example.create(example)).setCacheable(true).setMaxResults(1).setFetchSize(1).setFirstResult(0).uniqueResult();
        if (ret == null) {
            throw new NoSuchElementException("example: " + LogUtil.dumpObject(example));
        }
        return (T)ret;
    }

    private static <T> T maybeNaturalId(T example) throws HibernateException, NoSuchElementException {
        String natId = ((HasNaturalId)example).getNaturalId();
        Object ret = Entities.getTransaction(example).getTxState().getSession().byNaturalId(example.getClass()).using("naturalId", (Object)natId).load();
        if (ret == null) {
            throw new NoSuchElementException("@NaturalId: " + natId);
        }
        return (T)ret;
    }

    private static <T> T maybePrimaryKey(T example) throws NoSuchElementException {
        Object id = Entities.resolvePrimaryKey(example);
        if (id == null) {
            return null;
        }
        Object res = Entities.getTransaction(example).getTxState().getEntityManager().find(example.getClass(), id);
        if (res == null) {
            throw new NoSuchElementException("@Id: " + id);
        }
        return (T)res;
    }

    static <T> Object resolvePrimaryKey(T example) {
        return Entities.getTransaction(example).getTxState().getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(example);
    }

    public static Criteria createCriteria(Class class1) {
        return Entities.getTransaction(class1).getTxState().getSession().createCriteria(class1);
    }

    public static Criteria createCriteriaUnique(Class class1) {
        return Entities.getTransaction(class1).getTxState().getSession().createCriteria(class1).setCacheable(true).setFetchSize(1).setMaxResults(1).setFirstResult(0);
    }

    public static <T> T persist(T newObject) throws ConstraintViolationException {
        try {
            Entities.getTransaction(newObject).getTxState().getEntityManager().persist(newObject);
            return newObject;
        }
        catch (RuntimeException ex) {
            PersistenceExceptions.throwFiltered(ex);
            throw ex;
        }
    }

    public static <T> T merge(T newObject) throws ConstraintViolationException {
        if (!Entities.isPersistent(newObject)) {
            try {
                return Entities.uniqueResult(newObject);
            }
            catch (Exception ex) {
                return Entities.persist(newObject);
            }
        }
        try {
            Object persistedObject = Entities.getTransaction(newObject).getTxState().getEntityManager().merge(newObject);
            return (T)(persistedObject == newObject ? newObject : persistedObject);
        }
        catch (RuntimeException ex) {
            PersistenceExceptions.throwFiltered(ex);
            throw ex;
        }
    }

    public static <T> T mergeDirect(T object) {
        try {
            return (T)Entities.getTransaction(object).getTxState().getEntityManager().merge(object);
        }
        catch (RuntimeException ex) {
            PersistenceExceptions.throwFiltered(ex);
            throw ex;
        }
    }

    public <T> T lookupAndClose(T example) throws NoSuchElementException {
        T ret = null;
        EntityTransaction db = !Entities.hasTransaction(example) ? Entities.get(example) : Entities.getTransaction(example).join();
        try {
            ret = Entities.uniqueResult(example);
            db.commit();
        }
        catch (TransactionException ex) {
            db.rollback();
            throw new NoSuchElementException(ex.getMessage());
        }
        return ret;
    }

    public static <T> Function<T, T> merge() {
        return new Function<T, T>(){

            public T apply(T arg0) {
                return Entities.merge(arg0);
            }
        };
    }

    public static <T> void refresh(T newObject) throws ConstraintViolationException {
        try {
            Entities.getTransaction(newObject).getTxState().getEntityManager().refresh(newObject, (LockModeType)null);
        }
        catch (RuntimeException ex) {
            PersistenceExceptions.throwFiltered(ex);
            throw ex;
        }
    }

    public static <T> void refresh(T newObject, LockModeType lockMode) throws ConstraintViolationException {
        try {
            Entities.getTransaction(newObject).getTxState().getEntityManager().refresh(newObject, lockMode);
        }
        catch (RuntimeException ex) {
            PersistenceExceptions.throwFiltered(ex);
            throw ex;
        }
    }

    public static boolean isPersistent(Object obj) {
        if (!Entities.hasTransaction(obj)) {
            return false;
        }
        return Entities.getTransaction(obj).getTxState().getSession().contains(obj);
    }

    public static boolean isInitialized(@Nullable Object obj) {
        return obj != null && Hibernate.isInitialized((Object)obj);
    }

    public static boolean isReadable(@Nullable Object obj) {
        SessionImplementor sessionImplementor = Entities.getSession(obj);
        return obj != null && (sessionImplementor != null && sessionImplementor.isOpen() || Entities.isInitialized(obj));
    }

    private static SessionImplementor getSession(@Nullable Object obj) {
        SessionImplementor session = null;
        if (obj instanceof AbstractPersistentCollection) {
            session = ((AbstractPersistentCollection)obj).getSession();
        } else if (obj instanceof HibernateProxy) {
            session = ((HibernateProxy)obj).getHibernateLazyInitializer().getSession();
        }
        return session;
    }

    public static void initialize(@Nullable Object obj) {
        Hibernate.initialize((Object)obj);
    }

    public static <T> void delete(T deleteObject) {
        Entities.getTransaction(deleteObject).getTxState().getEntityManager().remove(deleteObject);
    }

    public static <T> int deleteAll(Class<T> deleteClass) {
        return Entities.deleteAllMatching(deleteClass, null, Collections.emptyMap());
    }

    public static <T> int deleteAllMatching(Class<T> deleteClass, String condition, Map<String, ?> parameters) {
        try {
            Query query = Entities.getTransaction(deleteClass).getTxState().getEntityManager().createQuery("DELETE FROM " + deleteClass.getName() + " " + Strings.nullToEmpty((String)condition));
            for (Map.Entry<String, ?> entry : parameters.entrySet()) {
                query.setParameter(entry.getKey(), entry.getValue());
            }
            return query.executeUpdate();
        }
        catch (Exception e) {
            LOG.error(deleteClass, (Throwable)e);
            throw Exceptions.toUndeclared(e);
        }
    }

    public static long count(Object example) {
        return Entities.count(example, (Criterion)Restrictions.conjunction(), Collections.emptyMap());
    }

    public static long count(Object example, Criterion criterion, Map<String, String> aliases) {
        Example qbe = Example.create((Object)example);
        Criteria criteria = Entities.getTransaction(example).getTxState().getSession().createCriteria(example.getClass()).setReadOnly(true).setCacheable(false).add((Criterion)qbe).add(criterion).setProjection(Projections.rowCount());
        for (Map.Entry<String, String> aliasEntry : aliases.entrySet()) {
            criteria.createAlias(aliasEntry.getKey(), aliasEntry.getValue());
        }
        Number count = (Number)criteria.uniqueResult();
        return count.longValue();
    }

    @Deprecated
    public static void registerClose(Class<?> emClass) {
        final EntityManager entityManager = Entities.getTransaction(emClass).getTxState().getEntityManager();
        Entities.registerSynchronization(emClass, new Synchronization(){

            public void afterCompletion(int i) {
                entityManager.close();
            }

            public void beforeCompletion() {
            }
        });
    }

    public static <T> void registerSynchronization(Class<T> syncClass, Synchronization synchronization) {
        Session session = Entities.getTransaction(syncClass).getTxState().getSession();
        Transaction transaction = session.getTransaction();
        transaction.registerSynchronization(synchronization);
    }

    public static <T> Supplier<T> asTransaction(Supplier<T> supplier) {
        List<Class> generics = Classes.genericsToClasses(supplier);
        for (Class type : generics) {
            if (!PersistenceContexts.isPersistentClass(type)) continue;
            return Entities.asTransaction(type, supplier);
        }
        throw new IllegalArgumentException("Failed to find generics for provided supplier, cannot make into transaction: " + Threads.currentStackString());
    }

    public static <E, T> Supplier<T> asTransaction(Class<E> type, Supplier<T> supplier) {
        return Entities.asTransaction(type, supplier, CONCURRENT_UPDATE_RETRIES);
    }

    public static <E, T> Supplier<T> asTransaction(Class<E> type, Supplier<T> supplier, Integer retries) {
        Function functionalized = Functions.forSupplier(supplier);
        Function transactionalized = Entities.asTransaction(type, functionalized, (int)retries);
        return Suppliers.compose(transactionalized, (Supplier)Suppliers.ofInstance(Void.class));
    }

    public static <E, T> Predicate<T> asTransaction(Predicate<T> predicate) {
        List<Class> generics = Classes.genericsToClasses(predicate);
        for (Class type : generics) {
            if (!PersistenceContexts.isPersistentClass(type)) continue;
            return Entities.asTransaction(type, predicate);
        }
        throw new IllegalArgumentException("Failed to find generics for provided predicate, cannot make into transaction: " + Threads.currentStackString());
    }

    public static <E, T> Predicate<T> asDistinctTransaction(Class<E> type, Predicate<T> predicate) {
        Entities.ensureDistinct(type);
        return Entities.asTransaction(type, predicate);
    }

    public static <E, T> Predicate<T> asTransaction(Class<E> type, Predicate<T> predicate) {
        return Entities.asTransaction(type, predicate, CONCURRENT_UPDATE_RETRIES);
    }

    public static <E, T> Predicate<T> asTransaction(Class<E> type, Predicate<T> predicate, Integer retries) {
        Function funcionalized = Functions.forPredicate(predicate);
        final Function transactionalized = Entities.asTransaction(type, funcionalized, (int)retries);
        return new Predicate<T>(){

            public boolean apply(T input) {
                return (Boolean)transactionalized.apply(input);
            }
        };
    }

    public static <T, R> Function<T, R> asTransaction(Function<T, R> function) {
        if (function instanceof TransactionalFunction) {
            return function;
        }
        List<Class> generics = Classes.genericsToClasses(function);
        for (Class type : generics) {
            if (!PersistenceContexts.isPersistentClass(type)) continue;
            return Entities.asTransaction(type, function);
        }
        throw new IllegalArgumentException("Failed to find generics for provided function, cannot make into transaction: " + Threads.currentStackString());
    }

    public static <E, T, R> Function<T, R> asTransaction(Class<E> type, Function<T, R> function) {
        if (function instanceof TransactionalFunction) {
            return function;
        }
        return Entities.asTransaction(type, function, (int)CONCURRENT_UPDATE_RETRIES);
    }

    public static <E, T, R> Function<T, R> asDistinctTransaction(Class<E> type, Function<T, R> function) {
        Entities.ensureDistinct(type);
        return Entities.asTransaction(type, function);
    }

    public static <E, T, R> Function<T, R> asTransaction(Class<E> type, Function<T, R> function, int retries) {
        if (function instanceof TransactionalFunction) {
            return function;
        }
        return new TransactionalFunction<E, T, R>(type, function, retries);
    }

    public static boolean commit(EntityTransaction tx) {
        boolean committed = false;
        if (tx.getRollbackOnly()) {
            tx.rollback();
        } else if (Databases.isVolatile().booleanValue()) {
            tx.rollback();
        } else {
            tx.commit();
            committed = true;
        }
        return committed;
    }

    private static void ensureDistinct(Object type) {
        if (Entities.hasTransaction(type)) {
            throw new IllegalStateException("Found existing transaction for context " + Entities.lookatPersistenceContext(type));
        }
    }

    private static class TransactionalFunction<E, D, R>
    implements Function<D, R> {
        private Class<E> entityType;
        private Function<D, R> function;
        private Integer retries = CONCURRENT_UPDATE_RETRIES;

        TransactionalFunction(Class<E> entityType, Function<D, R> function, Integer retries) {
            this.entityType = entityType;
            this.function = function;
            this.retries = retries;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public R apply(D input) {
            NullPointerException nullPointerException;
            RuntimeException rootCause = null;
            for (int i = 0; i < this.retries; ++i) {
                try (TransactionResource tx = Entities.transactionFor(this.entityType);){
                    Object ret = this.function.apply(input);
                    tx.commit();
                    Object object = ret;
                    return (R)object;
                }
                catch (RuntimeException ex) {
                    if (Exceptions.isCausedBy(ex, OptimisticLockException.class)) {
                        rootCause = (RuntimeException)Exceptions.findCause(ex, OptimisticLockException.class);
                    } else if (Exceptions.isCausedBy(ex, LockAcquisitionException.class)) {
                        rootCause = (RuntimeException)Exceptions.findCause(ex, LockAcquisitionException.class);
                    } else {
                        if (!Exceptions.isCausedBy(ex, RetryTransactionException.class)) {
                            rootCause = ex;
                            Logs.extreme().error((Object)ex, (Throwable)ex);
                            throw ex;
                        }
                        rootCause = Exceptions.findCause(ex, RetryTransactionException.class);
                        for (Class<?> entityClass : ((RetryTransactionException)rootCause).getEntitiesToEvict()) {
                            Entities.evictCache(entityClass);
                        }
                    }
                    StaleObjectStateException stale = Exceptions.findCause(ex, StaleObjectStateException.class);
                    if (stale != null) {
                        try {
                            Entities.evictCache(Class.forName(stale.getEntityName()));
                        }
                        catch (ClassNotFoundException entityClass) {
                            // empty catch block
                        }
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(20L);
                    }
                    catch (InterruptedException ex1) {
                        Exceptions.maybeInterrupted(ex1);
                    }
                    continue;
                }
            }
            if (rootCause != null) {
                nullPointerException = rootCause;
                throw nullPointerException;
            }
            nullPointerException = new NullPointerException("BUG: Transaction retry failed but root cause exception is unknown!");
            throw nullPointerException;
        }
    }

    public static class RetryTransactionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final Iterable<Class<?>> entitiesToEvict;

        public RetryTransactionException(Throwable cause) {
            this(cause, Collections.emptyList());
        }

        public RetryTransactionException(Throwable cause, Class<?> entityToEvict) {
            this(cause, Collections.singleton(entityToEvict));
        }

        public RetryTransactionException(Throwable cause, Iterable<Class<?>> entitiesToEvict) {
            super(cause);
            this.entitiesToEvict = entitiesToEvict;
        }

        public Iterable<Class<?>> getEntitiesToEvict() {
            return this.entitiesToEvict;
        }
    }

    public static class TxRecord {
        private final String persistenceContext;
        private final String uuid;
        private final Long startTime;
        private final StackTraceElement ste;
        private final String stack;

        TxRecord(String persistenceContext, String uuid, StackTraceElement ste) {
            this.persistenceContext = persistenceContext;
            this.uuid = uuid;
            this.ste = ste;
            this.stack = Threads.currentStackString();
            this.startTime = System.currentTimeMillis();
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public String getPersistenceContext() {
            return this.persistenceContext;
        }

        public String getUuid() {
            return this.uuid;
        }

        public StackTraceElement getSte() {
            return this.ste;
        }

        String getStack() {
            return this.stack;
        }
    }

    private static class CascadingTx
    implements EntityTransaction {
        private final TxRecord record;
        private TxState txState;

        CascadingTx(String ctx) throws RecoverablePersistenceException {
            StackTraceElement ste = Threads.currentStackFrame(4);
            String uuid = UUID.randomUUID().toString();
            this.record = new TxRecord(ctx, uuid, ste);
            try {
                this.txState = new TxState(ctx);
            }
            catch (RuntimeException ex) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
                this.rollback();
                throw PersistenceExceptions.throwFiltered(ex);
            }
        }

        public boolean getRollbackOnly() throws RecoverablePersistenceException {
            return this.txState == null ? false : this.txState.getRollbackOnly();
        }

        public void setRollbackOnly() throws RecoverablePersistenceException {
            if (this.txState != null) {
                this.txState.setRollbackOnly();
            }
        }

        public boolean isActive() throws RecoverablePersistenceException {
            return this.txState == null ? false : this.txState.isActive();
        }

        public void begin() throws RecoverablePersistenceException {
            try {
                this.txState.begin();
            }
            catch (RecoverablePersistenceException ex) {
                PersistenceExceptions.throwFiltered(ex);
                Entities.removeTransaction(this);
            }
            catch (RuntimeException ex) {
                PersistenceExceptions.throwFiltered(ex);
                Entities.removeTransaction(this);
                throw ex;
            }
        }

        public void rollback() throws RecoverablePersistenceException {
            Entities.removeTransaction(this);
            if (this.txState != null && this.txState.isActive()) {
                try {
                    this.txState.rollback();
                    this.txState = null;
                }
                catch (RuntimeException ex) {
                    Logs.extreme().error((Object)ex);
                }
            } else {
                Logs.extreme().debug((Object)"Duplicate call to rollback( )");
            }
        }

        public void commit() throws RecoverablePersistenceException {
            Entities.removeTransaction(this);
            if (this.txState != null && this.txState.isActive()) {
                try {
                    this.txState.commit();
                }
                catch (RuntimeException ex) {
                    throw PersistenceExceptions.throwFiltered(ex);
                }
            } else {
                Logs.extreme().error((Object)("Duplicate call to commit( ): " + Threads.currentStackString()));
            }
        }

        TxState getTxState() {
            return this.txState;
        }

        public EntityTransaction join() {
            return new EntityTransaction(){

                public void setRollbackOnly() {
                }

                public void rollback() {
                }

                public void commit() {
                }

                public void begin() {
                }

                public boolean isActive() {
                    return CascadingTx.this.isActive();
                }

                public boolean getRollbackOnly() {
                    return CascadingTx.this.getRollbackOnly();
                }
            };
        }

        TxRecord getRecord() {
            return this.record;
        }

        private class TxState
        implements EntityTransaction {
            private EntityManager em;
            private EntityTransaction transaction;
            private final WeakReference<Session> sessionRef;

            public TxState(String ctx) {
                try {
                    EntityManagerFactoryImpl anemf = PersistenceContexts.getEntityManagerFactory(ctx);
                    Parameters.checkParam(anemf, Matchers.notNullValue());
                    this.em = anemf.createEntityManager();
                    Parameters.checkParam(this.em, Matchers.notNullValue());
                    this.transaction = this.em.getTransaction();
                    Parameters.checkParam(this.transaction, Matchers.notNullValue());
                    this.sessionRef = new WeakReference<Session>((Session)this.em.getDelegate());
                }
                catch (RuntimeException ex) {
                    this.doCleanup();
                    throw ex;
                }
            }

            private void doCleanup() {
                if (this.transaction != null && this.transaction.isActive()) {
                    try {
                        this.transaction.rollback();
                    }
                    catch (RuntimeException ex) {
                        LOG.warn((Object)ex);
                        Logs.extreme().warn((Object)ex, (Throwable)ex);
                    }
                }
                this.transaction = null;
                if (CLEANUP_TX_SESSION) {
                    if (this.sessionRef != null && this.sessionRef.get() != null) {
                        this.sessionRef.clear();
                    }
                    if (this.em != null && this.em.isOpen()) {
                        try {
                            this.em.close();
                        }
                        catch (RuntimeException ex) {
                            LOG.warn((Object)ex);
                            Logs.extreme().warn((Object)ex, (Throwable)ex);
                        }
                    }
                    this.em = null;
                }
            }

            EntityManager getEntityManager() {
                return this.em;
            }

            Session getSession() {
                return (Session)this.sessionRef.get();
            }

            public void begin() {
                try {
                    this.transaction.begin();
                }
                catch (RuntimeException ex) {
                    LOG.warn((Object)ex);
                    Logs.extreme().warn((Object)ex, (Throwable)ex);
                    this.doCleanup();
                    throw ex;
                }
            }

            public void commit() {
                try {
                    this.transaction.commit();
                }
                catch (RuntimeException ex) {
                    LOG.trace((Object)ex, (Throwable)ex);
                    Logs.extreme().warn((Object)ex, (Throwable)ex);
                    throw ex;
                }
                finally {
                    this.doCleanup();
                }
            }

            public boolean getRollbackOnly() {
                return this.transaction.getRollbackOnly();
            }

            public boolean isActive() {
                return this.transaction != null && this.transaction.isActive();
            }

            public void rollback() {
                try {
                    this.transaction.rollback();
                }
                catch (RuntimeException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    throw ex;
                }
                finally {
                    this.doCleanup();
                }
            }

            public void setRollbackOnly() {
                this.transaction.setRollbackOnly();
            }
        }
    }

    public static final class QueryOptionsBuilder {
        private MatchMode matchMode;
        private Integer maxResults;
        private Integer fetchSize;
        private Boolean cacheable;
        private Boolean readonly;
        private Criterion criterion;

        public QueryOptionsBuilder withMatchMode(MatchMode matchMode) {
            this.matchMode = matchMode;
            return this;
        }

        public QueryOptionsBuilder withMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public QueryOptionsBuilder withFetchSize(Integer fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        public QueryOptionsBuilder withCacheable(Boolean cacheable) {
            this.cacheable = cacheable;
            return this;
        }

        public QueryOptionsBuilder withReadonly(Boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        public QueryOptionsBuilder withCriterion(Criterion criterion) {
            this.criterion = criterion;
            return this;
        }

        public QueryOptions build() {
            return new QueryOptions(){

                @Override
                public MatchMode getMatchMode() {
                    return QueryOptionsBuilder.this.matchMode;
                }

                @Override
                public Integer getMaxResults() {
                    return QueryOptionsBuilder.this.maxResults;
                }

                @Override
                public Integer getFetchSize() {
                    return QueryOptionsBuilder.this.fetchSize;
                }

                @Override
                public Boolean getCacheable() {
                    return QueryOptionsBuilder.this.cacheable;
                }

                @Override
                public Boolean getReadonly() {
                    return QueryOptionsBuilder.this.readonly;
                }

                @Override
                public Criterion getCriterion() {
                    return QueryOptionsBuilder.this.criterion;
                }
            };
        }
    }

    public static interface QueryOptions {
        @Nullable
        public MatchMode getMatchMode();

        @Nullable
        public Integer getMaxResults();

        @Nullable
        public Integer getFetchSize();

        @Nullable
        public Boolean getCacheable();

        @Nullable
        public Boolean getReadonly();

        @Nullable
        public Criterion getCriterion();
    }
}

