/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.entities;

import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.entities.AbstractStatefulPersistent;
import com.eucalyptus.system.Ats;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.HasFullName;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedType;
import com.google.common.collect.Iterables;
import groovy.sql.Sql;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;

@MappedSuperclass
public abstract class AccountMetadata<STATE extends Enum<STATE>>
extends AbstractStatefulPersistent<STATE>
implements RestrictedType.AccountRestrictedType,
HasFullName<AccountMetadata> {
    @Column(name="metadata_account_id")
    private String ownerAccountNumber;
    @Column(name="metadata_unique_name", unique=true, nullable=false, length=300)
    private String uniqueName;
    @Transient
    protected OwnerFullName ownerFullNameCached = null;

    protected AccountMetadata() {
    }

    protected AccountMetadata(OwnerFullName owner) {
        this.ownerAccountNumber = owner != null ? owner.getAccountNumber() : null;
    }

    public AccountMetadata(OwnerFullName owner, String displayName) {
        super(displayName);
        this.ownerAccountNumber = owner != null ? owner.getAccountNumber() : null;
    }

    public OwnerFullName getOwner() {
        if (this.ownerFullNameCached != null) {
            return this.ownerFullNameCached;
        }
        if (this.getOwnerAccountNumber() != null) {
            OwnerFullName tempOwner = Principals.nobodyFullName().getAccountNumber().equals(this.getOwnerAccountNumber()) ? Principals.nobodyFullName() : (Principals.systemFullName().getAccountNumber().equals(this.getOwnerAccountNumber()) ? Principals.systemFullName() : AccountFullName.getInstance(this.getOwnerAccountNumber(), new String[0]));
            this.ownerFullNameCached = tempOwner;
            return this.ownerFullNameCached;
        }
        throw new RuntimeException("Failed to identify user with id " + this.ownerAccountNumber + " something has gone seriously wrong.");
    }

    @Override
    public String getOwnerAccountNumber() {
        return this.ownerAccountNumber;
    }

    protected void setOwnerAccountNumber(String ownerAccountId) {
        this.ownerAccountNumber = ownerAccountId;
    }

    protected void setOwner(OwnerFullName owner) {
        this.ownerFullNameCached = null;
        this.setOwnerAccountNumber(owner != null ? owner.getAccountNumber() : null);
    }

    protected String getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = this.createUniqueName();
            return this.uniqueName;
        }
        return this.uniqueName;
    }

    protected void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    @PrePersist
    private void generateOnCommit() {
        this.uniqueName = this.createUniqueName();
    }

    protected String createUniqueName() {
        return this.ownerAccountNumber != null && this.getDisplayName() != null ? this.ownerAccountNumber + ":" + this.getDisplayName() : null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 0;
        result = 31 * result + (this.uniqueName == null ? 0 : this.uniqueName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccountMetadata other = (AccountMetadata)obj;
        return !(this.uniqueName == null ? other.uniqueName != null : !this.uniqueName.equals(other.uniqueName));
    }

    @Override
    public int compareTo(AccountMetadata that) {
        return this.getFullName().toString().compareTo(that.getFullName().toString());
    }

    public static abstract class AccountName400UpgradeSupport {
        private static final Logger logger = Logger.getLogger(AccountName400UpgradeSupport.class);
        private static final String SQL_DROP_NAME_COLUMN = "alter table %s drop column if exists metadata_account_name";

        protected abstract List<Class<? extends AccountMetadata>> getAccountMetadataClasses();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean call() throws Exception {
            List<Class<? extends AccountMetadata>> accountMetadataClasses = this.getAccountMetadataClasses();
            Class contextClass = (Class)Iterables.get(accountMetadataClasses, (int)0);
            String context = Ats.inClassHierarchy(contextClass).get(PersistenceContext.class).name();
            try (Sql sql = null;){
                sql = Upgrades.DatabaseFilters.NEWVERSION.getConnection(context);
                for (Class<? extends AccountMetadata> accountMetadataClass : accountMetadataClasses) {
                    try {
                        int updated = sql.executeUpdate(String.format(SQL_DROP_NAME_COLUMN, Ats.from(accountMetadataClass).get(Table.class).name()));
                        logger.info((Object)("Cleared account alias for " + updated + " " + accountMetadataClass.getSimpleName() + "(s)"));
                    }
                    catch (SQLException e) {
                        throw Exceptions.toUndeclared((String)("Error clearing account alias for " + accountMetadataClass.getSimpleName()), (Throwable[])new SQLException[]{e});
                    }
                }
                Boolean i$ = true;
                return i$;
            }
        }
    }
}

