/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.entities;

import com.eucalyptus.entities.AbstractPersistent;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;

@MappedSuperclass
public abstract class AbstractStatefulStacklessPersistent<STATE extends Enum<STATE>>
extends AbstractPersistent {
    @Transient
    private static final long serialVersionUID = 1L;
    @Column(name="metadata_state")
    @Enumerated(value=EnumType.STRING)
    STATE state;
    @Column(name="metadata_last_state")
    @Enumerated(value=EnumType.STRING)
    STATE lastState;
    @Column(name="metadata_display_name")
    protected String displayName;

    protected AbstractStatefulStacklessPersistent() {
    }

    protected AbstractStatefulStacklessPersistent(STATE state, String displayName) {
        this.state = state;
        this.displayName = displayName;
    }

    protected AbstractStatefulStacklessPersistent(String displayName) {
        this.displayName = displayName;
    }

    public STATE getState() {
        return this.state;
    }

    public void setState(STATE state) {
        if (state != null && this.state != null && !((Enum)state).equals(this.state)) {
            this.lastState = this.state;
        } else if (state != null && this.state == null) {
            this.lastState = state;
        } else if (state == null && this.state != null) {
            this.lastState = this.state;
        }
        this.state = state;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        return result;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public final String getName() {
        return this.getDisplayName();
    }

    public STATE getLastState() {
        return this.lastState;
    }

    public void setLastState(STATE lastState) {
        this.lastState = lastState;
    }
}

