/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.entities;

import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedType;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.hibernate.criterion.Criterion;

public abstract class AbstractPersistentSupport<RT extends RestrictedType, AP extends AbstractPersistent, PE extends Exception> {
    protected final String typeDescription;

    protected AbstractPersistentSupport(String typeDescription) {
        this.typeDescription = typeDescription;
    }

    public <T> T lookupByName(@Nullable OwnerFullName ownerFullName, String name, Function<? super AP, T> transform) throws PE {
        return this.lookupByName(ownerFullName, name, Predicates.alwaysTrue(), transform);
    }

    public <T> T lookupByName(@Nullable OwnerFullName ownerFullName, String name, Predicate<? super AP> filter, Function<? super AP, T> transform) throws PE {
        return this.lookupByExample(this.exampleWithName(ownerFullName, name), ownerFullName, name, filter, transform);
    }

    public <T> T lookupByExample(AP example, @Nullable OwnerFullName ownerFullName, String key, Predicate<? super AP> filter, Function<? super AP, T> transform) throws PE {
        try {
            return Transactions.one(example, filter, transform);
        }
        catch (NoSuchElementException e) {
            throw this.notFoundException(this.qualifyOwner("Unable to find " + this.typeDescription + " '" + key + "'", ownerFullName), e);
        }
        catch (Exception e) {
            throw this.metadataException(this.qualifyOwner("Error finding " + this.typeDescription + " '" + key + "'", ownerFullName), e);
        }
    }

    public List<AP> list(OwnerFullName ownerFullName) throws PE {
        try {
            return Transactions.findAll(this.exampleWithOwner(ownerFullName));
        }
        catch (Exception e) {
            throw this.metadataException(this.qualifyOwner("Failed to find " + this.typeDescription + "s", ownerFullName), e);
        }
    }

    public <T> List<T> list(OwnerFullName ownerFullName, Predicate<? super AP> filter, Function<? super AP, T> transform) throws PE {
        try {
            return Transactions.filteredTransform(this.exampleWithOwner(ownerFullName), filter, transform);
        }
        catch (Exception e) {
            throw this.metadataException(this.qualifyOwner("Failed to find " + this.typeDescription + "s", ownerFullName), e);
        }
    }

    public <T> List<T> list(OwnerFullName ownerFullName, Criterion criterion, Map<String, String> aliases, Predicate<? super AP> filter, Function<? super AP, T> transform) throws PE {
        try {
            return Transactions.filteredTransform(this.exampleWithOwner(ownerFullName), criterion, aliases, filter, transform);
        }
        catch (Exception e) {
            throw this.metadataException(this.qualifyOwner("Failed to find " + this.typeDescription + "s", ownerFullName), e);
        }
    }

    public <T> List<T> listByExample(AP example, Predicate<? super AP> filter, Function<? super AP, T> transform) throws PE {
        try {
            return Transactions.filteredTransform(example, filter, transform);
        }
        catch (Exception e) {
            throw this.metadataException("Failed to find " + this.typeDescription + "s by example: " + LogUtil.dumpObject(example), e);
        }
    }

    public <T> List<T> listByExample(AP example, Predicate<? super AP> filter, Criterion criterion, Map<String, String> aliases, Function<? super AP, T> transform) throws PE {
        try {
            return Transactions.filteredTransform(example, criterion, aliases, filter, transform);
        }
        catch (Exception e) {
            throw this.metadataException("Failed to find " + this.typeDescription + "s by example: " + LogUtil.dumpObject(example), e);
        }
    }

    public long countByExample(AP example) throws PE {
        try {
            return Entities.count(example);
        }
        catch (Exception e) {
            throw this.metadataException("Failed to count " + this.typeDescription + "s by example: " + LogUtil.dumpObject(example), e);
        }
    }

    public long countByExample(AP example, Criterion criterion, Map<String, String> aliases) throws PE {
        try {
            return Entities.count(example, criterion, aliases);
        }
        catch (Exception e) {
            throw this.metadataException("Failed to count " + this.typeDescription + "s by example: " + LogUtil.dumpObject(example), e);
        }
    }

    public AP updateByExample(AP example, OwnerFullName ownerFullName, String key, Callback<AP> updateCallback) throws PE {
        try {
            return (AP)((AbstractPersistent)Transactions.one(example, updateCallback));
        }
        catch (NoSuchElementException e) {
            throw this.notFoundException(this.qualifyOwner("Unable to find " + this.typeDescription + " '" + key + "'", ownerFullName), e);
        }
        catch (Exception e) {
            throw this.metadataException(this.qualifyOwner("Error updating " + this.typeDescription + " '" + key + "'", ownerFullName), e);
        }
    }

    public <T> T updateByExample(AP example, OwnerFullName ownerFullName, String key, Function<? super AP, T> updateTransform) throws PE {
        try {
            return Transactions.one(example, updateTransform);
        }
        catch (NoSuchElementException e) {
            throw this.notFoundException(this.qualifyOwner("Unable to find " + this.typeDescription + " '" + key + "'", ownerFullName), e);
        }
        catch (Exception e) {
            throw this.metadataException(this.qualifyOwner("Error updating " + this.typeDescription + " '" + key + "'", ownerFullName), e);
        }
    }

    public <T> T updateByExample(AP example, Criterion criterion, Map<String, String> aliases, OwnerFullName ownerFullName, String key, Function<? super AP, T> updateTransform) throws PE {
        try {
            return Transactions.one(example, criterion, aliases, Predicates.alwaysTrue(), updateTransform);
        }
        catch (NoSuchElementException e) {
            throw this.notFoundException(this.qualifyOwner("Unable to find " + this.typeDescription + " '" + key + "'", ownerFullName), e);
        }
        catch (Exception e) {
            throw this.metadataException(this.qualifyOwner("Error updating " + this.typeDescription + " '" + key + "'", ownerFullName), e);
        }
    }

    public AP save(AP metadata) throws PE {
        try {
            return (AP)((AbstractPersistent)Transactions.saveDirect(metadata));
        }
        catch (Exception e) {
            throw this.metadataException("Error creating " + this.typeDescription + " '" + ((RestrictedType)metadata).getDisplayName() + "'", e);
        }
    }

    public boolean delete(RT metadata) throws PE {
        try {
            return Transactions.delete(this.exampleWithName(AccountFullName.getInstance(metadata.getOwner().getAccountNumber(), new String[0]), metadata.getDisplayName()));
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (Exception e) {
            throw this.metadataException("Error deleting " + this.typeDescription + " '" + this.describe((RestrictedType)metadata) + "'", e);
        }
    }

    public List<AP> deleteByExample(AP example) throws PE {
        try {
            return Transactions.each(example, new Callback<AP>(){

                @Override
                public void fire(AP input) {
                    Entities.delete(input);
                }
            });
        }
        catch (Exception e) {
            throw this.metadataException("Error deleting " + this.typeDescription + "s by example: " + LogUtil.dumpObject(example), e);
        }
    }

    public List<AP> deleteByExample(AP example, Criterion criterion, Map<String, String> aliases) throws PE {
        try {
            return Transactions.each(example, criterion, aliases, new Callback<AP>(){

                @Override
                public void fire(AP input) {
                    Entities.delete(input);
                }
            });
        }
        catch (Exception e) {
            throw this.metadataException("Error deleting " + this.typeDescription + "s by example: " + LogUtil.dumpObject(example), e);
        }
    }

    protected String describe(RestrictedType metadata) {
        return metadata.getDisplayName();
    }

    protected abstract PE notFoundException(String var1, Throwable var2);

    protected abstract PE metadataException(String var1, Throwable var2);

    protected abstract AP exampleWithOwner(OwnerFullName var1);

    protected abstract AP exampleWithName(OwnerFullName var1, String var2);

    protected String qualifyOwner(String text, OwnerFullName ownerFullName) {
        return ownerFullName == null ? text : text + " for " + ownerFullName;
    }

    public static Function<AbstractPersistent, Date> creation() {
        return AbstractPersistentDateFunctions.CREATION;
    }

    public static Function<AbstractPersistent, Date> lastUpdate() {
        return AbstractPersistentDateFunctions.LAST_UPDATE;
    }

    public AbstractPersistentSupport<RT, AP, PE> withRetries() {
        return this.withRetries(5);
    }

    public AbstractPersistentSupport<RT, AP, PE> withRetries(int retries) {
        return new RetryingAbstractPersistentSupport(this, retries);
    }

    private static enum AbstractPersistentDateFunctions implements Function<AbstractPersistent, Date>
    {
        CREATION{

            @Nullable
            public Date apply(@Nullable AbstractPersistent abstractPersistent) {
                return abstractPersistent == null ? null : abstractPersistent.getCreationTimestamp();
            }
        }
        ,
        LAST_UPDATE{

            @Nullable
            public Date apply(@Nullable AbstractPersistent abstractPersistent) {
                return abstractPersistent == null ? null : abstractPersistent.getLastUpdateTimestamp();
            }
        };

    }

    private static class DelegatingAbstractPersistentSupport<RT extends RestrictedType, AP extends AbstractPersistent, PE extends Exception>
    extends AbstractPersistentSupport<RT, AP, PE> {
        private final AbstractPersistentSupport<RT, AP, PE> delegate;

        private DelegatingAbstractPersistentSupport(AbstractPersistentSupport<RT, AP, PE> delegate) {
            super(delegate.typeDescription);
            this.delegate = delegate;
        }

        @Override
        public <T> T lookupByName(@Nullable OwnerFullName ownerFullName, String name, Function<? super AP, T> transform) throws PE {
            return this.delegate.lookupByName(ownerFullName, name, transform);
        }

        @Override
        public <T> T lookupByName(@Nullable OwnerFullName ownerFullName, String name, Predicate<? super AP> filter, Function<? super AP, T> transform) throws PE {
            return this.delegate.lookupByName(ownerFullName, name, filter, transform);
        }

        @Override
        public <T> T lookupByExample(AP example, @Nullable OwnerFullName ownerFullName, String key, Predicate<? super AP> filter, Function<? super AP, T> transform) throws PE {
            return this.delegate.lookupByExample((AP)example, ownerFullName, key, filter, transform);
        }

        @Override
        public List<AP> list(OwnerFullName ownerFullName) throws PE {
            return this.delegate.list(ownerFullName);
        }

        @Override
        public <T> List<T> list(OwnerFullName ownerFullName, Predicate<? super AP> filter, Function<? super AP, T> transform) throws PE {
            return this.delegate.list(ownerFullName, filter, transform);
        }

        @Override
        public <T> List<T> list(OwnerFullName ownerFullName, Criterion criterion, Map<String, String> aliases, Predicate<? super AP> filter, Function<? super AP, T> transform) throws PE {
            return this.delegate.list(ownerFullName, criterion, aliases, filter, transform);
        }

        @Override
        public <T> List<T> listByExample(AP example, Predicate<? super AP> filter, Function<? super AP, T> transform) throws PE {
            return this.delegate.listByExample((AP)example, filter, transform);
        }

        @Override
        public <T> List<T> listByExample(AP example, Predicate<? super AP> filter, Criterion criterion, Map<String, String> aliases, Function<? super AP, T> transform) throws PE {
            return this.delegate.listByExample((AP)example, filter, criterion, aliases, transform);
        }

        @Override
        public long countByExample(AP example) throws PE {
            return this.delegate.countByExample(example);
        }

        @Override
        public long countByExample(AP example, Criterion criterion, Map<String, String> aliases) throws PE {
            return this.delegate.countByExample(example, criterion, aliases);
        }

        @Override
        public AP updateByExample(AP example, OwnerFullName ownerFullName, String key, Callback<AP> updateCallback) throws PE {
            return this.delegate.updateByExample(example, ownerFullName, key, updateCallback);
        }

        @Override
        public <T> T updateByExample(AP example, OwnerFullName ownerFullName, String key, Function<? super AP, T> updateTransform) throws PE {
            return this.delegate.updateByExample((AP)example, ownerFullName, key, updateTransform);
        }

        @Override
        public AP save(AP metadata) throws PE {
            return this.delegate.save(metadata);
        }

        @Override
        public boolean delete(RT metadata) throws PE {
            return this.delegate.delete(metadata);
        }

        @Override
        public List<AP> deleteByExample(AP example) throws PE {
            return this.delegate.deleteByExample(example);
        }

        @Override
        public List<AP> deleteByExample(AP example, Criterion criterion, Map<String, String> aliases) throws PE {
            return this.delegate.deleteByExample(example, criterion, aliases);
        }

        @Override
        public String describe(RestrictedType metadata) {
            return this.delegate.describe(metadata);
        }

        @Override
        public PE notFoundException(String message, Throwable cause) {
            return this.delegate.notFoundException(message, cause);
        }

        @Override
        public PE metadataException(String message, Throwable cause) {
            return this.delegate.metadataException(message, cause);
        }

        @Override
        public AP exampleWithOwner(OwnerFullName ownerFullName) {
            return this.delegate.exampleWithOwner(ownerFullName);
        }

        @Override
        public AP exampleWithName(OwnerFullName ownerFullName, String name) {
            return this.delegate.exampleWithName(ownerFullName, name);
        }

        @Override
        public String qualifyOwner(String text, OwnerFullName ownerFullName) {
            return this.delegate.qualifyOwner(text, ownerFullName);
        }

        public static Function<AbstractPersistent, Date> creation() {
            return AbstractPersistentSupport.creation();
        }

        public static Function<AbstractPersistent, Date> lastUpdate() {
            return AbstractPersistentSupport.lastUpdate();
        }

        @Override
        public AbstractPersistentSupport<RT, AP, PE> withRetries() {
            return this.delegate.withRetries();
        }

        @Override
        public AbstractPersistentSupport<RT, AP, PE> withRetries(int retries) {
            return this.delegate.withRetries(retries);
        }
    }

    private static class RetryingAbstractPersistentSupport<RT extends RestrictedType, AP extends AbstractPersistent, PE extends Exception>
    extends DelegatingAbstractPersistentSupport<RT, AP, PE> {
        private final int retries;

        private RetryingAbstractPersistentSupport(AbstractPersistentSupport<RT, AP, PE> delegate, int retries) {
            super(delegate);
            this.retries = retries;
        }

        @Override
        public <T> T updateByExample(AP example, OwnerFullName ownerFullName, String key, Function<? super AP, T> updateTransform) throws PE {
            return this.updateWithRetries(example.getClass(), new Function<Void, T>((AbstractPersistent)example, ownerFullName, key, (Function)updateTransform){
                final /* synthetic */ AbstractPersistent val$example;
                final /* synthetic */ OwnerFullName val$ownerFullName;
                final /* synthetic */ String val$key;
                final /* synthetic */ Function val$updateTransform;
                {
                    this.val$example = abstractPersistent;
                    this.val$ownerFullName = ownerFullName;
                    this.val$key = string;
                    this.val$updateTransform = function;
                }

                public T apply(@Nullable Void nothing) {
                    try {
                        return RetryingAbstractPersistentSupport.super.updateByExample(this.val$example, this.val$ownerFullName, this.val$key, this.val$updateTransform);
                    }
                    catch (Exception e) {
                        throw Exceptions.toUndeclared(e);
                    }
                }
            }, ownerFullName, key);
        }

        @Override
        public AP updateByExample(AP example, OwnerFullName ownerFullName, String key, Callback<AP> updateCallback) throws PE {
            return (AP)((AbstractPersistent)this.updateWithRetries(example.getClass(), new Function<Void, AP>((AbstractPersistent)example, ownerFullName, key, updateCallback){
                final /* synthetic */ AbstractPersistent val$example;
                final /* synthetic */ OwnerFullName val$ownerFullName;
                final /* synthetic */ String val$key;
                final /* synthetic */ Callback val$updateCallback;
                {
                    this.val$example = abstractPersistent;
                    this.val$ownerFullName = ownerFullName;
                    this.val$key = string;
                    this.val$updateCallback = callback;
                }

                public AP apply(@Nullable Void nothing) {
                    try {
                        return RetryingAbstractPersistentSupport.super.updateByExample(this.val$example, this.val$ownerFullName, this.val$key, this.val$updateCallback);
                    }
                    catch (Exception e) {
                        throw Exceptions.toUndeclared(e);
                    }
                }
            }, ownerFullName, key));
        }

        @Override
        public List<AP> deleteByExample(AP example) throws PE {
            return (List)this.deleteWithRetries(example.getClass(), new Function<Void, List<AP>>((AbstractPersistent)example){
                final /* synthetic */ AbstractPersistent val$example;
                {
                    this.val$example = abstractPersistent;
                }

                public List<AP> apply(@Nullable Void nothing) {
                    try {
                        return RetryingAbstractPersistentSupport.super.deleteByExample(this.val$example);
                    }
                    catch (Exception e) {
                        throw Exceptions.toUndeclared(e);
                    }
                }
            }, example);
        }

        @Override
        public List<AP> deleteByExample(AP example, Criterion criterion, Map<String, String> aliases) throws PE {
            return (List)this.deleteWithRetries(example.getClass(), new Function<Void, List<AP>>((AbstractPersistent)example, criterion, aliases){
                final /* synthetic */ AbstractPersistent val$example;
                final /* synthetic */ Criterion val$criterion;
                final /* synthetic */ Map val$aliases;
                {
                    this.val$example = abstractPersistent;
                    this.val$criterion = criterion;
                    this.val$aliases = map;
                }

                public List<AP> apply(@Nullable Void nothing) {
                    try {
                        return RetryingAbstractPersistentSupport.super.deleteByExample(this.val$example, this.val$criterion, this.val$aliases);
                    }
                    catch (Exception e) {
                        throw Exceptions.toUndeclared(e);
                    }
                }
            }, example);
        }

        @Override
        public AbstractPersistentSupport<RT, AP, PE> withRetries() {
            return this;
        }

        @Override
        public AbstractPersistentSupport<RT, AP, PE> withRetries(int retries) {
            return this;
        }

        private <T> T updateWithRetries(Class<?> type, Function<Void, T> updateFunction, OwnerFullName ownerFullName, String key) throws PE {
            try {
                return (T)Entities.asTransaction(type, updateFunction, this.retries).apply(null);
            }
            catch (Exception e) {
                throw this.metadataException(this.qualifyOwner("Error updating " + this.typeDescription + " '" + key + "'", ownerFullName), e);
            }
        }

        private <T> T deleteWithRetries(Class<?> type, Function<Void, T> deleteFunction, AP example) throws PE {
            try {
                return (T)Entities.asTransaction(type, deleteFunction, this.retries).apply(null);
            }
            catch (Exception e) {
                throw this.metadataException("Error deleting " + this.typeDescription + "s by example: " + LogUtil.dumpObject(example), e);
            }
        }
    }
}

