/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.entities;

import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedType;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.Transient;

@MappedSuperclass
public class AbstractOwnedPersistent
extends AbstractPersistent
implements RestrictedType.AccountRestrictedType,
RestrictedType.UserRestrictedType {
    private static final long serialVersionUID = 1L;
    @Column(name="metadata_display_name")
    protected String displayName;
    @Column(name="metadata_account_id")
    private String ownerAccountNumber;
    @Column(name="metadata_unique_name", unique=true, nullable=false, length=600)
    private String uniqueName;
    @Transient
    protected OwnerFullName ownerFullNameCached = null;
    @Column(name="metadata_user_id")
    protected String ownerUserId;
    @Column(name="metadata_user_name")
    protected String ownerUserName;

    protected AbstractOwnedPersistent() {
    }

    protected AbstractOwnedPersistent(@Nullable OwnerFullName owner) {
        this.setOwner(owner);
    }

    protected AbstractOwnedPersistent(OwnerFullName owner, String displayName) {
        this(owner);
        this.setDisplayName(displayName);
    }

    public void clearUserIdentity() {
        this.ownerUserId = null;
        this.ownerUserName = null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getOwnerAccountNumber() {
        return this.ownerAccountNumber;
    }

    public void setOwnerAccountNumber(String ownerAccountNumber) {
        this.ownerAccountNumber = ownerAccountNumber;
    }

    @Override
    public String getOwnerUserId() {
        return this.ownerUserId;
    }

    public void setOwnerUserId(String ownerUserId) {
        this.ownerUserId = ownerUserId;
    }

    @Override
    public String getOwnerUserName() {
        return this.ownerUserName;
    }

    public void setOwnerUserName(String ownerUserName) {
        this.ownerUserName = ownerUserName;
    }

    public OwnerFullName getOwner() {
        if (this.ownerFullNameCached != null) {
            return this.ownerFullNameCached;
        }
        if (this.getOwnerUserId() != null) {
            OwnerFullName tempOwner = Principals.nobodyFullName().getUserId().equals(this.getOwnerUserId()) ? Principals.nobodyFullName() : (Principals.systemFullName().getUserId().equals(this.getOwnerUserId()) ? Principals.systemFullName() : UserFullName.getInstance(this.getOwnerUserId(), new String[0]));
            this.ownerFullNameCached = tempOwner;
            return this.ownerFullNameCached;
        }
        if (this.getOwnerAccountNumber() != null) {
            OwnerFullName tempOwner = Principals.nobodyFullName().getAccountNumber().equals(this.getOwnerAccountNumber()) ? Principals.nobodyFullName() : (Principals.systemFullName().getAccountNumber().equals(this.getOwnerAccountNumber()) ? Principals.systemFullName() : AccountFullName.getInstance(this.getOwnerAccountNumber(), new String[0]));
            this.ownerFullNameCached = tempOwner;
            return this.ownerFullNameCached;
        }
        throw new RuntimeException("Failed to identify resource owner");
    }

    public void setOwner(@Nullable OwnerFullName owner) {
        this.ownerFullNameCached = null;
        this.setOwnerAccountNumber(owner != null ? owner.getAccountNumber() : null);
        this.setOwnerUserId(owner != null ? owner.getUserId() : null);
        this.setOwnerUserName(owner != null ? owner.getUserName() : null);
    }

    protected String getUniqueName() {
        return this.uniqueName;
    }

    protected void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    @PrePersist
    private void generateOnCommit() {
        this.uniqueName = this.createUniqueName();
    }

    protected String createUniqueName() {
        return this.ownerAccountNumber != null && this.getDisplayName() != null ? this.ownerAccountNumber + ":" + this.getDisplayName() : null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 0;
        result = 31 * result + (this.uniqueName == null ? 0 : this.uniqueName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractOwnedPersistent other = (AbstractOwnedPersistent)obj;
        return !(this.uniqueName == null ? other.uniqueName != null : !this.uniqueName.equals(other.uniqueName));
    }
}

