/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.empyrean.configuration;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.ServiceBuilders;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.annotation.Description;
import com.eucalyptus.component.annotation.ServiceOperation;
import com.eucalyptus.component.events.ServiceEvents;
import com.eucalyptus.component.groups.ServiceGroup;
import com.eucalyptus.component.groups.ServiceGroupBuilder;
import com.eucalyptus.component.groups.ServiceGroupConfiguration;
import com.eucalyptus.component.groups.ServiceGroups;
import com.eucalyptus.empyrean.ServiceId;
import com.eucalyptus.empyrean.configuration.AvailableComponentInfo;
import com.eucalyptus.empyrean.configuration.DeregisterServiceResponseType;
import com.eucalyptus.empyrean.configuration.DeregisterServiceType;
import com.eucalyptus.empyrean.configuration.DescribeAvailableServiceTypesResponseType;
import com.eucalyptus.empyrean.configuration.DescribeAvailableServiceTypesType;
import com.eucalyptus.empyrean.configuration.RegisterServiceResponseType;
import com.eucalyptus.empyrean.configuration.RegisterServiceType;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.Parameters;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;

public class ServiceRegistrationManager {
    private static Logger LOG = Logger.getLogger(ServiceRegistrationManager.class);

    @ServiceOperation
    public static enum DescribeAvailableComponents implements Function<DescribeAvailableServiceTypesType, DescribeAvailableServiceTypesResponseType>
    {
        INSTANCE;


        public DescribeAvailableServiceTypesResponseType apply(DescribeAvailableServiceTypesType input) {
            try {
                DescribeAvailableServiceTypesResponseType reply = (DescribeAvailableServiceTypesResponseType)input.getReply();
                for (Class<? extends ComponentId> compId : ServiceBuilders.listRegisterableComponents()) {
                    ComponentId componentId = ComponentIds.lookup(compId);
                    Predicate<ComponentId> filterIn = new Predicate<ComponentId>(){

                        public boolean apply(ComponentId input) {
                            return input.isRegisterable();
                        }
                    };
                    if (!input.getVerbose().booleanValue() && !filterIn.apply((Object)componentId)) continue;
                    AvailableComponentInfo compInfo = new AvailableComponentInfo();
                    String description = componentId.getAwsServiceName() + " service implementation";
                    if (Ats.from(componentId).has(Description.class)) {
                        description = Ats.from(componentId).get(Description.class).value();
                    }
                    if (componentId.isPartitioned() && !componentId.isRegisterable()) {
                        description = "A sub component of " + componentId.getPartition() + " for: " + componentId.getCapitalizedName();
                    }
                    compInfo.setComponentName(componentId.name());
                    compInfo.setComponentCapitalizedName(componentId.getCapitalizedName());
                    compInfo.setDescription(description);
                    compInfo.setHasCredentials(componentId.hasCredentials());
                    compInfo.setRegisterable(componentId.isRegisterable());
                    compInfo.setPartitioned(componentId.isPartitioned());
                    compInfo.setPublicApiService(componentId.isPublicService());
                    compInfo.setRequiresName(componentId.isPartitioned());
                    if (componentId instanceof ServiceGroup) {
                        ServiceGroup sg = (ServiceGroup)componentId;
                        for (ComponentId componentId2 : sg.list()) {
                            compInfo.getServiceGroupMembers().add(componentId2.name());
                        }
                    }
                    for (ComponentId componentId3 : ServiceGroups.listMembership(componentId)) {
                        compInfo.getServiceGroups().add(componentId3.name());
                    }
                    reply.getAvailable().add(compInfo);
                }
                return reply;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared(ex);
            }
        }
    }

    @ServiceOperation
    public static enum DeregisterService implements Function<DeregisterServiceType, DeregisterServiceResponseType>
    {
        INSTANCE;


        private static Collection<Future<ServiceConfiguration>> deregister(ComponentId componentId, String name) throws EucalyptusCloudException {
            ArrayList deregistered = Lists.newArrayList();
            try {
                Object builder = ServiceBuilders.lookup(componentId);
                Object config = ServiceConfigurations.lookupByName(componentId.getClass(), name);
                if (ServiceGroups.isGroup(config)) {
                    ServiceGroupConfiguration groupConfig = (ServiceGroupConfiguration)config;
                    ServiceGroupBuilder groupBuilder = (ServiceGroupBuilder)builder;
                    Collection<ServiceConfiguration> configsToDeregister = groupBuilder.onDeregister(groupConfig);
                    Future groupFuture = (Future)ServiceEvents.deregisterFunction().apply((Object)groupConfig);
                    deregistered.add(groupFuture);
                    try {
                        groupFuture.get();
                        deregistered.addAll(Collections2.transform(configsToDeregister, ServiceEvents.deregisterFunction()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    deregistered.add(ServiceEvents.deregisterFunction().apply(config));
                }
            }
            catch (Exception e) {
                LOG.error((Object)e);
                LOG.debug((Object)e, (Throwable)e);
                throw e;
            }
            return deregistered;
        }

        public DeregisterServiceResponseType apply(DeregisterServiceType request) {
            DeregisterServiceResponseType reply = (DeregisterServiceResponseType)request.getReply();
            final String name = request.getName();
            try {
                Parameters.checkParam("Name must not be null: " + request, name, Matchers.notNullValue());
                Object config = ServiceConfigurations.lookupByName(request.getName());
                final ComponentId componentId = config.getComponentId();
                ServiceBuilders.lookup(componentId);
                Collection<Future<ServiceConfiguration>> configurations = Topology.doTopologyWork(new Callable<Collection<Future<ServiceConfiguration>>>(){

                    @Override
                    public Collection<Future<ServiceConfiguration>> call() throws Exception {
                        return DeregisterService.deregister(componentId, name);
                    }
                });
                Function<ServiceConfiguration, ServiceId> typeMapper = TypeMappers.lookup(ServiceConfiguration.class, ServiceId.class);
                for (Future<ServiceConfiguration> regResult : configurations) {
                    try {
                        reply.getDeregisteredServices().add((ServiceId)typeMapper.apply((Object)regResult.get()));
                    }
                    catch (Exception e) {
                        reply.set_return(Boolean.FALSE);
                        reply.getStatusMessages().add(Throwables.getRootCause((Throwable)e).getMessage());
                    }
                }
            }
            catch (Exception ex) {
                reply.set_return(false);
                reply.getStatusMessages().add("Failed to deregister " + request.getType() + ": " + name + " because of : " + ex.getMessage());
            }
            return reply;
        }
    }

    @ServiceOperation
    public static enum RegisterService implements Function<RegisterServiceType, RegisterServiceResponseType>
    {
        INSTANCE;


        public static Collection<Future<ServiceConfiguration>> register(String partition, String name, String hostName, Integer port, ComponentId componentId) throws EucalyptusCloudException {
            ArrayList registered = Lists.newArrayList();
            Object builder = ServiceBuilders.lookup(componentId);
            Object config = builder.newInstance(partition, name, hostName, port);
            if (ServiceGroups.isGroup(config)) {
                ServiceGroupConfiguration groupConfig = (ServiceGroupConfiguration)config;
                ServiceGroupBuilder groupBuilder = (ServiceGroupBuilder)builder;
                Collection<ServiceConfiguration> configsToRegister = groupBuilder.onRegister(groupConfig);
                Future groupFuture = (Future)ServiceEvents.registerFunction().apply((Object)groupConfig);
                registered.add(groupFuture);
                try {
                    groupFuture.get();
                    registered.addAll(Collections2.transform(configsToRegister, ServiceEvents.registerFunction()));
                }
                catch (Exception exception) {}
            } else {
                registered.add(ServiceEvents.registerFunction().apply(config));
            }
            return registered;
        }

        public RegisterServiceResponseType apply(RegisterServiceType request) {
            RegisterServiceResponseType reply = (RegisterServiceResponseType)request.getReply();
            String partition = request.getPartition();
            String name = request.getName();
            String hostName = request.getHost();
            Integer port = request.getPort();
            try {
                ComponentId componentId = ComponentIds.lookup(request.getType());
                ServiceBuilders.lookup(componentId);
                Parameters.checkParam("Name must not be null: " + request, name, Matchers.notNullValue());
                Parameters.checkParam("Hostname must not be null: " + request, hostName, Matchers.notNullValue());
                Parameters.checkParam("Port must not be null: " + request, port, Matchers.notNullValue());
                Collection<Future<ServiceConfiguration>> configurations = RegisterService.register(partition, name, hostName, port, componentId);
                Function<ServiceConfiguration, ServiceId> typeMapper = TypeMappers.lookup(ServiceConfiguration.class, ServiceId.class);
                for (Future<ServiceConfiguration> regResult : configurations) {
                    try {
                        reply.getRegisteredServices().add((ServiceId)typeMapper.apply((Object)regResult.get()));
                    }
                    catch (Exception e) {
                        reply.set_return(Boolean.FALSE);
                        reply.getStatusMessages().add(Throwables.getRootCause((Throwable)e).getMessage());
                    }
                }
            }
            catch (Exception ex) {
                reply.set_return(false);
                reply.getStatusMessages().add("Failed to register " + request.getType() + ": " + name + " at host: " + hostName + ":" + port + " because of : " + ex.getMessage());
            }
            return reply;
        }
    }
}

