/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.empyrean;

import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.ServiceOrderings;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.annotation.ServiceOperation;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.empyrean.DescribeServicesResponseType;
import com.eucalyptus.empyrean.DescribeServicesType;
import com.eucalyptus.empyrean.DestroyServiceResponseType;
import com.eucalyptus.empyrean.DestroyServiceType;
import com.eucalyptus.empyrean.DisableServiceResponseType;
import com.eucalyptus.empyrean.DisableServiceType;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.empyrean.EnableServiceResponseType;
import com.eucalyptus.empyrean.EnableServiceType;
import com.eucalyptus.empyrean.ModifyServiceResponseType;
import com.eucalyptus.empyrean.ModifyServiceType;
import com.eucalyptus.empyrean.ServiceId;
import com.eucalyptus.empyrean.ServiceStatusType;
import com.eucalyptus.empyrean.StartServiceResponseType;
import com.eucalyptus.empyrean.StartServiceType;
import com.eucalyptus.empyrean.StopServiceResponseType;
import com.eucalyptus.empyrean.StopServiceType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.Internets;
import com.eucalyptus.util.Parameters;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;

public class EmpyreanService {
    private static Logger LOG = Logger.getLogger(EmpyreanService.class);

    public static ServiceConfiguration findService(final String name) {
        Parameters.checkParam(name, Matchers.notNullValue());
        Predicate<ServiceConfiguration> nameOrFullName = new Predicate<ServiceConfiguration>(){

            public boolean apply(ServiceConfiguration input) {
                return name.equals(input.getName()) || name.equals(input.getFullName().toString());
            }
        };
        for (ComponentId compId : ComponentIds.list()) {
            try {
                return (ServiceConfiguration)Iterables.find(Components.lookup(compId).services(), (Predicate)nameOrFullName);
            }
            catch (NoSuchElementException ex) {
                if (!compId.isRegisterable()) continue;
                try {
                    return ServiceConfigurations.lookupByName(compId.getClass(), name);
                }
                catch (Exception exception) {
                }
            }
        }
        throw new NoSuchElementException("Failed to lookup service named: " + name);
    }

    public static ModifyServiceResponseType modifyService(ModifyServiceType request) throws Exception {
        ModifyServiceResponseType reply = (ModifyServiceResponseType)request.getReply();
        try {
            if (NamedTransition.INSTANCE.apply(request)) {
                reply.markWinning();
            } else {
                Component.State nextState = Component.State.valueOf(request.getState().toUpperCase());
                ServiceConfiguration config = EmpyreanService.findService(request.getName());
                ((Future)Topology.transition(nextState).apply((Object)config)).get();
                reply.markWinning();
            }
        }
        catch (Exception ex) {
            Exceptions.maybeInterrupted(ex);
            throw new EucalyptusCloudException("Failed to execute request transition: " + request.getState() + "\nDue to:\n" + Throwables.getRootCause((Throwable)ex).getMessage() + "\nPossible arguments are: \n" + "TRANSITIONS\n\t" + Joiner.on((String)"\n\t").join((Object[])Topology.Transitions.values()) + "STATES\n\t" + Joiner.on((String)"\n\t").join((Object[])Component.State.values()), ex);
        }
        return reply;
    }

    public static StartServiceResponseType startService(StartServiceType request) throws Exception {
        StartServiceResponseType reply = (StartServiceResponseType)request.getReply();
        for (ServiceId serviceInfo : request.getServices()) {
            try {
                Component comp = Components.lookup(serviceInfo.getType());
                ServiceConfiguration service = TypeMappers.transform(serviceInfo, ServiceConfiguration.class);
                if (!service.isVmLocal().booleanValue()) continue;
                try {
                    Topology.start(service).get();
                    reply.getServices().add(serviceInfo);
                }
                catch (IllegalStateException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    throw ex;
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                throw ex;
            }
        }
        return reply;
    }

    public static DestroyServiceResponseType destroyService(DestroyServiceType request) throws Exception {
        DestroyServiceResponseType reply = (DestroyServiceResponseType)request.getReply();
        for (ServiceId serviceInfo : request.getServices()) {
            try {
                ServiceConfiguration service = TypeMappers.transform(serviceInfo, ServiceConfiguration.class);
                if (service.isVmLocal().booleanValue()) {
                    try {
                        Topology.destroy(service).get();
                    }
                    catch (IllegalStateException ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
                reply.getServices().add(serviceInfo);
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                Logs.extreme().debug((Object)ex, (Throwable)ex);
            }
        }
        return reply;
    }

    public static StopServiceResponseType stopService(StopServiceType request) throws Exception {
        StopServiceResponseType reply = (StopServiceResponseType)request.getReply();
        for (ServiceId serviceInfo : request.getServices()) {
            try {
                Component comp = Components.lookup(serviceInfo.getType());
                ServiceConfiguration service = TypeMappers.transform(serviceInfo, ServiceConfiguration.class);
                if (!service.isVmLocal().booleanValue()) continue;
                try {
                    Topology.stop(service).get();
                    reply.getServices().add(serviceInfo);
                }
                catch (IllegalStateException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    throw ex;
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                throw ex;
            }
        }
        return reply;
    }

    public static EnableServiceResponseType enableService(EnableServiceType request) throws Exception {
        EnableServiceResponseType reply = (EnableServiceResponseType)request.getReply();
        for (ServiceId serviceInfo : request.getServices()) {
            try {
                Component comp = Components.lookup(serviceInfo.getType());
                ServiceConfiguration service = TypeMappers.transform(serviceInfo, ServiceConfiguration.class);
                if (!service.isVmLocal().booleanValue()) continue;
                try {
                    Topology.enable(service).get();
                    reply.getServices().add(serviceInfo);
                }
                catch (IllegalStateException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    throw ex;
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                throw ex;
            }
        }
        return reply;
    }

    public static DisableServiceResponseType disableService(DisableServiceType request) throws Exception {
        DisableServiceResponseType reply = (DisableServiceResponseType)request.getReply();
        for (ServiceId serviceInfo : request.getServices()) {
            try {
                Component comp = Components.lookup(serviceInfo.getType());
                ServiceConfiguration service = TypeMappers.transform(serviceInfo, ServiceConfiguration.class);
                if (!service.isVmLocal().booleanValue()) continue;
                try {
                    Topology.disable(service).get();
                    reply.getServices().add(serviceInfo);
                }
                catch (IllegalStateException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    throw ex;
                }
            }
            catch (NoSuchElementException ex) {
                LOG.error((Object)ex, (Throwable)ex);
                throw ex;
            }
        }
        return reply;
    }

    public static DescribeServicesResponseType describeService(final DescribeServicesType request) {
        DescribeServicesResponseType reply = (DescribeServicesResponseType)request.getReply();
        Topology.touch(request);
        if (request.getServices().isEmpty()) {
            Empyrean compId = request.getByServiceType() != null ? ComponentIds.lookup(request.getByServiceType().toLowerCase()) : Empyrean.INSTANCE;
            boolean showEventStacks = Boolean.TRUE.equals(request.getShowEventStacks());
            boolean showEvents = Boolean.TRUE.equals(request.getShowEvents()) || showEventStacks;
            Function<ServiceConfiguration, ServiceStatusType> transformToStatus = ServiceConfigurations.asServiceStatus(showEvents, showEventStacks);
            ArrayList<Predicate<ServiceConfiguration>> filters = new ArrayList<Predicate<ServiceConfiguration>>(){
                {
                    if (request.getByPartition() != null) {
                        Partitions.exists(request.getByPartition());
                        this.add(Filters.partition(request.getByPartition()));
                    }
                    if (request.getByState() != null) {
                        Component.State stateFilter = Component.State.valueOf(request.getByState().toUpperCase());
                        this.add(Filters.state(stateFilter));
                    }
                    if (!request.getServiceNames().isEmpty()) {
                        this.add(Filters.name(request.getServiceNames()));
                    }
                    this.add(Filters.host(request.getByHost()));
                    this.add(Filters.listAllOrInternal(request.getListAll(), request.getListUserServices(), request.getListInternal()));
                }
            };
            Predicate<Component> componentFilter = Filters.componentType(compId);
            Predicate configPredicate = Predicates.and((Iterable)filters);
            ArrayList replyConfigs = Lists.newArrayList();
            for (Component comp : Components.list()) {
                if (!componentFilter.apply((Object)comp)) continue;
                Collection acceptedConfigs = Collections2.filter(comp.services(), (Predicate)configPredicate);
                replyConfigs.addAll(acceptedConfigs);
            }
            ImmutableList sortedReplyConfigs = ServiceOrderings.defaultOrdering().immutableSortedCopy((Iterable)replyConfigs);
            Collection transformedReplyConfigs = Collections2.transform((Collection)sortedReplyConfigs, transformToStatus);
            reply.getServiceStatuses().addAll(transformedReplyConfigs);
        } else {
            for (ServiceId s : request.getServices()) {
                reply.getServiceStatuses().add(TypeMappers.transform(s, ServiceStatusType.class));
            }
        }
        return reply;
    }

    @ServiceOperation(user=true)
    public static enum DescribeService implements Function<DescribeServicesType, DescribeServicesResponseType>
    {
        INSTANCE;


        public DescribeServicesResponseType apply(DescribeServicesType input) {
            try {
                if (!Contexts.lookup().getUser().isSystemAdmin()) {
                    return this.user(input);
                }
                return EmpyreanService.describeService(input);
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared(ex);
            }
        }

        public DescribeServicesResponseType user(final DescribeServicesType request) {
            DescribeServicesResponseType reply = (DescribeServicesResponseType)request.getReply();
            ArrayList<Predicate<ServiceConfiguration>> filters = new ArrayList<Predicate<ServiceConfiguration>>(){
                {
                    this.add(Filters.publicService());
                    if (request.getByPartition() != null) {
                        this.add(Filters.partition(request.getByPartition()));
                    }
                    if (request.getByState() != null) {
                        this.add(Filters.state(Component.State.valueOf(request.getByState().toUpperCase())));
                    }
                }
            };
            Predicate<Component> componentFilter = request.getByServiceType() != null ? Filters.componentType(ComponentIds.lookup(request.getByServiceType().toLowerCase())) : Predicates.alwaysTrue();
            Predicate configPredicate = Predicates.and((Iterable)filters);
            ArrayList replyConfigs = Lists.newArrayList();
            for (Component comp : Iterables.filter(Components.list(), componentFilter)) {
                replyConfigs.addAll(Collections2.filter(comp.services(), (Predicate)configPredicate));
            }
            ImmutableList sortedReplyConfigs = ServiceOrderings.defaultOrdering().immutableSortedCopy((Iterable)replyConfigs);
            Collection replyStatuses = Collections2.transform((Collection)sortedReplyConfigs, ServiceConfigurations.asServiceStatus(false, false));
            reply.getServiceStatuses().addAll(replyStatuses);
            return reply;
        }
    }

    static class Filters {
        Filters() {
        }

        static Predicate<ServiceConfiguration> publicService() {
            return new Predicate<ServiceConfiguration>(){

                public boolean apply(ServiceConfiguration input) {
                    return input.getComponentId().isPublicService();
                }
            };
        }

        static Predicate<ServiceConfiguration> partition(final String partition) {
            return new Predicate<ServiceConfiguration>(){

                public boolean apply(ServiceConfiguration input) {
                    return partition == null || partition.equals(input.getPartition());
                }
            };
        }

        static Predicate<ServiceConfiguration> host(final String host) {
            return new Predicate<ServiceConfiguration>(){

                public boolean apply(ServiceConfiguration input) {
                    return host == null || host.equals(input.getHostName());
                }
            };
        }

        static Predicate<ServiceConfiguration> name(final List<String> names) {
            return new Predicate<ServiceConfiguration>(){

                public boolean apply(ServiceConfiguration input) {
                    return names == null || names.isEmpty() || names.contains(input.getName()) || names.contains(input.getFullName().toString());
                }
            };
        }

        static Predicate<ServiceConfiguration> state(final Component.State state) {
            return new Predicate<ServiceConfiguration>(){

                public boolean apply(ServiceConfiguration input) {
                    try {
                        return input.lookupState().equals(state);
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
            };
        }

        static Predicate<Component> componentType(final ComponentId compId) {
            return new Predicate<Component>(){

                public boolean apply(Component input) {
                    return Empyrean.class.equals(compId.getClass()) || input.getComponentId().equals(compId);
                }
            };
        }

        static Predicate<ServiceConfiguration> listAllOrInternal(Boolean listAllArg, Boolean listUserServicesArg, Boolean listInternalArg) {
            final boolean listAll = Boolean.TRUE.equals(listAllArg);
            final boolean listInternal = Boolean.TRUE.equals(listInternalArg);
            final boolean listUserServices = Boolean.TRUE.equals(listUserServicesArg);
            return new Predicate<ServiceConfiguration>(){

                public boolean apply(ServiceConfiguration input) {
                    if (listAll) {
                        return true;
                    }
                    if (input.getComponentId().isDistributedService() || Empyrean.class.equals(input.getComponentId().getClass())) {
                        return true;
                    }
                    if (input.getComponentId().isPublicService()) {
                        return Internets.testLocal(input.getHostName());
                    }
                    if (input.getComponentId().isAdminService() && listUserServices) {
                        return Internets.testLocal(input.getHostName());
                    }
                    if (input.getComponentId().isInternal() && listInternal) {
                        return Internets.testLocal(input.getHostName());
                    }
                    return false;
                }
            };
        }
    }

    static enum NamedTransition implements Predicate<ModifyServiceType>
    {
        INSTANCE;


        public boolean apply(ModifyServiceType request) {
            block6: {
                try {
                    Topology.Transitions transition = Topology.Transitions.valueOf(request.getState().toUpperCase());
                    String name = request.getName();
                    ServiceConfiguration config = EmpyreanService.findService(name);
                    if (Topology.Transitions.RESTART.equals((Object)transition)) {
                        Topology.stop(config).get();
                        try {
                            Topology.start(config).get();
                            break block6;
                        }
                        catch (Exception ex) {
                            Exceptions.maybeInterrupted(ex);
                            Logs.extreme().error((Object)ex, (Throwable)ex);
                            throw Exceptions.toUndeclared(ex);
                        }
                    }
                    ((Future)Topology.transition(transition.get()).apply((Object)config)).get();
                }
                catch (IllegalArgumentException ex) {
                    return false;
                }
                catch (Exception ex) {
                    Exceptions.maybeInterrupted(ex);
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                    throw Exceptions.toUndeclared(ex);
                }
            }
            return true;
        }
    }

    @ServiceOperation
    public static enum DisableService implements Function<DisableServiceType, DisableServiceResponseType>
    {
        INSTANCE;


        public DisableServiceResponseType apply(DisableServiceType input) {
            try {
                return EmpyreanService.disableService(input);
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared(ex);
            }
        }
    }

    @ServiceOperation
    public static enum EnableService implements Function<EnableServiceType, EnableServiceResponseType>
    {
        INSTANCE;


        public EnableServiceResponseType apply(EnableServiceType input) {
            try {
                return EmpyreanService.enableService(input);
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared(ex);
            }
        }
    }

    @ServiceOperation
    public static enum StopService implements Function<StopServiceType, StopServiceResponseType>
    {
        INSTANCE;


        public StopServiceResponseType apply(StopServiceType input) {
            try {
                return EmpyreanService.stopService(input);
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared(ex);
            }
        }
    }

    @ServiceOperation
    public static enum StartService implements Function<StartServiceType, StartServiceResponseType>
    {
        INSTANCE;


        public StartServiceResponseType apply(StartServiceType input) {
            try {
                return EmpyreanService.startService(input);
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared(ex);
            }
        }
    }

    @ServiceOperation
    public static enum ModifyService implements Function<ModifyServiceType, ModifyServiceResponseType>
    {
        INSTANCE;


        public ModifyServiceResponseType apply(ModifyServiceType input) {
            try {
                return EmpyreanService.modifyService(input);
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared(ex);
            }
        }
    }
}

