/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.crypto.util;

import com.google.common.base.Objects;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.DOMCallbackLookup;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WssIdResolver
extends ResourceResolverSpi {
    public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
        String id = context.uriToResolve.substring(1);
        DOMCallbackLookup callbackLookup = new DOMCallbackLookup(context.attr.getOwnerDocument());
        Element referencedElement = null;
        try {
            referencedElement = callbackLookup.getElement(id, null, true);
        }
        catch (WSSecurityException ex) {
            WssIdResolver.error(context, ex.getMessage());
        }
        if (referencedElement == null) {
            WssIdResolver.error(context, "Error resolving reference: " + context.uriToResolve);
        }
        XMLSignatureInput result = new XMLSignatureInput((Node)referencedElement);
        result.setMIMEType("text/xml");
        result.setSourceURI((String)Objects.firstNonNull((Object)context.baseUri, (Object)"") + context.uriToResolve);
        return result;
    }

    public boolean engineCanResolveURI(ResourceResolverContext context) {
        return context.uriToResolve != null && context.uriToResolve.startsWith("#") && !context.uriToResolve.startsWith("#xpointer(");
    }

    private static void error(ResourceResolverContext context, String details) throws ResourceResolverException {
        throw new ResourceResolverException("empty", new Object[]{details}, context.attr, context.baseUri);
    }
}

