/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.crypto.util;

import com.eucalyptus.auth.login.SecurityContext;
import com.eucalyptus.binding.HoldMe;
import com.eucalyptus.crypto.util.PEMFiles;
import com.eucalyptus.crypto.util.WssIdResolver;
import com.eucalyptus.records.Logs;
import com.eucalyptus.ws.StackConfiguration;
import com.eucalyptus.ws.WebServicesException;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.log4j.Logger;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.processor.TimestampProcessor;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class WSSecurity {
    private static Logger LOG = Logger.getLogger(WSSecurity.class);
    private static CertificateFactory factory;
    private static final String SYSTEM_PROPERTY_SKIP_SECURITY_CHECK = "com.eucalyptus.crypto.util.skipWsSecurityConfigurationChecks";
    private static boolean useBc;

    public static void init() {
    }

    public static CertificateFactory getCertificateFactory() {
        if (factory == null) {
            try {
                factory = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        return factory;
    }

    public static X509Certificate verifyWSSec(SOAPEnvelope envelope) throws Exception {
        Element secNode = WSSecurity.getSecurityElement(envelope);
        XMLSignature sig = WSSecurity.getXMLSignature(secNode);
        String sigValue = new String(sig.getSignatureValue());
        SecurityContext.enqueueSignature(sigValue);
        X509Certificate cert = null;
        try {
            cert = WSSecurity.verifySignature(secNode, sig);
            Logs.exhaust().debug((Object)cert);
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            throw new WebServicesException("Authentication failed: " + ex.getMessage(), ex);
        }
        return cert;
    }

    public static X509Certificate verifySignature(Element securityNode, XMLSignature sig) throws WSSecurityException, XMLSignatureException, XMLSecurityException {
        X509Certificate cert;
        SecurityTokenReference secRef = WSSecurity.getSecurityTokenReference(sig.getKeyInfo());
        org.apache.ws.security.message.token.Reference tokenRef = secRef.getReference();
        Element bstDirect = WSSecurityUtil.findElementById((Node)securityNode.getOwnerDocument(), (String)tokenRef.getURI(), (boolean)true);
        if (bstDirect == null) {
            throw new WSSecurityException(3, "noCert");
        }
        BinarySecurity token = new BinarySecurity(bstDirect);
        String type = token.getValueType();
        try {
            if (useBc) {
                Node node = bstDirect.getFirstChild();
                String certStr = "-----BEGIN CERTIFICATE-----\n" + (node == null || !(node instanceof Text) ? null : ((Text)node).getData()) + "\n-----END CERTIFICATE-----\n";
                cert = PEMFiles.getCert(certStr.getBytes());
            } else {
                X509Security x509 = new X509Security(bstDirect);
                byte[] bstToken = x509.getToken();
                CertificateFactory factory = WSSecurity.getCertificateFactory();
                cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(bstToken));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new WSSecurityException(1, "unsupportedBinaryTokenType", new Object[]{type});
        }
        if (!sig.checkSignatureValue(cert)) {
            throw new WSSecurityException(6);
        }
        WSSecurity.verifyReferences(sig);
        return cert;
    }

    private static boolean verifyReferences(XMLSignature sig) throws WSSecurityException, XMLSignatureException, XMLSecurityException {
        if (sig.getSignedInfo() == null) {
            throw new WSSecurityException(7, "SignedInfo");
        }
        SignedInfo si = sig.getSignedInfo();
        boolean tsSigned = false;
        boolean bdSigned = false;
        for (int i = 0; i < si.getLength(); ++i) {
            Reference ref = si.item(i);
            String uri = ref.getURI();
            if ("".compareTo(uri) == 0) {
                throw new XMLSignatureException("signature.Transform.NotYetImplemented", new Object[]{"XPath"});
            }
            XMLSignatureInput xmlInput = ref.getContentsBeforeTransformation();
            if (xmlInput.isElement()) {
                Node subNode = xmlInput.getSubNode();
                String name = subNode.getLocalName();
                LOG.debug((Object)("Reference: name = " + subNode.getNodeName() + ", type = " + subNode.getNodeType()));
                if ("Timestamp".compareTo(name) == 0) {
                    WSSecurity.verifyTimestamp(subNode);
                    tsSigned = true;
                    continue;
                }
                if ("Body".compareTo(name) != 0) continue;
                WSSecurity.verifyBodyLocation(subNode);
                bdSigned = true;
                continue;
            }
            throw new XMLSignatureException("generic.NotYetImplemented", new Object[]{"References to multiple elements"});
        }
        if (!tsSigned) {
            throw new WSSecurityException(6, "requiredElementNotSigned", new Object[]{"Timestamp"});
        }
        if (!bdSigned) {
            throw new WSSecurityException(6, "requiredElementNotSigned", new Object[]{"Body"});
        }
        return true;
    }

    private static void verifyTimestamp(Node node) throws WSSecurityException {
        TimestampProcessor tsProc = new TimestampProcessor();
        LOG.debug((Object)("Timestamp: " + node));
        RequestData data = new RequestData();
        data.setWssConfig(WSSConfig.getNewInstance());
        WSDocInfo docInfo = new WSDocInfo(node.getOwnerDocument());
        List retResults = tsProc.handleToken((Element)node, data, docInfo);
        Timestamp ts = (Timestamp)((WSSecurityEngineResult)retResults.get(0)).get((Object)"timestamp");
        LOG.debug((Object)("timestamp: " + ts));
        Date expires = ts.getExpires();
        if (!SecurityContext.validateTimestampPeriod(expires)) {
            LOG.warn((Object)"[security] ]Timestamp expiration is further in the future than replay cache expiration");
        }
        Calendar now = Calendar.getInstance();
        now.add(13, StackConfiguration.CLOCK_SKEW_SEC);
        if (now.before(ts.getCreated())) {
            throw new WSSecurityException("Timestamp was created in the future: make sure you clocks are synchronized");
        }
    }

    private static void verifyBodyLocation(Node node) throws WSSecurityException {
        Node parent = node.getParentNode();
        if (parent == null || "Envelope".compareTo(parent.getLocalName()) != 0) {
            throw new WSSecurityException("Unexpected parent element for signed <Body>");
        }
        int depth = 0;
        while (parent != null) {
            ++depth;
            parent = parent.getParentNode();
        }
        if (depth != 2) {
            LOG.debug((Object)("depth of " + node.getNodeName() + " is " + depth));
            throw new WSSecurityException("Unexpected location of signed <Body>");
        }
    }

    public static XMLSignature getXmlSignature(Element signatureNode) throws WSSecurityException {
        try {
            XMLSignature sig = new XMLSignature(signatureNode, null, true);
            sig.addResourceResolver((ResourceResolverSpi)new WssIdResolver());
            return sig;
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException(6, "noXMLSig", null, (Throwable)e);
        }
    }

    public static SecurityTokenReference getSecurityTokenReference(KeyInfo info) throws WSSecurityException {
        SecurityTokenReference secRef;
        Element secTokenRef = WSSecurityUtil.getDirectChildElement((Node)info.getElement(), (String)"SecurityTokenReference", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (secTokenRef == null) {
            throw new WSSecurityException(3, "unsupportedKeyInfo");
        }
        try {
            secRef = new SecurityTokenReference(secTokenRef);
        }
        catch (WSSecurityException e1) {
            LOG.error((Object)e1, (Throwable)e1);
            throw e1;
        }
        if (!secRef.containsReference()) {
            throw new WSSecurityException(6);
        }
        return secRef;
    }

    public static Element getSignatureElement(Element securityNode) {
        Element signatureNode = WSSecurityUtil.getDirectChildElement((Node)securityNode, (String)"Signature", (String)"http://www.w3.org/2000/09/xmldsig#");
        return signatureNode;
    }

    private static Element getSecurityElement(Element env) {
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)env);
        Element soapHeaderElement = WSSecurityUtil.getDirectChildElement((Node)env, (String)soapConstants.getHeaderQName().getLocalPart(), (String)soapConstants.getEnvelopeURI());
        if (soapHeaderElement != null) {
            Element securityNode = WSSecurityUtil.getDirectChildElement((Node)soapHeaderElement, (String)"Security", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            return securityNode;
        }
        return null;
    }

    public static Element getSecurityElement(SOAPEnvelope envelope) {
        StAXOMBuilder doomBuilder = HoldMe.getStAXOMBuilder(HoldMe.getDOOMFactory(), envelope.getXMLStreamReader());
        OMElement elem = doomBuilder.getDocumentElement();
        elem.build();
        Element env = (Element)elem;
        Element securityNode = WSSecurity.getSecurityElement(env);
        return securityNode;
    }

    public static XMLSignature getXMLSignature(Element securityNode) throws WSSecurityException, XMLSignatureException {
        if (securityNode != null) {
            XMLSignature sig = WSSecurity.checkSignature(securityNode);
            return sig;
        }
        throw new XMLSignatureException("No BST Element.");
    }

    private static XMLSignature checkSignature(Element securityNode) throws WSSecurityException, XMLSignatureException {
        Element signatureNode = WSSecurity.getSignatureElement(securityNode);
        XMLSignature sig = WSSecurity.getXmlSignature(signatureNode);
        if (sig.getKeyInfo() == null) {
            throw new WSSecurityException(7);
        }
        return sig;
    }

    private static boolean acceptXmlSecurityConfiguration() {
        return Boolean.parseBoolean(System.getProperty(SYSTEM_PROPERTY_SKIP_SECURITY_CHECK)) || WSSecurity.isValidXmlSecurityConfiguration();
    }

    private static boolean isValidXmlSecurityConfiguration() {
        try {
            Canonicalizer.getInstance((String)"http://www.w3.org/2006/12/xml-c14n11");
            return false;
        }
        catch (InvalidCanonicalizerException e) {
            return true;
        }
    }

    static {
        System.setProperty("org.apache.xml.security.resource.config", "/xml-security-config.xml");
        Init.init();
        if (!WSSecurity.acceptXmlSecurityConfiguration()) {
            LOG.fatal((Object)"XML Security configuration not applied, set system property com.eucalyptus.crypto.util.skipWsSecurityConfigurationChecks=true to skip check");
            throw new RuntimeException("XML Security Configuration not applied");
        }
        useBc = false;
    }
}

