/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.crypto.util;

import com.eucalyptus.auth.login.AuthenticationException;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class Timestamps {
    private static final Logger LOG = Logger.getLogger(Timestamps.class);
    private static boolean allowTrailers = Boolean.parseBoolean(System.getProperty("com.eucalyptus.crypto.util.allowTimestampTrailers", "false"));
    private static final String iso8601TimestampWithMillisAndTimezone = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String iso8601Timestamp = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String iso8601ShortTimestamp = "yyyyMMdd'T'HHmmss'Z'";
    private static final String iso8601ShortDate = "yyyyMMdd";
    private static final List<PatternHolder> rfc2616 = ImmutableList.of((Object)new PatternHolder("EEE, dd MMM yyyy HH:mm:ss zzz"), (Object)new PatternHolder("EEEE, dd-MMM-yy HH:mm:ss zzz"), (Object)new PatternHolder("EEE MMM d HH:mm:ss yyyy"));
    static final List<PatternHolder> iso8601;

    public static Date parseIso8601Timestamp(String timestamp) throws AuthenticationException {
        return Timestamps.parseTimestamp(timestamp, iso8601);
    }

    public static Date parseRfc2616Timestamp(String timestamp) throws AuthenticationException {
        return Timestamps.parseTimestamp(timestamp, rfc2616);
    }

    public static Date parseTimestamp(String timestamp, Type type) throws AuthenticationException {
        return Timestamps.parseTimestamp(timestamp, type.patterns);
    }

    private static Date parseTimestamp(String timestamp, Iterable<PatternHolder> patterns) throws AuthenticationException {
        if (timestamp != null) {
            for (PatternHolder pattern : patterns) {
                ParsePosition position;
                Date parsed = pattern.parse(timestamp, position = new ParsePosition(0));
                if (parsed == null || position.getIndex() < timestamp.length() && !allowTrailers) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)("Parse of timestamp '" + timestamp + "' failed for pattern '" + pattern + "', at: " + position.getErrorIndex()));
                    continue;
                }
                return parsed;
            }
        }
        throw new AuthenticationException("Invalid timestamp format: " + timestamp);
    }

    public static String formatIso8601Timestamp(Date date) {
        return Timestamps.sdf(iso8601Timestamp).format(date);
    }

    public static String formatShortIso8601Timestamp(Date date) {
        return Timestamps.sdf(iso8601ShortTimestamp).format(date);
    }

    public static String formatShortIso8601Date(Date date) {
        return Timestamps.sdf(iso8601ShortDate).format(date);
    }

    public static String formatIso8601UTCLongDateMillisTimezone(Date date) {
        SimpleDateFormat format = Timestamps.sdf(iso8601TimestampWithMillisAndTimezone);
        return format.format(date);
    }

    private static SimpleDateFormat sdf(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    static /* synthetic */ List access$000() {
        return rfc2616;
    }

    static {
        ArrayList patterns = Lists.newArrayList((Object[])new String[]{"yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ssZ", iso8601TimestampWithMillisAndTimezone, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'Z", iso8601Timestamp, "yyyy-MM-dd'T'HH:mm:ss'Z'Z"});
        for (int i = 1; i < 10; ++i) {
            String pattern = "yyyy-MM-dd'T'HH:mm:ss." + Strings.repeat((String)"S", (int)i);
            patterns.add(pattern);
            patterns.add(pattern + "'Z'");
        }
        ArrayList generatedPatterns = Lists.newArrayList();
        for (String pattern : patterns) {
            for (Iso8601Variants variant : Iso8601Variants.values()) {
                generatedPatterns.add(PatternHolder.generate((String)variant.apply(pattern)));
            }
        }
        LOG.debug((Object)("Using ISO 8601 date patterns: " + generatedPatterns));
        iso8601 = ImmutableList.copyOf((Collection)generatedPatterns);
    }

    private static enum Iso8601Variants implements Function<String, String>
    {
        IDENTITY{

            public String apply(String pattern) {
                return pattern;
            }
        }
        ,
        SHORT{

            public String apply(String pattern) {
                return pattern.replaceAll(":|-", "");
            }
        };

    }

    private static final class PatternHolder {
        private final String pattern;
        private final int length;
        private final int fractionTrunction;
        private final int fractionPadding;

        private PatternHolder(String pattern) {
            this(pattern, -1);
        }

        private PatternHolder(String pattern, int length) {
            this.pattern = pattern;
            this.length = length;
            int precision = 0;
            for (char character : pattern.toCharArray()) {
                if (character != 'S') continue;
                ++precision;
            }
            this.fractionTrunction = Math.max(0, precision - 3);
            this.fractionPadding = precision == 0 ? 0 : Math.max(0, 3 - precision);
        }

        private static PatternHolder generate(String pattern) {
            String representativeInput = pattern;
            representativeInput = representativeInput.replace("'T'", "T");
            representativeInput = representativeInput.replace("'Z'", "U");
            representativeInput = representativeInput.replace("Z", "-0000");
            return new PatternHolder(pattern, representativeInput.length());
        }

        private Date parse(String timestamp, ParsePosition position) {
            Date result = null;
            if (this.length == -1 || this.length == timestamp.length() - position.getIndex()) {
                String timestampForParsing = timestamp;
                boolean valid = true;
                if (this.fractionTrunction > 0 || this.fractionPadding > 0) {
                    valid = false;
                    int fractionIndex = timestamp.indexOf(46);
                    if (this.fractionTrunction > 0) {
                        if (fractionIndex > 0 && timestamp.length() >= fractionIndex + 4 + this.fractionTrunction) {
                            timestampForParsing = timestamp.substring(0, fractionIndex + 1) + Strings.repeat((String)"0", (int)this.fractionTrunction) + timestamp.substring(fractionIndex + 1, fractionIndex + 4) + timestamp.substring(fractionIndex + 4 + this.fractionTrunction);
                            String unparsed = timestamp.substring(fractionIndex + 4, fractionIndex + 4 + this.fractionTrunction);
                            valid = this.isDigits(unparsed);
                        }
                    } else if (fractionIndex > 0 && timestamp.length() >= fractionIndex + 3 - this.fractionPadding) {
                        timestampForParsing = timestamp.substring(0, fractionIndex + (4 - this.fractionPadding)) + Strings.repeat((String)"0", (int)this.fractionPadding) + timestamp.substring(fractionIndex + (4 - this.fractionPadding));
                        valid = true;
                    }
                }
                if (valid) {
                    result = Timestamps.sdf(this.pattern).parse(timestampForParsing, position);
                }
            }
            if (result == null && position.getErrorIndex() < 0) {
                position.setErrorIndex(position.getIndex());
            }
            return result;
        }

        private boolean isDigits(String text) {
            boolean digits = true;
            for (char character : text.toCharArray()) {
                if (character >= '0' && character <= '9') continue;
                digits = false;
                break;
            }
            return digits;
        }

        public String toString() {
            return this.pattern;
        }
    }

    public static enum Type {
        RFC_2616(Timestamps.access$000()),
        ISO_8601(iso8601);

        private final List<PatternHolder> patterns;

        private Type(List<PatternHolder> patterns) {
            this.patterns = patterns;
        }
    }
}

