/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.crypto.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class SslUtils {
    private static final LoadingCache<SslCipherSuiteBuilderParams, String[]> SSL_CIPHER_LOOKUP = CacheBuilder.newBuilder().maximumSize(32L).build((CacheLoader)new CacheLoader<SslCipherSuiteBuilderParams, String[]>(){

        public String[] load(SslCipherSuiteBuilderParams params) {
            return SslCipherBuilder.ciphers().with(params.getCipherStrings()).enabledCipherSuites(params.getSupportedCipherSuites());
        }
    });

    public static String[] getEnabledCipherSuites(String cipherStrings, String[] supportedCipherSuites) {
        return (String[])SSL_CIPHER_LOOKUP.getUnchecked((Object)SslCipherSuiteBuilderParams.params(cipherStrings, supportedCipherSuites));
    }

    public static String[] getEnabledProtocols(String protocolsList, String[] supportedProtocols) {
        Iterable protocols = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)": ,")).omitEmptyStrings().trimResults().split((CharSequence)protocolsList);
        return (String[])Iterables.toArray((Iterable)Iterables.filter((Iterable)protocols, (Predicate)Predicates.in(Arrays.asList(supportedProtocols))), String.class);
    }

    static final class SslCipherBuilder {
        private final Set<String> cipherStringsSteps = Sets.newLinkedHashSet();
        private final Set<String> excludedCipherStrings = Sets.newHashSet();

        SslCipherBuilder() {
        }

        static SslCipherBuilder ciphers() {
            return new SslCipherBuilder();
        }

        SslCipherBuilder with(String cipherStrings) {
            return this.with(Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)": ,")).omitEmptyStrings().trimResults().split((CharSequence)cipherStrings));
        }

        SslCipherBuilder with(Iterable<String> cipherStrings) {
            Iterables.addAll(this.cipherStringsSteps, (Iterable)Iterables.filter(cipherStrings, (Predicate)Predicates.not((Predicate)CipherStringPrefixes.NOT)));
            Iterables.addAll(this.excludedCipherStrings, (Iterable)Iterables.transform((Iterable)Iterables.filter(cipherStrings, (Predicate)CipherStringPrefixes.NOT), CipherStringPrefixes.NOT.cleaner()));
            return this;
        }

        String[] enabledCipherSuites(String[] supportedCipherSuiteArray) {
            ImmutableList supportedCipherSuites = ImmutableList.copyOf((Object[])supportedCipherSuiteArray);
            ImmutableList<String> excludedCipherSuites = this.explodeCipherStrings(this.excludedCipherStrings, (ImmutableList<String>)supportedCipherSuites);
            ArrayList cipherSuites = Lists.newArrayList();
            for (String cipherString : this.cipherStringsSteps) {
                if (CipherStringPrefixes.PLUS.apply(cipherString)) {
                    String cipherStringToShift = (String)CipherStringPrefixes.PLUS.cleaner().apply((Object)cipherString);
                    this.shift(cipherSuites, (List<String>)this.explodeCipherStrings(Collections.singleton(cipherStringToShift), (ImmutableList<String>)supportedCipherSuites));
                    continue;
                }
                cipherSuites.addAll(this.explodeCipherStrings(Collections.singleton(cipherString), (ImmutableList<String>)supportedCipherSuites));
            }
            return (String[])Iterables.toArray((Iterable)Iterables.filter((Iterable)cipherSuites, (Predicate)Predicates.and((Predicate)Predicates.in((Collection)supportedCipherSuites), (Predicate)Predicates.not((Predicate)Predicates.in(excludedCipherSuites)))), String.class);
        }

        void shift(List<String> cipherSuites, List<String> ciphersSuitesToShift) {
            for (String cipherSuite : ciphersSuitesToShift) {
                if (!cipherSuites.remove(cipherSuite)) continue;
                cipherSuites.add(cipherSuite);
            }
        }

        private ImmutableList<String> explodeCipherStrings(Set<String> cipherStrings, ImmutableList<String> supportedCipherSuites) {
            return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(cipherStrings, this.cipherStringExploder(supportedCipherSuites))));
        }

        private Function<String, Iterable<String>> cipherStringExploder(final ImmutableList<String> supportedCipherSuites) {
            return new Function<String, Iterable<String>>(){

                public Iterable<String> apply(String cipherString) {
                    if ("ALL".equals(cipherString)) {
                        return supportedCipherSuites;
                    }
                    if (cipherString.startsWith("TLS_") || cipherString.startsWith("SSL_")) {
                        return Collections.singleton(cipherString);
                    }
                    return Iterables.filter((Iterable)supportedCipherSuites, (Predicate)SslCipherBuilder.this.toPredicate(cipherString));
                }
            };
        }

        private Predicate<CharSequence> toPredicate(String cipherString) {
            ArrayList predicates = Lists.newArrayList();
            for (String cipherStringPart : Splitter.on((String)"+").split((CharSequence)cipherString)) {
                predicates.add(Predicates.contains((Pattern)Pattern.compile("_" + Pattern.quote(cipherStringPart) + "(_|$)")));
            }
            return Predicates.and((Iterable)predicates);
        }

        private static enum CipherStringPrefixes implements Predicate<String>
        {
            NOT("!"),
            PLUS("+");

            private final String prefix;

            private CipherStringPrefixes(String prefix) {
                this.prefix = prefix;
            }

            public boolean apply(String value) {
                return value.startsWith(this.prefix);
            }

            public Function<String, String> cleaner() {
                return new Function<String, String>(){

                    public String apply(String value) {
                        return value.substring(1);
                    }
                };
            }
        }
    }

    static final class SslCipherSuiteBuilderParams {
        private final String cipherStrings;
        private final String[] supportedCipherSuites;

        private SslCipherSuiteBuilderParams(String cipherStrings, String[] supportedCipherSuites) {
            this.cipherStrings = cipherStrings;
            this.supportedCipherSuites = (String[])supportedCipherSuites.clone();
        }

        public String getCipherStrings() {
            return this.cipherStrings;
        }

        public String[] getSupportedCipherSuites() {
            return this.supportedCipherSuites;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SslCipherSuiteBuilderParams that = (SslCipherSuiteBuilderParams)o;
            if (!this.cipherStrings.equals(that.cipherStrings)) {
                return false;
            }
            return Arrays.equals(this.supportedCipherSuites, that.supportedCipherSuites);
        }

        public int hashCode() {
            int result = this.cipherStrings.hashCode();
            result = 31 * result + Arrays.hashCode(this.supportedCipherSuites);
            return result;
        }

        static SslCipherSuiteBuilderParams params(String cipherStrings, String[] supportedCipherSuites) {
            return new SslCipherSuiteBuilderParams(cipherStrings, supportedCipherSuites);
        }
    }
}

