/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.crypto.util;

import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.auth.SystemCredentials;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.configurable.PropertyChangeListeners;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.util.AbstractKeyStore;
import com.eucalyptus.crypto.util.BCSslSetup;
import com.eucalyptus.crypto.util.DelegatingX509ExtendedTrustManager;
import com.eucalyptus.crypto.util.SSLSocketFactoryWrapper;
import com.eucalyptus.crypto.util.SslUtils;
import com.eucalyptus.system.SubDirectory;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.IO;
import com.eucalyptus.util.Pair;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.sun.net.ssl.internal.ssl.X509ExtendedTrustManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.log4j.Logger;

@ConfigurableClass(root="bootstrap.webservices.ssl", description="Parameters controlling the SSL configuration for the web services endpoint.")
public class SslSetup {
    private static final Logger LOG;
    private static final String PROTOCOL = "TLS";
    private static SSLContext SERVER_CONTEXT;
    private static SSLContext CLIENT_CONTEXT;
    @ConfigurableField(description="Alias of the certificate entry in euca.p12 to use for SSL for webservices.", changeListener=SslCertChangeListener.class)
    public static String SERVER_ALIAS;
    @ConfigurableField(description="Password of the private key corresponding to the specified certificate for SSL for webservices.", type=ConfigurableFieldType.KEYVALUEHIDDEN, changeListener=SslPasswordChangeListener.class)
    public static String SERVER_PASSWORD;
    @ConfigurableField(description="SSL ciphers for webservices.")
    public static String SERVER_SSL_CIPHERS;
    @ConfigurableField(description="SSL protocols for webservices.")
    public static String SERVER_SSL_PROTOCOLS;
    @ConfigurableField(description="Use default CAs with SSL for external use.", changeListener=PropertyChangeListeners.IsBoolean.class)
    public static Boolean USER_SSL_DEFAULT_CAS;
    @ConfigurableField(description="SSL ciphers for external use.")
    public static String USER_SSL_CIPHERS;
    @ConfigurableField(description="SSL protocols for external use.")
    public static String USER_SSL_PROTOCOLS;
    @ConfigurableField(description="SSL hostname validation for external use.", changeListener=PropertyChangeListeners.IsBoolean.class)
    public static Boolean USER_SSL_ENABLE_HOSTNAME_VERIFICATION;
    private static final Supplier<PrivateKey> serverPrivateKeySupplier;
    private static final Supplier<X509Certificate[]> serverCertSupplier;
    private static Supplier<PrivateKey> memoizedPrivateKeySupplier;
    private static Supplier<X509Certificate[]> memoizedServerCertSupplier;
    private static PrivateKey trustedKey;
    private static X509Certificate[] trustedCerts;

    private static SSLContext createServerContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext serverContext = SSLContext.getInstance(PROTOCOL);
        serverContext.init(ServerKeyManager.getKeyManagers(), ServerTrustManager.getTrustManagers(), null);
        return serverContext;
    }

    public static SSLContext getServerContext() {
        return SERVER_CONTEXT;
    }

    public static SSLEngine getServerEngine() {
        SSLEngine engine = SslSetup.getServerContext().createSSLEngine();
        engine.setUseClientMode(false);
        engine.setWantClientAuth(false);
        engine.setNeedClientAuth(false);
        engine.setEnabledProtocols(SslUtils.getEnabledProtocols(SERVER_SSL_PROTOCOLS, engine.getSupportedProtocols()));
        engine.setEnabledCipherSuites(SslUtils.getEnabledCipherSuites(SERVER_SSL_CIPHERS, engine.getSupportedCipherSuites()));
        return engine;
    }

    public static URLConnection configureHttpsUrlConnection(URLConnection urlConnection) {
        if (urlConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)urlConnection;
            httpsURLConnection.setHostnameVerifier((HostnameVerifier)((Boolean)Objects.firstNonNull((Object)USER_SSL_ENABLE_HOSTNAME_VERIFICATION, (Object)Boolean.TRUE) != false ? new BrowserCompatHostnameVerifier() : new AllowAllHostnameVerifier()));
            httpsURLConnection.setSSLSocketFactory(UserSSLSocketFactory.get());
        }
        return urlConnection;
    }

    public static SSLContext getClientContext() {
        return CLIENT_CONTEXT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate[] getTrustedCertificates() {
        try {
            Class<SslSetup> clazz = SslSetup.class;
            synchronized (SslSetup.class) {
                if (trustedCerts == null) {
                    trustedCerts = SystemCredentials.getKeyStore().getAllCertificates().toArray(new X509Certificate[0]);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return trustedCerts;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey getTrustedKey() {
        try {
            Class<SslSetup> clazz = SslSetup.class;
            synchronized (SslSetup.class) {
                if (trustedKey == null) {
                    trustedKey = SystemCredentials.getKeyStore().getKeyPair(ComponentIds.lookup(Eucalyptus.class).name(), ComponentIds.lookup(Eucalyptus.class).name()).getPrivate();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return trustedKey;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static {
        SSLContext clientContext;
        SSLContext serverContext;
        LOG = Logger.getLogger(SslSetup.class);
        SERVER_CONTEXT = null;
        CLIENT_CONTEXT = null;
        SERVER_ALIAS = ComponentIds.lookup(Eucalyptus.class).name();
        SERVER_PASSWORD = ComponentIds.lookup(Eucalyptus.class).name();
        SERVER_SSL_CIPHERS = "RSA:DSS:ECDSA:+RC4:+3DES:TLS_EMPTY_RENEGOTIATION_INFO_SCSV:!NULL:!EXPORT:!EXPORT1024:!MD5:!DES";
        SERVER_SSL_PROTOCOLS = "SSLv2Hello,TLSv1,TLSv1.1,TLSv1.2";
        USER_SSL_DEFAULT_CAS = true;
        USER_SSL_CIPHERS = "RSA:DSS:ECDSA:+RC4:+3DES:TLS_EMPTY_RENEGOTIATION_INFO_SCSV:!NULL:!EXPORT:!EXPORT1024:!MD5:!DES";
        USER_SSL_PROTOCOLS = "SSLv2Hello,TLSv1,TLSv1.1,TLSv1.2";
        USER_SSL_ENABLE_HOSTNAME_VERIFICATION = true;
        BCSslSetup.initBouncyCastleDHParams();
        System.setProperty("javax.net.ssl.trustStore", SubDirectory.KEYS.toString() + File.separator + "euca.p12");
        System.setProperty("javax.net.ssl.keyStore", SubDirectory.KEYS.toString() + File.separator + "euca.p12");
        System.setProperty("javax.net.ssl.trustStoreType", "PKCS12");
        System.setProperty("javax.net.ssl.keyStoreType", "PKCS12");
        System.setProperty("javax.net.ssl.trustStorePassword", ComponentIds.lookup(Eucalyptus.class).name());
        System.setProperty("javax.net.ssl.keyStorePassword", ComponentIds.lookup(Eucalyptus.class).name());
        try {
            serverContext = SslSetup.createServerContext();
        }
        catch (Exception e) {
            LOG.debug((Object)e, (Throwable)e);
            throw new Error("Failed to initialize the server-side SSLContext", e);
        }
        try {
            clientContext = SSLContext.getInstance(PROTOCOL);
            clientContext.init(ClientKeyManager.getKeyManagers(), ClientTrustManager.getTrustManagers(), null);
        }
        catch (Exception e) {
            LOG.debug((Object)e, (Throwable)e);
            throw new Error("Failed to initialize the client-side SSLContext", e);
        }
        SERVER_CONTEXT = serverContext;
        CLIENT_CONTEXT = clientContext;
        serverPrivateKeySupplier = new Supplier<PrivateKey>(){

            public PrivateKey get() {
                try {
                    return SystemCredentials.getKeyStore().getKeyPair(SERVER_ALIAS, SERVER_ALIAS).getPrivate();
                }
                catch (GeneralSecurityException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    return null;
                }
            }
        };
        serverCertSupplier = new Supplier<X509Certificate[]>(){

            public X509Certificate[] get() {
                X509Certificate[] certs = (X509Certificate[])ObjectArrays.newArray(X509Certificate.class, (int)1);
                try {
                    certs[0] = SystemCredentials.getKeyStore().getCertificate(SERVER_ALIAS);
                    return certs;
                }
                catch (GeneralSecurityException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    return certs;
                }
            }
        };
        memoizedPrivateKeySupplier = Suppliers.memoizeWithExpiration(serverPrivateKeySupplier, (long)15L, (TimeUnit)TimeUnit.SECONDS);
        memoizedServerCertSupplier = Suppliers.memoizeWithExpiration(serverCertSupplier, (long)15L, (TimeUnit)TimeUnit.SECONDS);
        trustedKey = SslSetup.getTrustedKey();
        trustedCerts = SslSetup.getTrustedCertificates();
    }

    public static class UserSSLSocketFactory
    extends SSLSocketFactoryWrapper {
        private static final String PROP_USER_SSL_PROVIDER = "com.eucalyptus.crypto.util.userSslProvider";
        private static final String PROP_USER_SSL_PROTOCOL = "com.eucalyptus.crypto.util.userSslProtocol";
        private static final String PROP_USER_SSL_TRUSTSTORE_PASSWORD = "com.eucalyptus.crypto.util.userSslTrustStorePassword";
        private static final String PROP_USER_SSL_TRUSTSTORE_TYPE = "com.eucalyptus.crypto.util.userSslTrustStoreType";
        private static final String PROP_USER_SSL_TRUSTSTORE_PATH = "com.eucalyptus.crypto.util.userSslTrustStorePath";
        private static final String DEFAULT_PROTOCOL = "TLS";
        private static final String DEFAULT_TRUSTSTORE_PASSWORD = "changeit";
        private static final String DEFAULT_TRUSTSTORE_PATH = "lib/security/cacerts";
        private final List<String> cipherSuites = ImmutableList.copyOf((Object[])SslUtils.getEnabledCipherSuites(USER_SSL_CIPHERS, this.getSupportedCipherSuites()));
        private static final AtomicReference<Pair<Long, KeyStore>> sslTrustStore = new AtomicReference();
        private static final Supplier<UserSSLSocketFactory> supplier = new Supplier<UserSSLSocketFactory>(){

            public UserSSLSocketFactory get() {
                return new UserSSLSocketFactory();
            }
        };
        private static final Supplier<UserSSLSocketFactory> memoizedSupplier = Suppliers.memoizeWithExpiration(supplier, (long)60L, (TimeUnit)TimeUnit.SECONDS);

        public static UserSSLSocketFactory get() {
            return (UserSSLSocketFactory)memoizedSupplier.get();
        }

        public UserSSLSocketFactory() {
            super((Supplier<SSLSocketFactory>)Suppliers.ofInstance((Object)UserSSLSocketFactory.buildDelegate()));
        }

        @Override
        protected Socket notifyCreated(Socket socket) {
            if (socket instanceof SSLSocket) {
                SSLSocket sslSocket = (SSLSocket)socket;
                sslSocket.setEnabledCipherSuites((String[])Iterables.toArray(this.cipherSuites, String.class));
                sslSocket.setEnabledProtocols(SslUtils.getEnabledProtocols(USER_SSL_PROTOCOLS, sslSocket.getSupportedProtocols()));
            }
            return socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static KeyStore getTrustStore(File trustStore) throws GeneralSecurityException, IOException {
            KeyStore keyStore;
            Pair<Long, KeyStore> currentTrustStore = sslTrustStore.get();
            FileInputStream trustStoreIn = null;
            if (currentTrustStore != null && currentTrustStore.getLeft().longValue() == trustStore.lastModified()) {
                return currentTrustStore.getRight();
            }
            try {
                String trustStoreType = System.getProperty(PROP_USER_SSL_TRUSTSTORE_TYPE, KeyStore.getDefaultType());
                String trustStorePassword = System.getProperty(PROP_USER_SSL_TRUSTSTORE_PASSWORD, DEFAULT_TRUSTSTORE_PASSWORD);
                KeyStore userTrustStore = KeyStore.getInstance(trustStoreType);
                trustStoreIn = new FileInputStream(trustStore);
                userTrustStore.load(trustStoreIn, trustStorePassword.toCharArray());
                sslTrustStore.set(Pair.pair(trustStore.lastModified(), userTrustStore));
                keyStore = userTrustStore;
            }
            catch (Throwable throwable) {
                IO.close(trustStoreIn);
                throw throwable;
            }
            IO.close(trustStoreIn);
            return keyStore;
        }

        private static List<TrustManager> trustManagersForStore(KeyStore trustStore) throws GeneralSecurityException {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX", "SunJSSE");
            trustManagerFactory.init(trustStore);
            return Arrays.asList(trustManagerFactory.getTrustManagers());
        }

        private static SSLSocketFactory buildDelegate() {
            String provider = System.getProperty(PROP_USER_SSL_PROVIDER);
            String protocol = System.getProperty(PROP_USER_SSL_PROTOCOL, "TLS");
            String trustStorePath = System.getProperty(PROP_USER_SSL_TRUSTSTORE_PATH, DEFAULT_TRUSTSTORE_PATH);
            try {
                SSLContext sslContext = provider != null ? SSLContext.getInstance(protocol, provider) : SSLContext.getInstance(protocol);
                ArrayList trustManagers = Lists.newArrayList();
                trustManagers.addAll(UserSSLSocketFactory.trustManagersForStore(((AbstractKeyStore)SystemCredentials.getKeyStore()).getKeyStore()));
                File trustStore = new File(System.getProperty("java.home"), trustStorePath);
                if (((Boolean)Objects.firstNonNull((Object)USER_SSL_DEFAULT_CAS, (Object)false)).booleanValue() && trustStore.isFile()) {
                    trustManagers.addAll(UserSSLSocketFactory.trustManagersForStore(UserSSLSocketFactory.getTrustStore(trustStore)));
                }
                sslContext.init(null, new TrustManager[]{new DelegatingX509ExtendedTrustManager(Iterables.transform((Iterable)Iterables.filter((Iterable)trustManagers, (Predicate)Predicates.instanceOf(javax.net.ssl.X509ExtendedTrustManager.class)), CollectionUtils.cast(javax.net.ssl.X509ExtendedTrustManager.class)))}, (SecureRandom)Crypto.getSecureRandomSupplier().get());
                return sslContext.getSocketFactory();
            }
            catch (IOException | GeneralSecurityException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    static class ServerTrustManager
    extends TrustManagerFactorySpi {
        private static final TrustManager singleton = new SimpleX509TrustManager();

        ServerTrustManager() {
        }

        public static TrustManager[] getTrustManagers() {
            return new TrustManager[]{singleton};
        }

        @Override
        protected TrustManager[] engineGetTrustManagers() {
            return ServerTrustManager.getTrustManagers();
        }

        @Override
        protected void engineInit(KeyStore keystore) throws KeyStoreException {
        }

        @Override
        protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        }

        public static class SimpleX509TrustManager
        extends X509ExtendedTrustManager {
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return (X509Certificate[])serverCertSupplier.get();
            }

            public void checkClientTrusted(X509Certificate[] arg0, String arg1, String arg2, String arg3) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] arg0, String arg1, String arg2, String arg3) throws CertificateException {
            }
        }
    }

    public static class ClientTrustManager
    extends TrustManagerFactorySpi {
        private static final TrustManager singleton = new SimpleX509TrustManager();

        public static TrustManager[] getTrustManagers() {
            return new TrustManager[]{singleton};
        }

        @Override
        protected TrustManager[] engineGetTrustManagers() {
            return ClientTrustManager.getTrustManagers();
        }

        @Override
        protected void engineInit(KeyStore keystore) throws KeyStoreException {
        }

        @Override
        protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        }

        public static class SimpleX509TrustManager
        extends X509ExtendedTrustManager {
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return trustedCerts;
            }

            public void checkClientTrusted(X509Certificate[] arg0, String arg1, String arg2, String arg3) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] arg0, String arg1, String arg2, String arg3) throws CertificateException {
            }
        }
    }

    static class ServerKeyManager
    extends KeyManagerFactorySpi {
        private static KeyManager singleton = new ServerPKCS12KeyManager();

        ServerKeyManager() {
        }

        public static KeyManager[] getKeyManagers() {
            return new KeyManager[]{singleton};
        }

        @Override
        protected KeyManager[] engineGetKeyManagers() {
            return new KeyManager[]{singleton};
        }

        @Override
        protected void engineInit(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
        }

        @Override
        protected void engineInit(KeyStore ks, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        }

        static class ServerPKCS12KeyManager
        extends X509ExtendedKeyManager {
            ServerPKCS12KeyManager() {
            }

            @Override
            public String chooseClientAlias(String[] arg0, Principal[] arg1, Socket arg2) {
                return SERVER_ALIAS;
            }

            @Override
            public String chooseServerAlias(String arg0, Principal[] arg1, Socket arg2) {
                return SERVER_ALIAS;
            }

            @Override
            public X509Certificate[] getCertificateChain(String arg0) {
                if (SERVER_ALIAS.equals(arg0)) {
                    return (X509Certificate[])memoizedServerCertSupplier.get();
                }
                return null;
            }

            @Override
            public String[] getClientAliases(String arg0, Principal[] arg1) {
                return new String[]{SERVER_ALIAS};
            }

            @Override
            public PrivateKey getPrivateKey(String arg0) {
                if (SERVER_ALIAS.equals(arg0)) {
                    return (PrivateKey)memoizedPrivateKeySupplier.get();
                }
                return null;
            }

            @Override
            public String[] getServerAliases(String arg0, Principal[] arg1) {
                return new String[]{SERVER_ALIAS};
            }

            @Override
            public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
                return SERVER_ALIAS;
            }

            @Override
            public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
                return SERVER_ALIAS;
            }
        }
    }

    static class ClientKeyManager
    extends KeyManagerFactorySpi {
        private static KeyManager singleton = new ClientPKCS12KeyManager();

        ClientKeyManager() {
        }

        public static KeyManager[] getKeyManagers() {
            return new KeyManager[]{singleton};
        }

        @Override
        protected KeyManager[] engineGetKeyManagers() {
            return new KeyManager[]{singleton};
        }

        @Override
        protected void engineInit(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
        }

        @Override
        protected void engineInit(KeyStore ks, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        }

        static class ClientPKCS12KeyManager
        extends X509ExtendedKeyManager {
            ClientPKCS12KeyManager() {
            }

            @Override
            public String chooseClientAlias(String[] arg0, Principal[] arg1, Socket arg2) {
                return ComponentIds.lookup(Eucalyptus.class).name();
            }

            @Override
            public String chooseServerAlias(String arg0, Principal[] arg1, Socket arg2) {
                return ComponentIds.lookup(Eucalyptus.class).name();
            }

            @Override
            public X509Certificate[] getCertificateChain(String arg0) {
                if (ComponentIds.lookup(Eucalyptus.class).name().equals(arg0)) {
                    return trustedCerts;
                }
                return null;
            }

            @Override
            public String[] getClientAliases(String arg0, Principal[] arg1) {
                return new String[]{ComponentIds.lookup(Eucalyptus.class).name()};
            }

            @Override
            public PrivateKey getPrivateKey(String arg0) {
                if (ComponentIds.lookup(Eucalyptus.class).name().equals(arg0)) {
                    return trustedKey;
                }
                return null;
            }

            @Override
            public String[] getServerAliases(String arg0, Principal[] arg1) {
                return new String[]{ComponentIds.lookup(Eucalyptus.class).name()};
            }

            @Override
            public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
                return ComponentIds.lookup(Eucalyptus.class).name();
            }

            @Override
            public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
                return ComponentIds.lookup(Eucalyptus.class).name();
            }
        }
    }

    public static class SslPasswordChangeListener
    implements PropertyChangeListener<String> {
        @Override
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            if (SERVER_PASSWORD != null && !SERVER_PASSWORD.equals(newValue)) {
                try {
                    String oldValue = SERVER_PASSWORD;
                    SSLContext newContext = SslSetup.createServerContext();
                    SERVER_PASSWORD = newValue;
                    SERVER_CONTEXT = newContext;
                }
                catch (Exception ex) {
                    throw new ConfigurablePropertyException(ex);
                }
            }
        }
    }

    public static class SslCertChangeListener
    implements PropertyChangeListener<String> {
        @Override
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            if (SERVER_ALIAS != null && !SERVER_ALIAS.equals(newValue)) {
                try {
                    String oldValue = SERVER_ALIAS;
                    SSLContext newContext = SslSetup.createServerContext();
                    SERVER_ALIAS = newValue;
                    SERVER_CONTEXT = newContext;
                }
                catch (Exception ex) {
                    throw new ConfigurablePropertyException(ex);
                }
            }
        }
    }
}

