/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.crypto.util;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

public class SimpleClientX509TrustManager
implements X509TrustManager {
    private final X509Certificate trustedCertificate;
    private final boolean checkValidity;

    public SimpleClientX509TrustManager(X509Certificate trustedCertificate, boolean checkValidity) {
        this.trustedCertificate = trustedCertificate;
        this.checkValidity = checkValidity;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        throw new IllegalStateException("This trust manager is for client use only.");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || chain.length < 1) {
            throw new IllegalArgumentException("Certificate chain invalid");
        }
        if (!this.trustedCertificate.equals(chain[0])) {
            throw new CertificateException("Certificate not trusted: " + chain[0].getSubjectX500Principal().getName());
        }
        if (this.checkValidity) {
            this.trustedCertificate.checkValidity();
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

