/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.crypto.util;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;

public class SSLSocketFactoryWrapper
extends SSLSocketFactory {
    private final Supplier<SSLSocketFactory> delegate;

    public SSLSocketFactoryWrapper(Supplier<SSLSocketFactory> delegate) {
        this.delegate = delegate;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate().getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate().getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.notifyCreated(this.delegate().createSocket(socket, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.notifyCreated(this.delegate().createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.notifyCreated(this.delegate().createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.notifyCreated(this.delegate().createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.notifyCreated(this.delegate().createSocket(address, port, localAddress, localPort));
    }

    protected Socket notifyCreated(Socket socket) {
        return socket;
    }

    private SSLSocketFactory delegate() {
        return (SSLSocketFactory)this.delegate.get();
    }
}

