/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.crypto.util;

import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.KeyPair;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.io.pem.PemObject;

public class PEMFiles {
    private static Logger LOG = Logger.getLogger(PEMFiles.class);

    public static String fromCertificate(X509Certificate x509) {
        return B64.url.encString(PEMFiles.getBytes(x509));
    }

    public static X509Certificate toCertificate(String x509PemString) {
        return PEMFiles.getCert(B64.url.dec(x509PemString));
    }

    public static String fromKeyPair(KeyPair keyPair) {
        return B64.url.encString(PEMFiles.getBytes(keyPair));
    }

    public static KeyPair toKeyPair(String keyPairB64PemString) {
        return PEMFiles.getKeyPair(B64.url.dec(keyPairB64PemString));
    }

    public static void write(String fileName, Object securityToken) {
        PEMWriter privOut = null;
        try {
            privOut = new PEMWriter((Writer)new FileWriter(fileName));
            EventRecord.caller(PEMFiles.class, EventType.CERTIFICATE_WRITE, fileName).info();
            privOut.writeObject(securityToken);
            privOut.close();
        }
        catch (IOException e) {
            LOG.error((Object)e, (Throwable)e);
        }
    }

    public static byte[] getBytes(Object o) {
        ByteArrayOutputStream pemByteOut = new ByteArrayOutputStream();
        try {
            PEMWriter pemOut = new PEMWriter((Writer)new OutputStreamWriter(pemByteOut));
            pemOut.writeObject(o);
            pemOut.close();
        }
        catch (IOException e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return pemByteOut.toByteArray();
    }

    public static byte[] getBytes(String type, byte[] bytes) {
        return PEMFiles.getBytes(new PemObject(type, bytes));
    }

    public static X509Certificate getCert(byte[] o) {
        X509Certificate x509 = null;
        ByteArrayInputStream pemByteIn = new ByteArrayInputStream(o);
        try (PEMParser in = new PEMParser((Reader)new InputStreamReader(pemByteIn));){
            x509 = new JcaX509CertificateConverter().setProvider("BC").getCertificate((X509CertificateHolder)in.readObject());
        }
        catch (IOException | CertificateException e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return x509;
    }

    public static KeyPair getKeyPair(byte[] o) {
        KeyPair keyPair = null;
        ByteArrayInputStream pemByteIn = new ByteArrayInputStream(o);
        try (PEMParser in = new PEMParser((Reader)new InputStreamReader(pemByteIn));){
            keyPair = new JcaPEMKeyConverter().setProvider("BC").getKeyPair((PEMKeyPair)in.readObject());
        }
        catch (IOException e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return keyPair;
    }
}

