/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.crypto.util;

import com.eucalyptus.util.CollectionUtils;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;

public class DelegatingX509ExtendedTrustManager
extends X509ExtendedTrustManager {
    private final List<X509ExtendedTrustManager> delegates;

    public DelegatingX509ExtendedTrustManager(Iterable<X509ExtendedTrustManager> delegates) {
        this.delegates = ImmutableList.copyOf(delegates);
    }

    @Override
    public void checkClientTrusted(final X509Certificate[] chain, final String authType) throws CertificateException {
        this.checkTrusted(new DelegatedTrustChecker(){

            @Override
            public void checkTrusted(X509ExtendedTrustManager trustManager) throws CertificateException {
                trustManager.checkClientTrusted(chain, authType);
            }
        });
    }

    @Override
    public void checkServerTrusted(final X509Certificate[] chain, final String authType) throws CertificateException {
        this.checkTrusted(new DelegatedTrustChecker(){

            @Override
            public void checkTrusted(X509ExtendedTrustManager trustManager) throws CertificateException {
                trustManager.checkServerTrusted(chain, authType);
            }
        });
    }

    @Override
    public void checkClientTrusted(final X509Certificate[] chain, final String authType, final Socket socket) throws CertificateException {
        this.checkTrusted(new DelegatedTrustChecker(){

            @Override
            public void checkTrusted(X509ExtendedTrustManager trustManager) throws CertificateException {
                trustManager.checkClientTrusted(chain, authType, socket);
            }
        });
    }

    @Override
    public void checkServerTrusted(final X509Certificate[] chain, final String authType, final Socket socket) throws CertificateException {
        this.checkTrusted(new DelegatedTrustChecker(){

            @Override
            public void checkTrusted(X509ExtendedTrustManager trustManager) throws CertificateException {
                trustManager.checkServerTrusted(chain, authType, socket);
            }
        });
    }

    @Override
    public void checkClientTrusted(final X509Certificate[] chain, final String authType, final SSLEngine sslEngine) throws CertificateException {
        this.checkTrusted(new DelegatedTrustChecker(){

            @Override
            public void checkTrusted(X509ExtendedTrustManager trustManager) throws CertificateException {
                trustManager.checkClientTrusted(chain, authType, sslEngine);
            }
        });
    }

    @Override
    public void checkServerTrusted(final X509Certificate[] chain, final String authType, final SSLEngine sslEngine) throws CertificateException {
        this.checkTrusted(new DelegatedTrustChecker(){

            @Override
            public void checkTrusted(X509ExtendedTrustManager trustManager) throws CertificateException {
                trustManager.checkServerTrusted(chain, authType, sslEngine);
            }
        });
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        LinkedHashSet issuers = Sets.newLinkedHashSet();
        for (X509ExtendedTrustManager delegate : this.delegates) {
            issuers.addAll(Arrays.asList(delegate.getAcceptedIssuers()));
        }
        return issuers.toArray(new X509Certificate[issuers.size()]);
    }

    private void checkTrusted(final DelegatedTrustChecker checker) throws CertificateException {
        Optional<CertificateException> resultException = CollectionUtils.reduce(this.delegates, Optional.of((Object)new CertificateException("No delegates")), new Function<Optional<CertificateException>, Function<X509ExtendedTrustManager, Optional<CertificateException>>>(){

            public Function<X509ExtendedTrustManager, Optional<CertificateException>> apply(final Optional<CertificateException> previousException) {
                return new Function<X509ExtendedTrustManager, Optional<CertificateException>>(){

                    public Optional<CertificateException> apply(X509ExtendedTrustManager trustManager) {
                        Optional resultException = Optional.absent();
                        if (previousException.isPresent()) {
                            try {
                                checker.checkTrusted(trustManager);
                            }
                            catch (CertificateException e) {
                                resultException = Optional.of((Object)e);
                            }
                        }
                        return resultException;
                    }
                };
            }
        });
        if (resultException.isPresent()) {
            throw (CertificateException)resultException.get();
        }
    }

    private static interface DelegatedTrustChecker {
        public void checkTrusted(X509ExtendedTrustManager var1) throws CertificateException;
    }
}

