/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.crypto.util;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Hashtable;
import javax.crypto.spec.DHParameterSpec;
import org.apache.log4j.Logger;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.jcajce.provider.asymmetric.dh.KeyPairGeneratorSpi;

class BCSslSetup {
    private static Logger logger = Logger.getLogger(BCSslSetup.class);
    private static final ImmutableList<DHParameterSpec> parameterSpecs = ImmutableList.of((Object)BCSslSetup.parameterSpec("FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD129024E08 8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DDEF9519B3 CD3A431B 302B0A6D F25F1437 4FE1356D 6D51C245E485B576 625E7EC6 F44C42E9 A63A3620 FFFFFFFF FFFFFFFF", 2, 768), (Object)BCSslSetup.parameterSpec("FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD129024E08 8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DDEF9519B3 CD3A431B 302B0A6D F25F1437 4FE1356D 6D51C245E485B576 625E7EC6 F44C42E9 A637ED6B 0BFF5CB6 F406B7EDEE386BFB 5A899FA5 AE9F2411 7C4B1FE6 49286651 ECE65381FFFFFFFF FFFFFFFF", 2, 1024));

    BCSslSetup() {
    }

    private static DHParameterSpec parameterSpec(String primeModulusHex, int baseGenerator, int sizeInBits) {
        BigInteger p = new BigInteger(primeModulusHex.replace(" ", ""), 16);
        BigInteger g = BigInteger.valueOf(baseGenerator);
        return new DHParameterSpec(p, g, sizeInBits);
    }

    static void initBouncyCastleDHParams() {
        try {
            BCSslSetup.initBouncyCastleDHParamsInternal();
        }
        catch (Throwable e) {
            logger.error((Object)e, e);
        }
    }

    static void initBouncyCastleDHParamsInternal() throws NoSuchFieldException, IllegalAccessException {
        Class<KeyPairGeneratorSpi> DH = KeyPairGeneratorSpi.class;
        Field paramsField = DH.getDeclaredField("params");
        paramsField.setAccessible(true);
        Hashtable params = (Hashtable)paramsField.get(null);
        if (params.isEmpty()) {
            SecureRandom random = new SecureRandom();
            for (DHParameterSpec parameterSpec : parameterSpecs) {
                params.put(parameterSpec.getL(), new DHKeyGenerationParameters(random, new DHParameters(parameterSpec.getP(), parameterSpec.getG(), null, 0)));
            }
        }
    }
}

