/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.crypto.util;

import com.eucalyptus.crypto.KeyStore;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractKeyStore
implements KeyStore {
    private static Logger LOG = Logger.getLogger(AbstractKeyStore.class);
    private java.security.KeyStore keyStore;
    private final String fileName;
    private final String password;
    private final String format;

    public static AbstractKeyStore getGenericKeystore(String fileName, String password, String format) throws IOException, GeneralSecurityException {
        return new GenericKeyStore(fileName, password, format);
    }

    public AbstractKeyStore(String fileName, String password, String format) throws GeneralSecurityException, IOException {
        this.password = password;
        this.fileName = fileName;
        this.format = format;
        this.init();
    }

    @Override
    public KeyPair getKeyPair(String alias, String password) throws GeneralSecurityException {
        Certificate cert = this.keyStore.getCertificate(alias);
        PrivateKey privateKey = (PrivateKey)this.keyStore.getKey(alias, password.toCharArray());
        KeyPair kp = new KeyPair(cert.getPublicKey(), privateKey);
        return kp;
    }

    @Override
    public abstract boolean check() throws GeneralSecurityException;

    @Override
    public boolean containsEntry(String alias) {
        try {
            if ((X509Certificate)this.keyStore.getCertificate(alias) != null) {
                return true;
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public X509Certificate getCertificate(String alias) throws GeneralSecurityException {
        return (X509Certificate)this.keyStore.getCertificate(alias);
    }

    @Override
    public Key getKey(String alias, String password) throws GeneralSecurityException {
        return this.keyStore.getKey(alias, password.toCharArray());
    }

    @Override
    public String getCertificateAlias(String certPem) throws GeneralSecurityException {
        X509Certificate cert = AbstractKeyStore.pemToX509(certPem);
        return this.keyStore.getCertificateAlias(cert);
    }

    public static X509Certificate pemToX509(String certPem) throws CertificateException, NoSuchProviderException {
        CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate cert = (X509Certificate)certificatefactory.generateCertificate(new ByteArrayInputStream(certPem.getBytes()));
        return cert;
    }

    @Override
    public String getCertificateAlias(X509Certificate cert) throws GeneralSecurityException {
        String alias = this.keyStore.getCertificateAlias(cert);
        if (alias == null) {
            throw new GeneralSecurityException("No Such Certificate!");
        }
        return alias;
    }

    @Override
    public void addCertificate(String alias, X509Certificate cert) throws IOException, GeneralSecurityException {
        LOG.info((Object)String.format("Adding certificate %10s %s to %s", alias, cert, this.fileName));
        this.keyStore.setCertificateEntry(alias, cert);
        this.store();
    }

    @Override
    public void addKeyPair(String alias, X509Certificate cert, PrivateKey privateKey, String keyPassword) throws IOException, GeneralSecurityException {
        this.keyStore.setKeyEntry(alias, privateKey, keyPassword.toCharArray(), new Certificate[]{cert});
        this.store();
    }

    @Override
    public void store() throws IOException, GeneralSecurityException {
        LOG.info((Object)("Writing back keystore: " + this.fileName));
        FileOutputStream fileOutputStream = new FileOutputStream(this.fileName);
        this.keyStore.store(fileOutputStream, this.password.toCharArray());
        fileOutputStream.close();
    }

    private void init() throws IOException, GeneralSecurityException {
        this.keyStore = java.security.KeyStore.getInstance(this.format, "BC");
        if (new File(this.fileName).exists()) {
            FileInputStream fin = new FileInputStream(this.fileName);
            this.keyStore.load(fin, this.password.toCharArray());
            fin.close();
        } else {
            this.keyStore.load(null, this.password.toCharArray());
        }
    }

    @Override
    public List<String> getAliases() throws KeyStoreException {
        return Collections.list(this.keyStore.aliases());
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void remove(String alias) {
        try {
            this.keyStore.deleteEntry(alias);
            this.store();
        }
        catch (KeyStoreException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        catch (GeneralSecurityException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    @Override
    public void remove() {
        new File(this.fileName).delete();
    }

    @Override
    public InputStream getAsInputStream() throws FileNotFoundException {
        return new FileInputStream(this.fileName);
    }

    protected java.security.KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Override
    public List<X509Certificate> getAllCertificates() throws KeyStoreException {
        ArrayList results = Lists.newArrayList();
        for (String alias : Collections.list(this.keyStore.aliases())) {
            Certificate cert;
            if (!this.keyStore.isCertificateEntry(alias) || !((cert = this.keyStore.getCertificate(alias)) instanceof X509Certificate)) continue;
            results.add((X509Certificate)cert);
        }
        return results;
    }

    static class GenericKeyStore
    extends AbstractKeyStore {
        private GenericKeyStore(String fileName, String password, String format) throws IOException, GeneralSecurityException {
            super(fileName, password, format);
        }

        @Override
        public boolean check() throws KeyStoreException {
            throw new RuntimeException("A GenericKeyStore does not have the notion of being checked for correctness.");
        }
    }
}

