/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.crypto;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.auth.SystemCredentials;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.log4j.Logger;

public enum Signatures {
    SHA256withRSA,
    SHA1WithRSA;

    private static Logger LOG;
    private static final String HEXES = "0123456789abcdef";

    public String trySign(Class<? extends ComponentId> component, byte[] data) {
        return this.trySign(this.componentPk(component), data);
    }

    public String trySign(PrivateKey pk, byte[] data) {
        try {
            return this.sign(pk, data);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String sign(PrivateKey pk, byte[] data) throws InvalidKeyException, SignatureException {
        return Signatures.bytesToHex(this.signBinary(pk, data));
    }

    public byte[] signBinary(Class<? extends ComponentId> component, byte[] data) throws InvalidKeyException, SignatureException {
        return this.signBinary(this.componentPk(component), data);
    }

    public byte[] signBinary(PrivateKey pk, byte[] data) throws InvalidKeyException, SignatureException {
        Signature signer = this.getInstance();
        signer.initSign(pk);
        try {
            signer.update(data);
            return signer.sign();
        }
        catch (SignatureException e) {
            LOG.debug((Object)e, (Throwable)e);
            throw e;
        }
    }

    public Signature getInstance() {
        try {
            return Signature.getInstance(this.toString());
        }
        catch (NoSuchAlgorithmException e) {
            LOG.fatal((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static String bytesToHex(byte[] bytes) {
        char[] hex = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            hex[i * 2] = HEXES.charAt(b >>> 4);
            hex[i * 2 + 1] = HEXES.charAt(b & 0xF);
        }
        return new String(hex);
    }

    private PrivateKey componentPk(Class<? extends ComponentId> component) {
        return SystemCredentials.lookup(component).getPrivateKey();
    }

    static {
        LOG = Logger.getLogger(Signatures.class);
    }
}

