/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.crypto;

import com.eucalyptus.crypto.Signatures;
import java.security.MessageDigest;

public enum Digest {
    GOST3411,
    Tiger,
    Whirlpool,
    MD2,
    MD4,
    MD5,
    RipeMD128,
    RipeMD160,
    RipeMD256,
    RipeMD320,
    SHA1("SHA-1"),
    SHA224("SHA-224"),
    SHA256("SHA-256"),
    SHA384("SHA-384"),
    SHA512("SHA-512");

    private final String algorithm;

    public byte[] digestBinary(byte[] data) {
        return this.get().digest(data);
    }

    public String digestHex(byte[] data) {
        return Signatures.bytesToHex(this.digestBinary(data));
    }

    public MessageDigest get() {
        try {
            return MessageDigest.getInstance(this.algorithm);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Digest() {
        this.algorithm = this.name();
    }

    private Digest(String algorithm) {
        this.algorithm = algorithm;
    }
}

