/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.crypto;

import com.eucalyptus.crypto.BaseSecurityProvider;
import com.eucalyptus.crypto.CertificateProvider;
import com.eucalyptus.crypto.CryptoProvider;
import com.eucalyptus.crypto.Digest;
import com.eucalyptus.crypto.HmacProvider;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class Crypto {
    private static final Logger LOG;
    private static final BaseSecurityProvider DUMMY;
    private static final ConcurrentMap<Class, BaseSecurityProvider> providers;
    private static final Supplier<SecureRandom> secureRandomSupplier;

    public static String generateHashedPassword(String password) {
        return Crypto.getCryptoProvider().generateHashedPassword(password);
    }

    public static String generateSessionToken() {
        return Crypto.getCryptoProvider().generateSessionToken();
    }

    public static String generateAlphanumericId(int length, String prefix) {
        return Crypto.getCryptoProvider().generateAlphanumericId(length, prefix);
    }

    public static String generateSecretKey() {
        return Crypto.getCryptoProvider().generateSecretKey();
    }

    public static String getDigestBase64(String input, Digest hash) {
        return Crypto.getCryptoProvider().getDigestBase64(input, hash);
    }

    public static String generateId(String prefix) {
        return Crypto.getCryptoProvider().generateId(prefix);
    }

    public static CertificateProvider getCertificateProvider() {
        return (CertificateProvider)providers.get(CertificateProvider.class);
    }

    public static HmacProvider getHmacProvider() {
        return (HmacProvider)providers.get(HmacProvider.class);
    }

    public static CryptoProvider getCryptoProvider() {
        return (CryptoProvider)providers.get(CryptoProvider.class);
    }

    public static String generateLinuxSaltedPassword(String password) {
        return Crypto.getCryptoProvider().generateLinuxSaltedPassword(password);
    }

    public static boolean verifyLinuxSaltedPassword(String clear, String hashed) {
        return Crypto.getCryptoProvider().verifyLinuxSaltedPassword(clear, hashed);
    }

    public static boolean verifyPassword(String clear, String hashed) {
        try {
            return !Strings.isNullOrEmpty((String)hashed) && Crypto.verifyLinuxSaltedPassword(clear, hashed);
        }
        catch (Exception e) {
            if (clear != null) {
                return hashed.equals(Crypto.generateHashedPassword(clear));
            }
            return false;
        }
    }

    public static String generateEncryptedPassword(String password) {
        return Crypto.generateLinuxSaltedPassword(password);
    }

    @Nonnull
    public static Supplier<SecureRandom> getSecureRandomSupplier() {
        return secureRandomSupplier;
    }

    static {
        BaseSecurityProvider provider;
        LOG = Logger.getLogger(Crypto.class);
        DUMMY = new BaseSecurityProvider(){};
        providers = new ConcurrentHashMap<Class, BaseSecurityProvider>();
        try {
            Class<?> provClass = ClassLoader.getSystemClassLoader().loadClass("com.eucalyptus.auth.crypto.DefaultCryptoProvider");
            provider = (BaseSecurityProvider)provClass.newInstance();
        }
        catch (Exception t) {
            LOG.debug((Object)t, (Throwable)t);
            provider = DUMMY;
        }
        providers.put(CertificateProvider.class, provider);
        providers.put(HmacProvider.class, provider);
        providers.put(CryptoProvider.class, provider);
        secureRandomSupplier = Suppliers.memoizeWithExpiration((Supplier)new Supplier<SecureRandom>(){
            private final String secureRandomAlgorithm = System.getProperty("euca.crypto.random.algorithm", "SHA1PRNG");
            private final String secureRandomProvider = System.getProperty("euca.crypto.random.provider", "SUN");

            public SecureRandom get() {
                try {
                    return this.secureRandomProvider.isEmpty() ? SecureRandom.getInstance(this.secureRandomAlgorithm) : SecureRandom.getInstance(this.secureRandomAlgorithm, this.secureRandomProvider);
                }
                catch (GeneralSecurityException e) {
                    throw Exceptions.toUndeclared(e);
                }
            }
        }, (long)15L, (TimeUnit)TimeUnit.MINUTES);
    }
}

