/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.crypto;

import com.eucalyptus.crypto.Crypto;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.x500.X500Principal;

public class Certs {
    public static X509Certificate generateCertificate(PublicKey key, X500Principal subjectDn, X500Principal signer, PrivateKey signingKey, Date notAfter) {
        return Crypto.getCertificateProvider().generateCertificate(key, subjectDn, signer, signingKey, notAfter);
    }

    public static X509Certificate generateCertificate(KeyPair keys, X500Principal subjectDn, X500Principal signer, PrivateKey signingKey) {
        return Crypto.getCertificateProvider().generateCertificate(keys, subjectDn, signer, signingKey);
    }

    public static X509Certificate generateCertificate(KeyPair keys, X500Principal subjectDn) {
        return Crypto.getCertificateProvider().generateCertificate(keys, subjectDn);
    }

    public static X509Certificate generateCertificate(KeyPair keys, String userName) {
        return Crypto.getCertificateProvider().generateCertificate(keys, userName);
    }

    public static X509Certificate generateCertificate(KeyPair keys, String userName, Date notAfter) {
        X500Principal principal = new X500Principal(String.format("CN=%s, OU=Eucalyptus, O=User, C=US", userName));
        return Crypto.getCertificateProvider().generateCertificate(keys, principal, principal, null, notAfter);
    }

    public static KeyPair generateKeyPair() {
        return Crypto.getCertificateProvider().generateKeyPair();
    }

    public static X509Certificate generateServiceCertificate(KeyPair keys, String userName) {
        return Crypto.getCertificateProvider().generateServiceCertificate(keys, userName);
    }

    public static String getFingerPrint(Key privKey) {
        return Crypto.getCertificateProvider().getFingerPrint(privKey);
    }
}

