/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.context;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.OrderedShutdown;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.ComponentMessages;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.context.ServiceDispatchException;
import com.eucalyptus.context.ServiceInitializationException;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.Parameters;
import com.eucalyptus.util.Templates;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.context.MuleContextFactory;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.service.Service;
import org.mule.config.ConfigResource;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.module.client.MuleClient;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.transformer.TransformerUtils;

public class ServiceContextManager {
    private static Logger CONFIG_LOG = Logger.getLogger((String)"Configs");
    private static Logger LOG = Logger.getLogger(ServiceContextManager.class);
    private static ServiceContextManager singleton = new ServiceContextManager();
    private static final MuleContextFactory contextFactory = new DefaultMuleContextFactory();
    private final ConcurrentNavigableMap<String, String> endpointToService = new ConcurrentSkipListMap<String, String>();
    private final ConcurrentNavigableMap<String, String> serviceToEndpoint = new ConcurrentSkipListMap<String, String>();
    private final List<ComponentId> enabledCompIds = Lists.newArrayList();
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final ReentrantReadWriteLock canHas = new ReentrantReadWriteLock();
    private final Lock canHasWrite;
    private final Lock canHasRead;
    private final BlockingQueue<ServiceConfiguration> queue = new LinkedBlockingQueue<ServiceConfiguration>();
    private MuleContext context;
    private MuleClient client;
    private static final String EMPTY_MODEL = "<mule xmlns=\"http://www.mulesoft.org/schema/mule/core\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"\n       http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/3.4/mule.xsd\">\n</mule>\n";
    private static String FAIL_MSG = "ESB client not ready because the service bus has not been started.";

    private ServiceContextManager() {
        this.canHasRead = this.canHas.readLock();
        this.canHasWrite = this.canHas.writeLock();
        OrderedShutdown.registerPreShutdownHook(new Runnable(){

            @Override
            public void run() {
                ServiceContextManager.shutdown();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void restartSync() {
        if (ServiceContextManager.singleton.canHasWrite.tryLock()) {
            try {
                singleton.update();
            }
            catch (Exception ex) {
                LOG.error((Object)Exceptions.causeString(ex));
                LOG.error((Object)ex, (Throwable)ex);
            }
            finally {
                ServiceContextManager.singleton.canHasWrite.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        if (this.context != null) {
            return;
        }
        this.canHasWrite.lock();
        try {
            this.context = this.createContext();
            Parameters.checkParam(this.context, Matchers.notNullValue());
            try {
                this.context.start();
                this.client = new MuleClient(this.context){

                    protected InboundEndpoint getDefaultClientEndpoint(Service service, Object payload, boolean sync) throws MuleException {
                        if (!(service.getMessageSource() instanceof ServiceCompositeMessageSource)) {
                            throw new IllegalStateException("Only 'CompositeMessageSource' is supported with MuleClient.sendDirect() and MuleClient.dispatchDirect()");
                        }
                        InboundEndpoint endpoint = (InboundEndpoint)((ServiceCompositeMessageSource)service.getMessageSource()).getEndpoints().get(0);
                        if (endpoint != null) {
                            List transformers = endpoint.getTransformers();
                            if (transformers != null && !transformers.isEmpty()) {
                                if (TransformerUtils.isSourceTypeSupportedByFirst((List)transformers, payload.getClass())) {
                                    return endpoint;
                                }
                                EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder((ImmutableEndpoint)endpoint);
                                builder.setTransformers(new LinkedList());
                                builder.setExchangePattern(MessageExchangePattern.REQUEST_RESPONSE);
                                return this.getMuleContext().getEndpointFactory().getInboundEndpoint((EndpointBuilder)builder);
                            }
                            return endpoint;
                        }
                        EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder("vm://mule.client", this.getMuleContext());
                        builder.setName("muleClientProvider");
                        endpoint = this.getMuleContext().getEndpointFactory().getInboundEndpoint((EndpointBuilder)builder);
                        return endpoint;
                    }
                };
                this.endpointToService.clear();
                this.serviceToEndpoint.clear();
                for (Service service : this.context.getRegistry().lookupObjects(Service.class)) {
                    ServiceCompositeMessageSource source = (ServiceCompositeMessageSource)service.getMessageSource();
                    for (InboundEndpoint in : source.getEndpoints()) {
                        this.endpointToService.put(in.getEndpointURI().toString(), service.getName());
                        this.serviceToEndpoint.put(service.getName(), in.getEndpointURI().toString());
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
                throw Exceptions.toUndeclared(new ServiceInitializationException("Failed to start service this.context.", e));
            }
        }
        finally {
            this.canHasWrite.unlock();
        }
    }

    private MuleContext createContext() {
        ArrayList currentComponentIds = Lists.newArrayList((Iterable)Ordering.natural().onResultOf(Functions.forPredicate(ComponentIds.manyToOne())).compound((Comparator)Ordering.natural().onResultOf(Functions.compose(Classes.canonicalNameFunction(), (Function)Functions.identity()))).sortedCopy(ComponentIds.list()));
        LOG.error((Object)("Restarting service context with these enabled services: " + currentComponentIds));
        HashSet configs = Sets.newHashSet();
        MuleContext muleCtx = null;
        for (ComponentId componentId : currentComponentIds) {
            Component component = Components.lookup(componentId);
            String errMsg = "Failed to render model for: " + componentId + " because of: ";
            LOG.info((Object)("-> Rendering configuration for " + componentId.name()));
            try {
                String serviceModel = this.loadModel(componentId);
                String outString = Templates.prepare(componentId.getServiceModelFileName()).withProperty("components", currentComponentIds).withProperty("ComponentMessages", ComponentMessages.class).withProperty("thisComponent", componentId).evaluate(serviceModel);
                ConfigResource configRsc = ServiceContextManager.createConfigResource(componentId, outString);
                configs.add(configRsc);
            }
            catch (Exception ex) {
                LOG.error((Object)(errMsg + ex.getMessage()), (Throwable)ex);
            }
        }
        try {
            SpringXmlConfigurationBuilder builder = new SpringXmlConfigurationBuilder(configs.toArray(new ConfigResource[0]));
            muleCtx = contextFactory.createMuleContext((ConfigurationBuilder)builder);
            this.enabledCompIds.clear();
            this.enabledCompIds.addAll(currentComponentIds);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        return muleCtx;
    }

    private String loadModel(ComponentId componentId) {
        try {
            return Resources.toString((URL)Resources.getResource((String)componentId.getServiceModelFileName()), (Charset)Charset.defaultCharset());
        }
        catch (Exception ex) {
            return EMPTY_MODEL;
        }
    }

    private static ConfigResource createConfigResource(ComponentId componentId, String outString) {
        ByteArrayInputStream bis = new ByteArrayInputStream(outString.getBytes());
        Logs.extreme().trace((Object)"===================================");
        Logs.extreme().trace((Object)outString);
        Logs.extreme().trace((Object)"===================================");
        ConfigResource configRsc = new ConfigResource(componentId.getServiceModelFileName(), (InputStream)bis);
        return configRsc;
    }

    static MuleClient getClient() throws MuleException {
        singleton.update();
        return ServiceContextManager.singleton.client;
    }

    static MuleContext getContext() throws MuleException {
        singleton.update();
        return ServiceContextManager.singleton.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        this.canHasWrite.lock();
        try {
            if (this.context != null) {
                try {
                    this.context.stop();
                    this.context.dispose();
                }
                catch (MuleException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }
        finally {
            this.canHasWrite.unlock();
        }
    }

    public static void shutdown() {
        singleton.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String mapServiceToEndpoint(String service) throws Exception {
        Parameters.checkParam(service, Matchers.notNullValue());
        if (ServiceContextManager.singleton.canHasRead.tryLock(120L, TimeUnit.SECONDS)) {
            try {
                String dest = service;
                if (!service.startsWith("vm://") && !ServiceContextManager.singleton.serviceToEndpoint.containsKey(service)) {
                    dest = "vm://RequestQueue";
                } else if (!service.startsWith("vm://")) {
                    dest = (String)ServiceContextManager.singleton.serviceToEndpoint.get(dest);
                }
                String string = dest;
                return string;
            }
            finally {
                ServiceContextManager.singleton.canHasRead.unlock();
            }
        }
        throw Exceptions.notFound("Failed to dispatch: " + service, new Throwable[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String mapEndpointToService(String endpoint) throws Exception {
        Parameters.checkParam(endpoint, Matchers.notNullValue());
        if (ServiceContextManager.singleton.canHasRead.tryLock(120L, TimeUnit.SECONDS)) {
            try {
                String dest = endpoint;
                if (endpoint.startsWith("vm://") && !ServiceContextManager.singleton.endpointToService.containsKey(endpoint)) {
                    throw new ServiceDispatchException("No such endpoint: " + endpoint + " in endpoints=" + ServiceContextManager.singleton.endpointToService.entrySet());
                }
                if (endpoint.startsWith("vm://")) {
                    dest = (String)ServiceContextManager.singleton.endpointToService.get(endpoint);
                }
                String string = dest;
                return string;
            }
            finally {
                ServiceContextManager.singleton.canHasRead.unlock();
            }
        }
        throw Exceptions.notFound("Failed to dispatch: " + endpoint, new Throwable[0]);
    }

    @Provides(value=Empyrean.class)
    @RunDuring(value=Bootstrap.Stage.RemoteServicesInit)
    public static class ServiceContextBootstrapper
    extends Bootstrapper.Simple {
        @Override
        public boolean start() throws Exception {
            new Thread(){

                @Override
                public void run() {
                    try {
                        singleton.update();
                        singleton;
                        ServiceContextManager.getClient();
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
            }.start();
            return true;
        }
    }
}

