/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.context;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.BootstrapException;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.ServiceContextManager;
import com.eucalyptus.context.ServiceDispatchException;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Exceptions;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.mule.DefaultMuleEvent;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.Connector;
import org.mule.api.transport.ConnectorException;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageDispatcher;
import org.mule.config.i18n.MessageFactory;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.module.client.MuleClient;
import org.mule.session.DefaultMuleSession;
import org.mule.transport.vm.VMConnector;
import org.mule.transport.vm.VMMessageDispatcherFactory;

@ConfigurableClass(root="bootstrap.servicebus", description="Parameters having to do with the service bus.")
public class ServiceContext {
    static Logger LOG = Logger.getLogger(ServiceContext.class);
    private static SpringXmlConfigurationBuilder builder;
    @ConfigurableField(initial="256", description="Max queue length allowed per service stage.", changeListener=HupListener.class)
    public static Integer MAX_OUTSTANDING_MESSAGES;
    @ConfigurableField(initial="16", description="Max queue length allowed per service stage.", changeListener=HupListener.class)
    public static Integer WORKERS_PER_STAGE;
    @ConfigurableField(initial="0", description="Do a soft reset.", changeListener=HupListener.class)
    public static Integer HUP;
    @ConfigurableField(initial="64", description="Internal connector core pool size.")
    public static Integer MIN_SCHEDULER_CORE_SIZE;
    @ConfigurableField(initial="60", description="Message context timeout (seconds)")
    public static Integer CONTEXT_TIMEOUT;
    private static final VMMessageDispatcherFactory dispatcherFactory;
    private static final AtomicReference<MuleClient> client;
    private static final BootstrapException failEx;

    public static void dispatch(String dest, Object msg) throws Exception {
        Context ctx;
        OutboundEndpoint endpoint;
        MuleContext muleCtx;
        dest = ServiceContextManager.mapServiceToEndpoint(dest);
        try {
            muleCtx = ServiceContextManager.getContext();
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            throw new ServiceDispatchException("Failed to dispatch message to " + dest + " caused by failure to obtain service context reference: " + ex.getMessage(), ex);
        }
        try {
            endpoint = muleCtx.getEndpointFactory().getOutboundEndpoint(dest);
            ServiceContext.perhapsConfigureConnector(endpoint.getConnector());
        }
        catch (MuleException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            throw new ServiceDispatchException("Failed to dispatch message to " + dest + " caused by failure to obtain service endpoint reference: " + ex.getMessage(), ex);
        }
        DefaultMuleSession muleSession = new DefaultMuleSession();
        if (msg instanceof BaseMessage) {
            msg = ((BaseMessage)msg).lookupAndSetCorrelationId();
            ctx = Contexts.createWrapped(dest, (BaseMessage)msg);
        } else {
            ctx = null;
        }
        MessageDispatcher dispatcher = null;
        try {
            dispatcher = dispatcherFactory.create(endpoint);
            dispatcher.initialise();
            dispatcher.start();
            MuleMessage muleMsg = dispatcher.createMuleMessage(msg);
            DefaultMuleEvent muleEvent = new DefaultMuleEvent(muleMsg, endpoint.getExchangePattern(), (FlowConstruct)null, (MuleSession)muleSession);
            dispatcher.process((MuleEvent)muleEvent);
        }
        catch (DispatchException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            throw new ServiceDispatchException("Error while dispatching message (" + msg + ") to " + dest + " caused by: " + ex.getMessage(), ex);
        }
        catch (MuleException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            throw new ServiceDispatchException("Failed to dispatch message to " + dest + " caused by failure to obtain service dispatcher reference: " + ex.getMessage(), ex);
        }
        finally {
            if (dispatcher != null) {
                dispatcher.dispose();
            }
        }
        final long clearContextTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(CONTEXT_TIMEOUT.intValue());
        Threads.enqueue(Empyrean.class, ServiceContext.class, new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    long sleepTime = clearContextTime - System.currentTimeMillis();
                    if (sleepTime > 1L) {
                        Thread.sleep(sleepTime);
                    }
                    Contexts.clear(ctx);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }
        });
    }

    public static <T> T send(ComponentId dest, Object msg) throws Exception {
        return ServiceContext.send(dest.getLocalEndpointName(), msg);
    }

    public static <T> T send(String dest, Object msg) throws Exception {
        Object object;
        MuleEvent context;
        block7: {
            dest = ServiceContextManager.mapEndpointToService(dest);
            context = RequestContext.getEvent();
            Context ctx = null;
            if (msg instanceof BaseMessage) {
                msg = ((BaseMessage)msg).lookupAndSetCorrelationId();
                ctx = Contexts.createWrapped(dest, (BaseMessage)msg);
            }
            try {
                MuleMessage reply = ServiceContextManager.getClient().sendDirect(dest, null, msg, null);
                if (reply.getExceptionPayload() != null) {
                    throw Exceptions.trace(new ServiceDispatchException(reply.getExceptionPayload().getException().getMessage(), reply.getExceptionPayload().getException()));
                }
                object = reply.getPayload();
                if (ctx == null) break block7;
            }
            catch (Exception e) {
                try {
                    throw Exceptions.trace(new ServiceDispatchException("Failed to send message " + msg.getClass().getSimpleName() + " to service " + dest + " because: " + e.getMessage(), e));
                }
                catch (Throwable throwable) {
                    if (ctx != null) {
                        Contexts.clear(ctx);
                    }
                    RequestContext.setEvent((MuleEvent)context);
                    throw throwable;
                }
            }
            Contexts.clear(ctx);
        }
        RequestContext.setEvent((MuleEvent)context);
        return (T)object;
    }

    private static void perhapsConfigureConnector(Connector connector) throws MuleException {
        ScheduledThreadPoolExecutor threadPoolExecutor;
        VMConnector vmConnector;
        ScheduledExecutorService scheduledExecutorService;
        block4: {
            if (!connector.isStarted()) {
                try {
                    connector.start();
                }
                catch (IllegalArgumentException e) {
                    if (connector.isStarted()) break block4;
                    throw new ConnectorException(MessageFactory.createStaticMessage((String)"Error starting connector"), connector, (Throwable)e);
                }
            }
        }
        if (connector instanceof VMConnector && (scheduledExecutorService = (vmConnector = (VMConnector)connector).getScheduler()) instanceof ScheduledThreadPoolExecutor && (threadPoolExecutor = (ScheduledThreadPoolExecutor)scheduledExecutorService).getCorePoolSize() < MIN_SCHEDULER_CORE_SIZE) {
            threadPoolExecutor.setCorePoolSize(MIN_SCHEDULER_CORE_SIZE);
        }
    }

    static {
        MAX_OUTSTANDING_MESSAGES = 256;
        WORKERS_PER_STAGE = 16;
        HUP = 0;
        MIN_SCHEDULER_CORE_SIZE = 64;
        CONTEXT_TIMEOUT = 60;
        dispatcherFactory = new VMMessageDispatcherFactory();
        client = new AtomicReference<Object>(null);
        failEx = new BootstrapException("Attempt to use esb client before the service bus has been started.");
    }

    public static class HupListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            if (Bootstrap.isFinished().booleanValue()) {
                ServiceContextManager.restartSync();
            }
        }
    }
}

