/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.context;

import com.eucalyptus.BaseException;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.IllegalContextAccessException;
import com.eucalyptus.context.NoSuchContextException;
import com.eucalyptus.context.ServiceContext;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Consumer;
import com.eucalyptus.util.Consumers;
import com.eucalyptus.util.Parameters;
import com.eucalyptus.ws.util.ReplyQueue;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.BaseMessageSupplier;
import edu.ucsb.eucalyptus.msgs.ExceptionResponseType;
import edu.ucsb.eucalyptus.msgs.HasRequest;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.Channels;
import org.mule.RequestContext;
import org.mule.api.MuleMessage;

public class Contexts {
    private static Logger LOG = Logger.getLogger(Contexts.class);
    private static int MAX = 8192;
    private static int CONCUR = MAX / (Runtime.getRuntime().availableProcessors() * 2 + 1);
    private static float THRESHOLD = 1.0f;
    private static ConcurrentMap<String, Context> uuidContexts = new ConcurrentHashMap<String, Context>(MAX, THRESHOLD, CONCUR);
    private static ConcurrentMap<String, Context> uuidImpContexts = new ConcurrentHashMap<String, Context>(MAX, THRESHOLD, CONCUR);
    private static ConcurrentMap<Channel, Context> channelContexts = new ConcurrentHashMap<Channel, Context>(MAX, THRESHOLD, CONCUR);
    private static ThreadLocal<Context> tlContext = new ThreadLocal();

    public static Context create(MappingHttpRequest request, Channel channel) {
        Context ctx = new Context(request, channel);
        request.setCorrelationId(ctx.getCorrelationId());
        uuidContexts.put(ctx.getCorrelationId(), ctx);
        Context previousContext = channelContexts.put(channel, ctx);
        if (previousContext != null && previousContext.getCorrelationId() != null) {
            uuidContexts.remove(previousContext.getCorrelationId());
            uuidImpContexts.remove(previousContext.getCorrelationId());
        }
        return ctx;
    }

    public static long uuidContextCount() {
        return uuidContexts.size();
    }

    public static long channelContextCount() {
        return channelContexts.size();
    }

    public static Context update(Context ctx, String correlationId) {
        String oldId = ctx.getCorrelationId();
        uuidContexts.remove(oldId);
        Context impersonatingCtx = (Context)uuidImpContexts.remove(oldId);
        ctx.setCorrelationId(correlationId);
        uuidContexts.put(ctx.getCorrelationId(), ctx);
        if (impersonatingCtx != null) {
            uuidImpContexts.put(impersonatingCtx.getCorrelationId(), impersonatingCtx);
        }
        return ctx;
    }

    public static boolean exists() {
        try {
            Contexts.lookup();
            return true;
        }
        catch (IllegalContextAccessException ex) {
            return false;
        }
    }

    public static boolean exists(Channel channel) {
        return channelContexts.containsKey(channel);
    }

    public static Context lookup(Channel channel) throws NoSuchContextException {
        if (!channelContexts.containsKey(channel)) {
            throw new NoSuchContextException("Found channel context " + channel + " but no corresponding context.");
        }
        Context ctx = (Context)channelContexts.get(channel);
        ctx.setMuleEvent(RequestContext.getEvent());
        return Contexts.maybeImpersonating(ctx);
    }

    private static Context maybeImpersonating(Context ctx) {
        Context resultContext;
        String uuid = ctx.getCorrelationId();
        Context context = resultContext = uuid == null ? null : (Context)uuidImpContexts.get(uuid);
        if (resultContext == null && (resultContext = Context.maybeImpersonating(ctx)) != ctx) {
            uuidImpContexts.put(uuid, resultContext);
        }
        return resultContext;
    }

    public static boolean exists(String correlationId) {
        return correlationId != null && uuidContexts.containsKey(correlationId);
    }

    public static void threadLocal(Context ctx) {
        tlContext.set(ctx);
    }

    public static void removeThreadLocal() {
        tlContext.remove();
    }

    public static <T> Consumer<T> consumerWithCurrentContext(Consumer<T> consumer) {
        return Contexts.consumerWithContext(consumer, Contexts.lookup());
    }

    public static <T> Consumer<T> consumerWithContext(final Consumer<T> consumer, final Context context) {
        return new Consumer<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(T t) {
                Context previously = (Context)tlContext.get();
                Contexts.threadLocal(context);
                try {
                    consumer.accept(t);
                }
                finally {
                    Contexts.threadLocal(previously);
                }
            }
        };
    }

    public static Runnable runnableWithCurrentContext(Runnable runnable) {
        return Contexts.runnableWithContext(runnable, Contexts.lookup());
    }

    public static Runnable runnableWithContext(Runnable runnable, Context context) {
        return Consumers.partial(Contexts.consumerWithContext(Consumers.forRunnable(runnable), context), null);
    }

    public static Context lookup(String correlationId) throws NoSuchContextException {
        Parameters.checkParam("BUG: correlationId is null.", correlationId, Matchers.notNullValue());
        if (!uuidContexts.containsKey(correlationId)) {
            throw new NoSuchContextException("Found correlation id " + correlationId + " but no corresponding context.");
        }
        Context ctx = (Context)uuidContexts.get(correlationId);
        ctx.setMuleEvent(RequestContext.getEvent());
        return Contexts.maybeImpersonating(ctx);
    }

    public static final Context lookup() throws IllegalContextAccessException {
        Context ctx = tlContext.get();
        if (ctx != null) {
            return Contexts.maybeImpersonating(ctx);
        }
        Object parent = null;
        MuleMessage muleMsg = null;
        if (RequestContext.getEvent() != null && RequestContext.getEvent().getMessage() != null) {
            muleMsg = RequestContext.getEvent().getMessage();
        } else if (RequestContext.getEventContext() != null && RequestContext.getEventContext().getMessage() != null) {
            muleMsg = RequestContext.getEventContext().getMessage();
        } else {
            throw new IllegalContextAccessException("Cannot access context implicitly using lookup(V) outside of a service.");
        }
        Object o = muleMsg.getPayload();
        if (o != null && o instanceof BaseMessage) {
            try {
                return Contexts.lookup(((BaseMessage)o).getCorrelationId());
            }
            catch (NoSuchContextException e) {
                Logs.exhaust().error((Object)e, (Throwable)e);
                throw new IllegalContextAccessException("Cannot access context implicitly using lookup(V) when not handling a request.", e);
            }
        }
        if (o != null && o instanceof HasRequest) {
            try {
                return Contexts.lookup(((BaseMessage)((HasRequest)o).getRequest()).getCorrelationId());
            }
            catch (NoSuchContextException e) {
                Logs.exhaust().error((Object)e, (Throwable)e);
                throw new IllegalContextAccessException("Cannot access context implicitly using lookup(V) when not handling a request.", e);
            }
        }
        throw new IllegalContextAccessException("Cannot access context implicitly using lookup(V) when not handling a request.");
    }

    public static void clear(String corrId) {
        Parameters.checkParam("BUG: correlationId is null.", corrId, Matchers.notNullValue());
        uuidImpContexts.remove(corrId);
        Context ctx = (Context)uuidContexts.remove(corrId);
        Channel channel = null;
        if (ctx != null && (channel = ctx.getChannel()) != null) {
            channelContexts.remove(channel);
        } else {
            LOG.trace((Object)("Context.clear() failed for correlationId=" + corrId));
            Logs.extreme().trace((Object)("Context.clear() failed for correlationId=" + corrId), (Throwable)new RuntimeException("Missing reference to channel for the request."));
        }
        if (ctx != null) {
            ctx.clear();
        }
    }

    public static void clear(Context context) {
        if (context != null) {
            Contexts.clear(context.getCorrelationId());
        }
    }

    public static Context createWrapped(String dest, BaseMessage msg) {
        if (uuidContexts.containsKey(msg.getCorrelationId())) {
            return null;
        }
        Context ctx = new Context(dest, msg);
        uuidContexts.put(ctx.getCorrelationId(), ctx);
        return Contexts.maybeImpersonating(ctx);
    }

    public static void response(BaseMessage responseMessage) {
        Contexts.response(responseMessage, responseMessage);
    }

    public static void response(BaseMessageSupplier responseMessageSupplier) {
        Contexts.response(responseMessageSupplier, responseMessageSupplier.getBaseMessage());
    }

    private static void response(Object message, BaseMessage responseMessage) {
        if (responseMessage instanceof ExceptionResponseType) {
            Logs.exhaust().trace((Object)responseMessage);
        }
        String corrId = responseMessage.getCorrelationId();
        try {
            Context ctx = Contexts.lookup(corrId);
            EventRecord.here(ServiceContext.class, EventType.MSG_REPLY, responseMessage.getCorrelationId(), responseMessage.getClass().getSimpleName(), String.format("%.3f ms", (double)(System.nanoTime() - ctx.getCreationTime()) / 1000000.0)).trace();
            Channel channel = ctx.getChannel();
            Channels.write((Channel)channel, (Object)message);
            Contexts.clear(ctx);
        }
        catch (NoSuchContextException e) {
            LOG.warn((Object)("Received a reply for absent client:  No channel to write response message: " + e.getMessage() + " for " + responseMessage.getClass().getSimpleName()));
            Logs.extreme().debug((Object)responseMessage, (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error occurred while handling reply: " + responseMessage));
            Logs.extreme().debug((Object)responseMessage, (Throwable)e);
        }
    }

    public static void responseError(Throwable cause) {
        try {
            Contexts.responseError(Contexts.lookup().getCorrelationId(), cause);
        }
        catch (Exception e) {
            LOG.error((Object)e);
            Logs.extreme().error((Object)cause, cause);
        }
    }

    public static void responseError(String corrId, Throwable cause) {
        try {
            Context ctx = Contexts.lookup(corrId);
            EventRecord.here(ReplyQueue.class, EventType.MSG_REPLY, cause.getClass().getCanonicalName(), cause.getMessage(), String.format("%.3f ms", (double)(System.nanoTime() - ctx.getCreationTime()) / 1000000.0)).trace();
            if (cause.getCause() != null) {
                Channel channel = ctx.getChannel();
                Channels.write((Channel)channel, (Object)new ExceptionResponseType(ctx.getRequest(), cause.getCause().getMessage(), cause.getCause()));
            }
            if (!(cause instanceof BaseException)) {
                Contexts.clear(ctx);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            Logs.extreme().error((Object)cause, cause);
        }
    }
}

