/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.context;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthContext;
import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.Contract;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.auth.principal.Role;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.context.DelegatingContextSupport;
import com.eucalyptus.context.IllegalContextAccessException;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.ws.server.MessageStatistics;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import edu.ucsb.eucalyptus.msgs.BaseCallerContext;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EvaluatedIamConditionKey;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.local.DefaultLocalClientChannelFactory;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.mule.api.MuleEvent;

public class Context {
    private static Logger LOG = Logger.getLogger(Context.class);
    private String correlationId;
    private Long creationTime;
    private BaseMessage request = null;
    private final MappingHttpRequest httpRequest;
    private final Channel channel;
    private final boolean channelManaged;
    private WeakReference<MuleEvent> muleEvent = new WeakReference<Object>(null);
    private User user = null;
    private Subject subject = null;
    private Map<Contract.Type, Contract> contracts = null;
    private Boolean isSystemAdmin;
    private Boolean isSystemUser;

    Context() {
        this.correlationId = null;
        this.httpRequest = null;
        this.channel = null;
        this.channelManaged = false;
    }

    protected Context(String dest, final BaseMessage msg) {
        this.correlationId = msg.getCorrelationId();
        this.creationTime = System.nanoTime();
        this.httpRequest = new MappingHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, dest){
            {
                super(x0, x1, x2);
                this.setCorrelationId(msg.getCorrelationId());
                this.message = msg;
            }
        };
        this.channel = new DefaultLocalClientChannelFactory().newChannel(Channels.pipeline());
        this.channelManaged = true;
        this.user = Principals.systemUser();
        EventRecord.caller(Context.class, EventType.CONTEXT_CREATE, this.correlationId, this.channel.toString()).debug();
    }

    protected Context(MappingHttpRequest httpRequest, Channel channel) {
        UUID uuid = UUID.randomUUID();
        MessageStatistics.startRequest(channel);
        this.correlationId = uuid.toString();
        this.creationTime = System.nanoTime();
        this.httpRequest = httpRequest;
        this.channel = channel;
        this.channelManaged = false;
        EventRecord.caller(Context.class, EventType.CONTEXT_CREATE, this.correlationId, this.channel.toString()).debug();
    }

    public Channel getChannel() {
        return Context.check(this.channel);
    }

    public InetAddress getRemoteAddress() {
        if (this.getChannel() != null && this.getChannel().getRemoteAddress() instanceof InetSocketAddress) {
            return ((InetSocketAddress)this.getChannel().getRemoteAddress()).getAddress();
        }
        throw new IllegalContextAccessException("Attempt to access socket address information when no associated socket exists.");
    }

    public MappingHttpRequest getHttpRequest() {
        return Context.check(this.httpRequest);
    }

    public void setCorrelationId(String corrId) {
        this.correlationId = corrId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public BaseMessage getRequest() {
        this.initRequest();
        return Context.check(this.request);
    }

    public void setUser(User user) {
        if (user != null) {
            EventRecord.caller(Context.class, EventType.CONTEXT_USER, this.correlationId, user.getUserId()).debug();
            this.user = user;
        }
    }

    public UserFullName getUserFullName() {
        return UserFullName.getInstance(this.getUser(), new String[0]);
    }

    public boolean isPrivileged() {
        return false;
    }

    public boolean hasAdministrativePrivileges() {
        if (this.isSystemAdmin == null) {
            this.isSystemAdmin = this.getUser().isSystemAdmin();
        }
        return this.isSystemAdmin;
    }

    public boolean isAdministrator() {
        if (this.isSystemUser == null) {
            this.isSystemUser = this.getUser().isSystemUser();
        }
        return this.isSystemUser;
    }

    public boolean isImpersonated() {
        return false;
    }

    public Map<String, String> evaluateKeys() throws AuthException {
        return Permissions.evaluateHostKeys();
    }

    public User getUser() {
        return Context.check(this.user);
    }

    public AuthContextSupplier getAuthContext() {
        return new AuthContextSupplier(){

            @Override
            public AuthContext get() throws AuthException {
                return Permissions.createAuthContext(Context.this.getUser(), Collections.emptyMap());
            }
        };
    }

    void setMuleEvent(MuleEvent event) {
        if (event != null && this.muleEvent.get() == null) {
            this.muleEvent = new WeakReference<MuleEvent>(event);
        }
    }

    public String getServiceName() {
        MuleEvent e = (MuleEvent)this.muleEvent.get();
        if (e != null) {
            return e.getFlowConstruct().getName();
        }
        return this.httpRequest.getServicePath().replaceAll("/services/", "").replaceAll("[/?].+", "");
    }

    @Nullable
    public Subject getSubject() {
        return Context.check(this.subject);
    }

    public void setSubject(Subject subject) {
        if (subject != null) {
            this.subject = subject;
        }
    }

    void clear() {
        if (this.muleEvent != null) {
            this.muleEvent.clear();
            this.muleEvent = null;
        }
        if (this.channelManaged) {
            this.channel.close();
        }
        this.contracts = null;
    }

    private void initRequest() {
        if (this.request == null && this.httpRequest != null && this.httpRequest.getMessage() != null) {
            this.request = (BaseMessage)this.httpRequest.getMessage();
        }
    }

    private static <TYPE> TYPE check(TYPE obj) {
        if (obj == null) {
            StackTraceElement steMethod = Thread.currentThread().getStackTrace()[1];
            StackTraceElement steCaller = Thread.currentThread().getStackTrace()[2];
            LOG.error((Object)("Accessing context field when it is null: " + steMethod.getMethodName() + " from " + steCaller));
        }
        return obj;
    }

    public Map<Contract.Type, Contract> getContracts() throws IllegalStateException {
        if (this.contracts == null) {
            throw new IllegalStateException("Contracts not available");
        }
        return this.contracts;
    }

    public void setContracts(Map<Contract.Type, Contract> contracts) {
        this.contracts = Collections.unmodifiableMap(Maps.newHashMap(contracts));
    }

    public Account getAccount() {
        try {
            return this.user.getAccount();
        }
        catch (AuthException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            throw new IllegalStateException("Context populated with ill-defined user:  no corresponding account found.", ex);
        }
    }

    static Context maybeImpersonating(Context ctx) {
        String userId;
        ctx.initRequest();
        if (ctx.request != null && (userId = (String)Optional.fromNullable((Object)ctx.request.getUserId()).or(Optional.fromNullable((Object)ctx.request.getEffectiveUserId())).orNull()) != null && !Principals.isFakeIdentify(userId) && ctx.hasAdministrativePrivileges()) {
            try {
                User user;
                if (Accounts.isRoleIdentifier(userId)) {
                    Role role = Accounts.lookupRoleById(userId);
                    user = Accounts.roleAsUser(role);
                } else {
                    user = Accounts.lookupUserById(userId);
                }
                return Context.createImpersona(ctx, user);
            }
            catch (AuthException ex) {
                return ctx;
            }
        }
        return ctx;
    }

    private static Context createImpersona(final Context ctx, final User user) {
        return new DelegatingContextSupport(ctx){
            private Boolean isSystemAdmin;
            private Boolean isSystemUser;
            private Subject subject;
            private Map<String, String> evaluatedKeys;
            {
                super(x0);
                this.subject = new Subject();
            }

            @Override
            public User getUser() {
                return user;
            }

            @Override
            public Account getAccount() {
                try {
                    return user.getAccount();
                }
                catch (AuthException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    throw new IllegalStateException("Context populated with ill-defined user:  no corresponding account found.", ex);
                }
            }

            @Override
            public UserFullName getUserFullName() {
                return UserFullName.getInstance(user, new String[0]);
            }

            @Override
            public boolean isPrivileged() {
                return Principals.systemUser().getName().equals(ctx.request.getEffectiveUserId());
            }

            @Override
            public boolean isAdministrator() {
                if (this.isSystemUser == null) {
                    this.isSystemUser = this.getUser().isSystemUser();
                }
                return this.isSystemUser;
            }

            @Override
            public boolean hasAdministrativePrivileges() {
                if (this.isSystemAdmin == null) {
                    this.isSystemAdmin = user.isSystemAdmin();
                }
                return this.isSystemAdmin;
            }

            @Override
            public boolean isImpersonated() {
                return true;
            }

            @Override
            public Subject getSubject() {
                return this.subject;
            }

            @Override
            public void setSubject(Subject subject) {
                this.subject = subject;
            }

            @Override
            public Map<String, String> evaluateKeys() throws AuthException {
                if (this.evaluatedKeys == null) {
                    BaseCallerContext context = super.getRequest().getCallerContext();
                    this.evaluatedKeys = context == null ? Collections.emptyMap() : CollectionUtils.putAll(context.getEvaluatedKeys(), Maps.newHashMap(), EvaluatedIamConditionKey.key(), EvaluatedIamConditionKey.value());
                }
                return this.evaluatedKeys;
            }

            @Override
            public AuthContextSupplier getAuthContext() {
                return new AuthContextSupplier(){

                    @Override
                    public AuthContext get() throws AuthException {
                        return Permissions.createAuthContext(this.getUser(), this.evaluateKeys());
                    }
                };
            }
        };
    }
}

