/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.configurable;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.configurable.AbstractConfigurableProperty;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyBuilder;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.configurable.PropertyChangeListeners;
import com.eucalyptus.configurable.PropertyTypeParser;
import com.eucalyptus.configurable.StaticDatabasePropertyEntry;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.Exceptions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Date;
import org.apache.log4j.Logger;

public class StaticPropertyEntry
extends AbstractConfigurableProperty {
    static Logger LOG = Logger.getLogger(StaticPropertyEntry.class);
    private Field field;
    private Date lastLoad;

    private StaticPropertyEntry(Class definingClass, String entrySetName, Field field, String description, String defaultValue, PropertyTypeParser typeParser, Boolean readOnly, String displayName, ConfigurableFieldType widgetType, String alias, PropertyChangeListener changeListener) {
        super(definingClass, entrySetName, field, defaultValue, description, typeParser, readOnly, displayName, widgetType, alias, changeListener);
        this.field = field;
    }

    private String getFieldCanonicalName() {
        return this.getField().getDeclaringClass().getCanonicalName() + "." + this.getFieldName();
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getValue() {
        try {
            StaticDatabasePropertyEntry dbEntry = StaticDatabasePropertyEntry.lookup(this.getFieldCanonicalName(), this.getQualifiedName(), this.safeGetFieldValue());
            if (this.lastLoad == null || this.lastLoad.before(dbEntry.getLastUpdateTimestamp())) {
                this.lastLoad = dbEntry.getLastUpdateTimestamp();
                String fieldValue = this.safeGetFieldValue();
                if (fieldValue.equals(dbEntry.getValue())) {
                    return fieldValue;
                }
                Object o = super.getTypeParser().apply(dbEntry.getValue());
                if (!Modifier.isFinal(this.field.getModifiers())) {
                    this.fireChange(dbEntry.getValue());
                    this.field.set(null, o);
                    Logs.extreme().trace((Object)("--> Set property value:  " + super.getQualifiedName() + " to " + dbEntry.getValue()));
                }
            }
            return dbEntry.getValue();
        }
        catch (IllegalAccessException e) {
            Logs.exhaust().trace((Object)e, (Throwable)e);
            return super.getDefaultValue();
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to get property: " + super.getQualifiedName() + " because of " + e.getMessage()));
            Logs.extreme().debug((Object)e, (Throwable)e);
            return super.getDefaultValue();
        }
    }

    private String safeGetFieldValue() {
        try {
            Object o = this.field.get(null);
            if (o == null) {
                return super.getDefaultValue();
            }
            return o.toString();
        }
        catch (Exception ex) {
            return super.getDefaultValue();
        }
    }

    @Override
    public String setValue(String s) throws ConfigurablePropertyException {
        if (Modifier.isFinal(this.field.getModifiers())) {
            return "failed to assign final field: " + super.getQualifiedName();
        }
        if (Bootstrap.isFinished().booleanValue()) {
            try {
                Object o = super.getTypeParser().apply(s);
                this.fireChange(s);
                StaticDatabasePropertyEntry.update(this.getFieldCanonicalName(), this.getQualifiedName(), s);
                this.field.set(null, o);
                Logs.extreme().trace((Object)("--> Set property value:  " + super.getQualifiedName() + " to " + s));
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to set property: " + super.getQualifiedName() + " because of " + e.getMessage()));
                Logs.extreme().debug((Object)e, (Throwable)e);
                Exceptions.findAndRethrow(e, ConfigurablePropertyException.class);
                throw new ConfigurablePropertyException(e.getMessage(), e);
            }
            return this.getValue();
        }
        return super.getDefaultValue();
    }

    @Override
    public int compareTo(ConfigurableProperty that) {
        return this.getQualifiedName() != null ? this.getQualifiedName().compareTo(that.getQualifiedName()) : (that.getQualifiedName() == null ? 0 : -1);
    }

    @Override
    protected Object getQueryObject() throws Exception {
        return null;
    }

    @Override
    public boolean isDeferred() {
        return true;
    }

    public static class StaticPropertyBuilder
    implements ConfigurablePropertyBuilder {
        @Override
        public ConfigurableProperty buildProperty(Class c, Field field) throws ConfigurablePropertyException {
            Ats classAts = Ats.from(c);
            Ats fieldAts = Ats.from(field);
            if (classAts.has(ConfigurableClass.class) && fieldAts.has(ConfigurableField.class)) {
                ConfigurableClass classAnnote = classAts.get(ConfigurableClass.class);
                ConfigurableField annote = fieldAts.get(ConfigurableField.class);
                String description = annote.description();
                String defaultValue = annote.initial();
                String fqPrefix = classAnnote.root();
                String fq = fqPrefix + "." + field.getName().toLowerCase();
                String alias = classAnnote.alias();
                PropertyTypeParser p = PropertyTypeParser.get(field.getType());
                StaticPropertyEntry entry = null;
                Class<? extends PropertyChangeListener> changeListenerClass = annote.changeListener();
                PropertyChangeListener changeListener = PropertyChangeListeners.getListenerFromClass(changeListenerClass);
                int modifiers = field.getModifiers();
                if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)) {
                    entry = new StaticPropertyEntry(c, fqPrefix, field, description, defaultValue, p, annote.readonly(), annote.displayName(), annote.type(), alias, changeListener);
                    return entry;
                }
            }
            return null;
        }
    }
}

