/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.configurable;

import com.eucalyptus.configurable.StaticPropertyEntry;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.records.Logs;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.NoSuchElementException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityTransaction;
import javax.persistence.Lob;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_config")
@Table(name="config_static_property")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class StaticDatabasePropertyEntry
extends AbstractPersistent {
    @Column(name="config_static_field_name", nullable=false, unique=true)
    private String fieldName;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="config_static_field_value")
    private String value;
    @Column(name="config_static_prop_name", nullable=false, unique=true)
    private String propName;

    private StaticDatabasePropertyEntry() {
        this.fieldName = null;
    }

    private StaticDatabasePropertyEntry(String fieldName, String propName, String value) {
        this.propName = propName;
        this.fieldName = fieldName;
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StaticDatabasePropertyEntry update(String fieldName, String propName, String newFieldValue) throws Exception {
        try (TransactionResource db = Entities.transactionFor(StaticDatabasePropertyEntry.class);){
            StaticDatabasePropertyEntry dbEntry = Entities.uniqueResult(new StaticDatabasePropertyEntry(fieldName, propName, null));
            dbEntry.setValue(newFieldValue);
            db.commit();
            StaticDatabasePropertyEntry staticDatabasePropertyEntry = dbEntry;
            return staticDatabasePropertyEntry;
        }
    }

    static StaticDatabasePropertyEntry lookup(String fieldName, String propName, String defaultFieldValue) throws Exception {
        EntityTransaction db = Entities.get(StaticDatabasePropertyEntry.class);
        try {
            StaticDatabasePropertyEntry entity = Entities.uniqueResult(new StaticDatabasePropertyEntry(fieldName, propName, null));
            db.commit();
            return entity;
        }
        catch (Exception ex) {
            try {
                StaticDatabasePropertyEntry entity = Entities.persist(new StaticDatabasePropertyEntry(fieldName, propName, defaultFieldValue));
                db.commit();
                return entity;
            }
            catch (Exception ex1) {
                Logs.extreme().error((Object)("Failed to lookup static configuration property for: " + fieldName + " with property name: " + propName));
                db.rollback();
                throw ex;
            }
        }
    }

    private void setValue(String value) {
        this.value = value;
    }

    private String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getValue() {
        return this.value;
    }

    public String getPropName() {
        return this.propName;
    }

    private void setPropName(String propName) {
        this.propName = propName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.propName == null ? 0 : this.propName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StaticDatabasePropertyEntry other = (StaticDatabasePropertyEntry)obj;
        return !(this.propName == null ? other.propName != null : !this.propName.equals(other.propName));
    }

    @Upgrades.EntityUpgrade(entities={StaticPropertyEntry.class}, since=Upgrades.Version.v4_1_0, value=Empyrean.class)
    public static enum StaticPropertyEntryRenameServiceVMPropertyUpgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        public boolean apply(Class arg0) {
            ImmutableMap changes = ImmutableMap.builder().put((Object)"imaging.imaging_worker_availability_zones", (Object)new String[]{"services.imaging.worker.availability_zones", "com.eucalyptus.imaging.ImagingServiceProperties.availability_zones"}).put((Object)"imaging.imaging_worker_emi", (Object)new String[]{"services.imaging.worker.image", "com.eucalyptus.imaging.ImagingServiceProperties.image"}).put((Object)"imaging.imaging_worker_enabled", (Object)new String[]{"services.imaging.worker.configured", "com.eucalyptus.imaging.worker.ImagingServiceLaunchers.configured"}).put((Object)"imaging.imaging_worker_healthcheck", (Object)new String[]{"services.imaging.worker.healthcheck", "com.eucalyptus.imaging.ImagingServiceProperties.healthcheck"}).put((Object)"imaging.imaging_worker_instance_type", (Object)new String[]{"services.imaging.worker.instance_type", "com.eucalyptus.imaging.ImagingServiceProperties.instance_type"}).put((Object)"imaging.imaging_worker_keyname", (Object)new String[]{"services.imaging.worker.keyname", "com.eucalyptus.imaging.ImagingServiceProperties.keyname"}).put((Object)"imaging.imaging_worker_log_server", (Object)new String[]{"services.imaging.worker.log_server", "com.eucalyptus.imaging.ImagingServiceProperties.log_server"}).put((Object)"imaging.imaging_worker_log_server_port", (Object)new String[]{"services.imaging.worker.log_server_port", "com.eucalyptus.imaging.ImagingServiceProperties.log_server_port"}).put((Object)"imaging.imaging_worker_ntp_server", (Object)new String[]{"services.imaging.worker.ntp_server", "com.eucalyptus.imaging.ImagingServiceProperties.ntp_server"}).put((Object)"imaging.import_task_expiration_hours", (Object)new String[]{"services.imaging.import_task_expiration_hours", "com.eucalyptus.imaging.ImportTaskProperties.import_task_expiration_hours"}).put((Object)"imaging.import_task_timeout_minutes", (Object)new String[]{"services.imaging.import_task_timeout_minutes", "com.eucalyptus.imaging.ImportTaskProperties.import_task_timeout_minutes"}).put((Object)"loadbalancing.loadbalancer_app_cookie_duration", (Object)new String[]{"services.loadbalancing.worker.app_cookie_duration", "com.eucalyptus.loadbalancing.activities.LoadBalancerASGroupCreator.app_cookie_duration"}).put((Object)"loadbalancing.loadbalancer_dns_subdomain", (Object)new String[]{"services.loadbalancing.dns_subdomain", "com.eucalyptus.loadbalancing.LoadBalancerDnsRecord.dns_subdomain"}).put((Object)"loadbalancing.loadbalancer_dns_ttl", (Object)new String[]{"services.loadbalancing.dns_ttl", "com.eucalyptus.loadbalancing.LoadBalancerDnsRecord.dns_ttl"}).put((Object)"loadbalancing.loadbalancer_emi", (Object)new String[]{"services.loadbalancing.worker.image", "com.eucalyptus.loadbalancing.activities.LoadBalancerASGroupCreator.image"}).put((Object)"loadbalancing.loadbalancer_instance_type", (Object)new String[]{"services.loadbalancing.worker.instance_type", "com.eucalyptus.loadbalancing.activities.LoadBalancerASGroupCreator.instance_type"}).put((Object)"loadbalancing.loadbalancer_num_vm", (Object)new String[]{"services.loadbalancing.vm_per_zone", "com.eucalyptus.loadbalancing.activities.EventHandlerChainNew.vm_per_zone"}).put((Object)"loadbalancing.loadbalancer_restricted_ports", (Object)new String[]{"services.loadbalancing.restricted_ports", "com.eucalyptus.loadbalancing.LoadBalancerListener.restricted_ports"}).put((Object)"loadbalancing.loadbalancer_vm_keyname", (Object)new String[]{"services.loadbalancing.worker.keyname", "com.eucalyptus.loadbalancing.activities.LoadBalancerASGroupCreator.keyname"}).put((Object)"loadbalancing.loadbalancer_vm_ntp_server", (Object)new String[]{"services.loadbalancing.worker.ntp_server", "com.eucalyptus.loadbalancing.activities.LoadBalancerASGroupCreator.ntp_server"}).build();
            EntityTransaction db = Entities.get(StaticDatabasePropertyEntry.class);
            LOG.info((Object)"Updating service VM properties");
            try {
                List<StaticDatabasePropertyEntry> entities = Entities.query(new StaticDatabasePropertyEntry());
                for (StaticDatabasePropertyEntry entry : entities) {
                    if (entry.getPropName() == null || !changes.containsKey((Object)entry.getPropName())) continue;
                    String[] newProperty = (String[])changes.get((Object)entry.getPropName());
                    LOG.info((Object)("Upgrading: Copying property value of'" + entry.getPropName() + "' to '" + newProperty[0] + "'"));
                    StaticDatabasePropertyEntry.update(newProperty[1], newProperty[0], entry.getValue());
                    LOG.info((Object)("Deleting old property from DB'" + entry.getPropName() + "'"));
                    Entities.delete(entry);
                }
                db.commit();
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared(ex);
            }
            finally {
                if (db.isActive()) {
                    db.rollback();
                }
            }
        }

        static {
            LOG = Logger.getLogger(StaticPropertyEntryRenameServiceVMPropertyUpgrade.class);
        }
    }

    @Upgrades.EntityUpgrade(entities={StaticPropertyEntry.class}, since=Upgrades.Version.v4_0_0, value=Empyrean.class)
    public static enum StaticPropertyEntryUpgrade40 implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        private void configureIdentifierCanonicalizer() {
            try (TransactionResource db = Entities.transactionFor(StaticDatabasePropertyEntry.class);){
                try {
                    StaticDatabasePropertyEntry property = Entities.uniqueResult(new StaticDatabasePropertyEntry(null, "cloud.identifier_canonicalizer", null));
                    LOG.info((Object)"Setting resource identifier canonicalizer property to 'upper' for upgraded system.");
                    property.setValue("upper");
                }
                catch (NoSuchElementException e) {
                    LOG.info((Object)"Creating resource identifier canonicalizer property with value 'upper' for upgraded system.");
                    Entities.persist(new StaticDatabasePropertyEntry("com.eucalyptus.compute.identifier.ResourceIdentifiers.identifier_canonicalizer", "cloud.identifier_canonicalizer", "upper"));
                }
                db.commit();
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared(ex);
            }
        }

        private void deleteRemovedProperties(Iterable<String> propertyNames) {
            try (TransactionResource db = Entities.transactionFor(StaticDatabasePropertyEntry.class);){
                for (String propertyName : propertyNames) {
                    try {
                        StaticDatabasePropertyEntry property = Entities.uniqueResult(new StaticDatabasePropertyEntry(null, propertyName, null));
                        LOG.info((Object)("Deleting cloud property: " + propertyName));
                        Entities.delete(property);
                    }
                    catch (NoSuchElementException e) {
                        LOG.info((Object)("Property not found, skipped delete for: " + propertyName));
                    }
                }
                db.commit();
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared(ex);
            }
        }

        public boolean apply(Class arg0) {
            this.configureIdentifierCanonicalizer();
            this.deleteRemovedProperties(Lists.newArrayList((Object[])new String[]{"authentication.websession_life_in_minutes"}));
            return true;
        }

        static {
            LOG = Logger.getLogger(StaticPropertyEntryUpgrade40.class);
        }
    }

    @Upgrades.EntityUpgrade(entities={StaticPropertyEntry.class}, since=Upgrades.Version.v4_0_1, value=Empyrean.class)
    public static enum StaticPropertyEntryRenamePropertyCloudWatchUpgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        public boolean apply(Class arg0) {
            String CLOUDWATCH_DISABLE_CLOUDWATCH_SERVICE_OLD_FIELD_NAME = "com.eucalyptus.cloudwatch.CloudWatchService.disable_cloudwatch_service";
            String CLOUDWATCH_DISABLE_CLOUDWATCH_SERVICE_NEW_FIELD_NAME = "com.eucalyptus.cloudwatch.backend.CloudWatchBackendService.disable_cloudwatch_service";
            String CLOUDWATCH_DISABLE_CLOUDWATCH_SERVICE_PROP_NAME = "cloudwatch.disable_cloudwatch_service";
            EntityTransaction db = Entities.get(StaticDatabasePropertyEntry.class);
            try {
                List<StaticDatabasePropertyEntry> entities = Entities.query(new StaticDatabasePropertyEntry());
                for (StaticDatabasePropertyEntry entry : entities) {
                    if (!"com.eucalyptus.cloudwatch.CloudWatchService.disable_cloudwatch_service".equals(entry.getFieldName()) || !"cloudwatch.disable_cloudwatch_service".equals(entry.getPropName())) continue;
                    entry.setFieldName("com.eucalyptus.cloudwatch.backend.CloudWatchBackendService.disable_cloudwatch_service");
                    LOG.debug((Object)"Upgrading: Changing property cloudwatch.disable_cloudwatch_service field name'com.eucalyptus.cloudwatch.CloudWatchService.disable_cloudwatch_service' to 'com.eucalyptus.cloudwatch.backend.CloudWatchBackendService.disable_cloudwatch_service'");
                }
                db.commit();
                return true;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared(ex);
            }
        }

        static {
            LOG = Logger.getLogger(StaticPropertyEntryRenamePropertyUpgrade.class);
        }
    }

    @Upgrades.EntityUpgrade(entities={StaticPropertyEntry.class}, since=Upgrades.Version.v3_4_0, value=Empyrean.class)
    public static enum StaticPropertyEntryRenameExpermentalDNSPropertyUpgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        public boolean apply(Class arg0) {
            String EXPERIMENTAL_DNS_PREFIX = "experimental.dns.";
            String DNS_PREFIX = "dns.";
            EntityTransaction db = Entities.get(StaticDatabasePropertyEntry.class);
            try {
                List<StaticDatabasePropertyEntry> entities = Entities.query(new StaticDatabasePropertyEntry());
                for (StaticDatabasePropertyEntry entry : entities) {
                    if (entry.getPropName() == null || !entry.getPropName().startsWith("experimental.dns.")) continue;
                    String oldPropertyName = entry.getPropName();
                    String newPropertyName = "dns." + oldPropertyName.substring("experimental.dns.".length());
                    LOG.debug((Object)("Upgrading: Changing property '" + oldPropertyName + "' to '" + newPropertyName + "'"));
                    entry.setPropName(newPropertyName);
                }
                db.commit();
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared(ex);
            }
            finally {
                if (db.isActive()) {
                    db.rollback();
                }
            }
        }

        static {
            LOG = Logger.getLogger(StaticPropertyEntryRenameExpermentalDNSPropertyUpgrade.class);
        }
    }

    @Upgrades.EntityUpgrade(entities={StaticPropertyEntry.class}, since=Upgrades.Version.v3_3_0, value=Empyrean.class)
    public static enum StaticPropertyEntryRenamePropertyUpgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        public boolean apply(Class arg0) {
            String REPORTING_DEFAULT_POLL_INTERVAL_MINS_FIELD_NAME = "com.eucalyptus.reporting.modules.backend.DescribeSensorsListener.default_poll_interval_mins";
            String REPORTING_DEFAULT_POLL_INTERVAL_MINS = "reporting.default_poll_interval_mins";
            String CLOUD_MONITOR_DEFAULT_POLL_INTERVAL_MINS = "cloud.monitor.default_poll_interval_mins";
            EntityTransaction db = Entities.get(StaticDatabasePropertyEntry.class);
            try {
                List<StaticDatabasePropertyEntry> entities = Entities.query(new StaticDatabasePropertyEntry());
                for (StaticDatabasePropertyEntry entry : entities) {
                    if (!"com.eucalyptus.reporting.modules.backend.DescribeSensorsListener.default_poll_interval_mins".equals(entry.getFieldName()) || !"reporting.default_poll_interval_mins".equals(entry.getPropName())) continue;
                    entry.setPropName("cloud.monitor.default_poll_interval_mins");
                    LOG.debug((Object)"Upgrading: Changing property 'reporting.default_poll_interval_mins' to 'cloud.monitor.default_poll_interval_mins'");
                }
                db.commit();
                return true;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared(ex);
            }
        }

        static {
            LOG = Logger.getLogger(StaticPropertyEntryRenamePropertyUpgrade.class);
        }
    }

    @Upgrades.EntityUpgrade(entities={StaticPropertyEntry.class}, since=Upgrades.Version.v3_2_0, value=Empyrean.class)
    public static enum StaticPropertyEntryUpgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        public boolean apply(Class arg0) {
            EntityTransaction db = Entities.get(StaticDatabasePropertyEntry.class);
            try {
                List<StaticDatabasePropertyEntry> entities = Entities.query(new StaticDatabasePropertyEntry());
                for (StaticDatabasePropertyEntry entry : entities) {
                    LOG.debug((Object)("Upgrading: " + entry.getPropName() + "=" + entry.getValue()));
                }
                db.commit();
                return true;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared(ex);
            }
        }

        static {
            LOG = Logger.getLogger(StaticPropertyEntryUpgrade.class);
        }
    }
}

