/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.configurable;

import com.eucalyptus.configurable.AbstractConfigurableProperty;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyBuilder;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.configurable.PropertyChangeListeners;
import com.eucalyptus.configurable.PropertyTypeParser;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.log4j.Logger;

public class SingletonDatabasePropertyEntry
extends AbstractConfigurableProperty
implements ConfigurableProperty {
    private static Logger LOG = Logger.getLogger(SingletonDatabasePropertyEntry.class);

    public SingletonDatabasePropertyEntry(Class definingClass, String entrySetName, Field field, String description, String defaultValue, PropertyTypeParser typeParser, Boolean readOnly, String displayName, ConfigurableFieldType widgetType, String alias, PropertyChangeListener changeListener) {
        super(definingClass, entrySetName, field, defaultValue, description, typeParser, readOnly, displayName, widgetType, alias, changeListener);
    }

    @Override
    protected Object getQueryObject() throws Exception {
        return this.getNoArgConstructor().newInstance(new Object[0]);
    }

    @Override
    public int compareTo(ConfigurableProperty that) {
        return this.getQualifiedName() != null ? this.getQualifiedName().compareTo(that.getQualifiedName()) : (that.getQualifiedName() == null ? 0 : -1);
    }

    public static class DatabasePropertyBuilder
    implements ConfigurablePropertyBuilder {
        @Override
        public ConfigurableProperty buildProperty(Class c, Field f) throws ConfigurablePropertyException {
            block4: {
                if (c.isAnnotationPresent(Entity.class) && c.getAnnotation(ConfigurableClass.class).singleton() && f.isAnnotationPresent(ConfigurableField.class)) {
                    LOG.trace((Object)("Checking field: " + c.getName() + "." + f.getName()));
                    ConfigurableClass classAnnote = c.getAnnotation(ConfigurableClass.class);
                    ConfigurableField annote = f.getAnnotation(ConfigurableField.class);
                    String fqPrefix = classAnnote.root();
                    String alias = classAnnote.alias();
                    String description = annote.description();
                    String defaultValue = annote.initial();
                    PropertyTypeParser p = PropertyTypeParser.get(f.getType());
                    PropertyChangeListener listener = PropertyChangeListeners.getListenerFromClass(annote.changeListener());
                    try {
                        if (!Modifier.isStatic(f.getModifiers()) && !f.isAnnotationPresent(Transient.class)) {
                            SingletonDatabasePropertyEntry prop = new SingletonDatabasePropertyEntry(c, fqPrefix, f, description, defaultValue, p, annote.readonly(), annote.displayName(), annote.type(), alias, listener);
                            return prop;
                        }
                        break block4;
                    }
                    catch (Exception e) {
                        LOG.debug((Object)e, (Throwable)e);
                        return null;
                    }
                }
                return null;
            }
            return null;
        }
    }
}

