/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.configurable;

import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyBuilder;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.MultiDatabasePropertyEntry;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.configurable.SingletonDatabasePropertyEntry;
import com.eucalyptus.configurable.StaticPropertyEntry;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import edu.ucsb.eucalyptus.msgs.ComponentProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class PropertyDirectory {
    private static final Logger LOG = Logger.getLogger(PropertyDirectory.class);
    private static final ReadWriteLock fqLock = new ReentrantReadWriteLock();
    private static final Map<String, ConfigurableProperty> fqMap = Maps.newHashMap();
    private static final Multimap<String, ConfigurableProperty> fqPrefixMap = TreeMultimap.create();
    private static final Map<String, ConfigurableProperty> fqPendingMap = Maps.newHashMap();
    private static final Multimap<String, ConfigurableProperty> fqPendingPrefixMap = HashMultimap.create();
    private static final List<ConfigurablePropertyBuilder> builders = ImmutableList.of((Object)new StaticPropertyEntry.StaticPropertyBuilder(), (Object)new SingletonDatabasePropertyEntry.DatabasePropertyBuilder(), (Object)new MultiDatabasePropertyEntry.DatabasePropertyBuilder());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConfigurableProperty buildPropertyEntry(Class c, Field field) {
        fqLock.writeLock().lock();
        try {
            for (ConfigurablePropertyBuilder b : builders) {
                ConfigurableProperty prop;
                block12: {
                    prop = null;
                    try {
                        prop = b.buildProperty(c, field);
                    }
                    catch (ConfigurablePropertyException e) {
                        throw e;
                    }
                    catch (Exception t) {
                        LOG.error((Object)("Failed to prepare configurable field: " + c.getCanonicalName() + "." + field.getName()), (Throwable)t);
                    }
                    if (prop == null) continue;
                    if (prop.isDeferred()) {
                        if (fqPendingMap.containsKey(prop.getQualifiedName())) continue;
                        fqPendingMap.put(prop.getQualifiedName(), prop);
                        fqPendingPrefixMap.put((Object)prop.getEntrySetName(), (Object)prop);
                        ConfigurableProperty t = prop;
                        fqLock.writeLock().unlock();
                        return t;
                    }
                    if (fqMap.containsKey(prop.getQualifiedName())) break block12;
                    fqMap.put(prop.getQualifiedName(), prop);
                    {
                        catch (ConfigurablePropertyException e) {
                            LOG.debug((Object)e, (Throwable)e);
                            continue;
                        }
                    }
                    fqPrefixMap.put((Object)prop.getEntrySetName(), (Object)prop);
                    ConfigurableProperty t = prop;
                    fqLock.writeLock().unlock();
                    return t;
                }
                RuntimeException r = new RuntimeException("Duplicate configurable field in same config file: \n-> " + fqMap.get(prop.getQualifiedName()).getDefiningClass().getCanonicalName() + "." + field.getName() + "\n" + "-> " + c.getCanonicalName() + "." + field.getName() + "\n");
                LOG.fatal((Object)r, (Throwable)r);
                throw r;
            }
            fqLock.writeLock().unlock();
            return null;
        }
        catch (Throwable throwable) {
            fqLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getPropertyEntrySetNames() {
        fqLock.readLock().lock();
        try {
            ArrayList arrayList = Lists.newArrayList((Iterable)fqPrefixMap.keySet());
            return arrayList;
        }
        finally {
            fqLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ConfigurableProperty> getPropertyEntrySet() {
        fqLock.readLock().lock();
        try {
            ArrayList props = Lists.newArrayList();
            for (String fqPrefix : fqPrefixMap.keySet()) {
                props.addAll(PropertyDirectory.getPropertyEntrySet(fqPrefix));
            }
            ArrayList arrayList = props;
            return arrayList;
        }
        finally {
            fqLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ConfigurableProperty> getPropertyEntrySet(String prefix) {
        fqLock.readLock().lock();
        try {
            ArrayList props = Lists.newArrayList();
            for (ConfigurableProperty fq : fqPrefixMap.get((Object)prefix)) {
                props.add(fq);
            }
            ArrayList arrayList = props;
            return arrayList;
        }
        finally {
            fqLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ConfigurableProperty> getPropertyEntrySet(String prefix, String alias) {
        fqLock.readLock().lock();
        try {
            ArrayList props = Lists.newArrayList();
            for (ConfigurableProperty fq : fqPrefixMap.get((Object)prefix)) {
                if (!fq.getAlias().equals(alias)) continue;
                props.add(fq);
            }
            ArrayList arrayList = props;
            return arrayList;
        }
        finally {
            fqLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurableProperty getPropertyEntry(String fq) throws IllegalAccessException {
        fqLock.readLock().lock();
        try {
            if (!fqMap.containsKey(fq)) {
                throw new IllegalAccessException("No such property: " + fq);
            }
            ConfigurableProperty configurableProperty = fqMap.get(fq);
            return configurableProperty;
        }
        finally {
            fqLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Map.Entry<String, ConfigurableProperty>> getPendingPropertyEntries() {
        fqLock.readLock().lock();
        try {
            Collection collection = fqPendingPrefixMap.entries();
            return collection;
        }
        finally {
            fqLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ConfigurableProperty> getPendingPropertyValues() {
        fqLock.readLock().lock();
        try {
            Collection collection = fqPendingPrefixMap.values();
            return collection;
        }
        finally {
            fqLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ConfigurableProperty> getPendingPropertyEntrySet(String prefix) {
        fqLock.readLock().lock();
        try {
            ArrayList props = Lists.newArrayList();
            for (ConfigurableProperty fq : fqPendingPrefixMap.get((Object)prefix)) {
                props.add(fq);
            }
            ArrayList arrayList = props;
            return arrayList;
        }
        finally {
            fqLock.readLock().unlock();
        }
    }

    public static String getEntrySetDescription(String entrySetName) {
        return "Temporary description";
    }

    public static List<ComponentProperty> getComponentPropertySet(String prefix) {
        ArrayList componentProps = Lists.newArrayList();
        List<ConfigurableProperty> props = PropertyDirectory.getPropertyEntrySet(prefix);
        for (ConfigurableProperty prop : props) {
            componentProps.add(new ComponentProperty(prop.getWidgetType().toString(), prop.getDisplayName(), prop.getValue(), prop.getQualifiedName()));
        }
        return componentProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addProperty(ConfigurableProperty prop) {
        fqLock.writeLock().lock();
        try {
            if (!fqMap.containsKey(prop.getQualifiedName())) {
                fqMap.put(prop.getQualifiedName(), prop);
                fqPrefixMap.put((Object)prop.getEntrySetName(), (Object)prop);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            fqLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProperty(ConfigurableProperty prop) {
        fqLock.writeLock().lock();
        try {
            if (fqMap.containsKey(prop.getQualifiedName())) {
                fqMap.remove(prop.getQualifiedName());
                fqPrefixMap.remove((Object)prop.getEntrySetName(), (Object)prop);
            }
        }
        finally {
            fqLock.writeLock().unlock();
        }
    }

    public static List<ComponentProperty> getComponentPropertySet(String prefix, String alias) {
        ArrayList componentProps = Lists.newArrayList();
        List<ConfigurableProperty> props = PropertyDirectory.getPropertyEntrySet(prefix, alias);
        for (ConfigurableProperty prop : props) {
            componentProps.add(new ComponentProperty(prop.getWidgetType().toString(), prop.getDisplayName(), prop.getValue(), prop.getQualifiedName()));
        }
        return componentProps;
    }

    public static class NoopEventListener
    implements PropertyChangeListener {
        public static NoopEventListener NOOP = new NoopEventListener();

        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
        }
    }
}

