/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.configurable;

import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.configurable.PropertyDirectory;
import com.google.common.collect.Constraint;
import org.apache.log4j.Logger;

public class PropertyChangeListeners {
    public static final Logger LOG = Logger.getLogger(PropertyChangeListener.class);

    public static void applyConstraint(Object newValue, Constraint<Object> ... constraints) throws ConfigurablePropertyException {
        for (Constraint<Object> testNewValue : constraints) {
            try {
                Object object = testNewValue.checkElement(newValue);
            }
            catch (Exception ex) {
                throw new ConfigurablePropertyException("Failed to evaluate constraint " + testNewValue + " for new value: " + newValue + " because of: " + ex.getMessage());
            }
        }
    }

    public static PropertyChangeListener withConstraint(Constraint<Object> testNewValue) {
        return new PropertyChangeListener(){

            public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            }
        };
    }

    public static PropertyChangeListener getListenerFromClass(Class<? extends PropertyChangeListener> changeListenerClass) {
        PropertyChangeListener changeListener;
        if (!changeListenerClass.equals(PropertyDirectory.NoopEventListener.class)) {
            if (changeListenerClass.isEnum()) {
                changeListener = changeListenerClass.getEnumConstants()[0];
            } else {
                try {
                    changeListener = changeListenerClass.newInstance();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Can't set listener to " + changeListenerClass));
                    LOG.error((Object)e, e);
                    changeListener = PropertyDirectory.NoopEventListener.NOOP;
                }
            }
        } else {
            changeListener = PropertyDirectory.NoopEventListener.NOOP;
        }
        LOG.debug((Object)("Property change listener set to: " + changeListener.getClass()));
        return changeListener;
    }

    public static enum IsBoolean implements PropertyChangeListener
    {
        INSTANCE;


        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            String lowerValue = newValue.toString().toLowerCase();
            if (!"true".equals(lowerValue) && !"false".equals(lowerValue)) {
                throw new ConfigurablePropertyException("Value must be 'true' or 'false'");
            }
        }
    }

    public static enum IsPositiveInteger implements PropertyChangeListener
    {
        INSTANCE;


        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            PropertyChangeListeners.applyConstraint(newValue, new Constraint<Object>(){

                public Object checkElement(Object element) {
                    Number numElem;
                    if (Number.class.isAssignableFrom(element.getClass()) && (numElem = (Number)element).doubleValue() < 0.0) {
                        throw new IllegalArgumentException("Value must be greater than zero");
                    }
                    return element;
                }
            });
        }
    }
}

