/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.configurable;

import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.PropertyDirectory;
import com.google.common.collect.ObjectArrays;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class PropertiesDiscovery
extends ServiceJarDiscovery {
    private static Logger LOG = Logger.getLogger(PropertiesDiscovery.class);

    @Override
    public Double getPriority() {
        return 0.4;
    }

    @Override
    public boolean processClass(Class c) throws Exception {
        if (c.getAnnotation(ConfigurableClass.class) != null) {
            LOG.trace((Object)("-> Registering configuration properties for entry: " + c.getName()));
            LOG.trace((Object)("Checking fields: " + Arrays.asList(c.getDeclaredFields())));
            for (Field f : (Field[])ObjectArrays.concat((Object[])c.getFields(), (Object[])c.getDeclaredFields(), Field.class)) {
                LOG.trace((Object)("Checking field: " + f));
                try {
                    ConfigurableProperty prop = PropertyDirectory.buildPropertyEntry(c, f);
                    if (prop == null) continue;
                    LOG.info((Object)("--> Registered property: " + prop.getQualifiedName()));
                }
                catch (Exception e) {
                    LOG.debug((Object)e, (Throwable)e);
                }
            }
            return true;
        }
        return false;
    }
}

