/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.configurable;

import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.PropertyDirectory;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.Fields;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;

public class Properties {
    public static ConfigurableProperty lookup(String fullyQualifiedName) throws IllegalAccessException {
        return PropertyDirectory.getPropertyEntry(fullyQualifiedName);
    }

    public static ConfigurableProperty lookup(Class<?> declaringClass, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Field f = Fields.get(declaringClass, fieldName);
        return Properties.lookup(Properties.propertyName(f));
    }

    public static String propertyName(Field f) {
        Class<?> c = f.getDeclaringClass();
        if (c.isAnnotationPresent(ConfigurableClass.class) && f.isAnnotationPresent(ConfigurableField.class)) {
            ConfigurableClass classAnnote = c.getAnnotation(ConfigurableClass.class);
            return classAnnote.root() + "." + f.getName().toLowerCase();
        }
        throw new NoSuchElementException(Ats.from(f).toString());
    }
}

