/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.configurable;

import com.eucalyptus.configurable.AbstractConfigurableProperty;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.configurable.ConfigurableIdentifier;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyBuilder;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.configurable.PropertyChangeListeners;
import com.eucalyptus.configurable.PropertyTypeParser;
import com.eucalyptus.util.Classes;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.NaturalId;

public class MultiDatabasePropertyEntry
extends AbstractConfigurableProperty
implements ConfigurableProperty {
    private static Logger LOG = Logger.getLogger(MultiDatabasePropertyEntry.class);
    private Method setIdentifier;
    private Field identifierField;
    private String identifierValue;
    private String identifiedMethodName;

    public MultiDatabasePropertyEntry(Class definingClass, String entrySetName, Field field, Field identifierField, String description, String defaultValue, PropertyTypeParser typeParser, Boolean readOnly, String displayName, ConfigurableFieldType widgetType, String alias, String identifierValue, PropertyChangeListener changeListener) {
        super(definingClass, entrySetName, field, defaultValue, description, typeParser, readOnly, displayName, widgetType, alias, changeListener);
        this.identifierField = identifierField;
        this.identifiedMethodName = identifierField.getName().substring(0, 1).toUpperCase() + identifierField.getName().substring(1);
        this.identifierValue = identifierValue;
    }

    private Method lookupSetIdentifierMethod() {
        try {
            Method setMethod = this.getDefiningClass().getMethod("set" + this.identifiedMethodName, this.identifierField.getType());
            setMethod.setAccessible(true);
            return setMethod;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to obtain reference to method for setting the identifier field: " + this.identifierField.getName() + "/" + this.identifiedMethodName + " in type " + this.getDefiningClass().getSimpleName());
        }
    }

    @Override
    protected Object getQueryObject() throws Exception {
        Object queryObject = super.getDefiningClass().newInstance();
        try {
            this.setIdentifier = this.setIdentifier != null ? this.setIdentifier : this.lookupSetIdentifierMethod();
            this.setIdentifier.invoke(queryObject, this.identifierValue);
        }
        catch (Exception e1) {
            try {
                this.lookupSetIdentifierMethod().invoke(queryObject, this.identifierValue);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                return ex.getMessage();
            }
        }
        return queryObject;
    }

    public String getIdentifiedMethodName() {
        return this.identifiedMethodName;
    }

    public void setIdentifiedMethodName(String identifiedMethodName) {
        this.identifiedMethodName = identifiedMethodName;
    }

    public void setIdentifierValue(String value) {
        this.identifierValue = value;
    }

    @Override
    public String getEntrySetName() {
        if (this.identifierValue != null) {
            return this.identifierValue + "." + super.getEntrySetName();
        }
        return super.getEntrySetName();
    }

    @Override
    public String getQualifiedName() {
        if (this.identifierValue != null) {
            return this.identifierValue + "." + super.getQualifiedName();
        }
        return super.getQualifiedName();
    }

    public MultiDatabasePropertyEntry getClone(String idValue) {
        return new MultiDatabasePropertyEntry(this.getDefiningClass(), this.getEntrySetName(), this.getField(), this.identifierField, this.getDescription(), this.getDefaultValue(), this.getTypeParser(), this.getReadOnly(), this.getDisplayName(), this.getWidgetType(), this.getAlias(), idValue, this.getChangeListener());
    }

    @Override
    public int compareTo(ConfigurableProperty that) {
        return this.getQualifiedName() != null ? this.getQualifiedName().compareTo(that.getQualifiedName()) : (that.getQualifiedName() == null ? 0 : -1);
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiDatabasePropertyEntry other = (MultiDatabasePropertyEntry)obj;
        return this.compareTo(other) == 0;
    }

    public static class DatabasePropertyBuilder
    implements ConfigurablePropertyBuilder {
        @Override
        public ConfigurableProperty buildProperty(Class c, Field f) throws ConfigurablePropertyException {
            if (c.isAnnotationPresent(Entity.class) && !c.getAnnotation(ConfigurableClass.class).singleton()) {
                ConfigurableClass classAnnote = c.getAnnotation(ConfigurableClass.class);
                Field identifierField = this.findIdentifierField(c);
                if (identifierField == null) {
                    return null;
                }
                if (f.isAnnotationPresent(ConfigurableField.class)) {
                    LOG.trace((Object)("Checking field: " + c.getName() + "." + f.getName()));
                    ConfigurableField annote = f.getAnnotation(ConfigurableField.class);
                    String fqPrefix = classAnnote.root();
                    String alias = classAnnote.alias();
                    String description = annote.description();
                    String defaultValue = annote.initial();
                    PropertyTypeParser p = PropertyTypeParser.get(f.getType());
                    PropertyChangeListener listener = PropertyChangeListeners.getListenerFromClass(annote.changeListener());
                    try {
                        if (!Modifier.isStatic(f.getModifiers()) && !f.isAnnotationPresent(Transient.class)) {
                            MultiDatabasePropertyEntry prop = new MultiDatabasePropertyEntry(c, fqPrefix, f, identifierField, description, defaultValue, p, annote.readonly(), annote.displayName(), annote.type(), alias, null, listener);
                            return prop;
                        }
                    }
                    catch (Exception e) {
                        LOG.debug((Object)e, (Throwable)e);
                        return null;
                    }
                }
            } else {
                return null;
            }
            return null;
        }

        private Field findIdentifierField(Class c) throws SecurityException {
            for (Class ancestor : Classes.classAncestors(c)) {
                for (Field field : ancestor.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(ConfigurableIdentifier.class)) continue;
                    return field;
                }
                for (Field field : c.getFields()) {
                    if (!field.isAnnotationPresent(NaturalId.class)) continue;
                    return field;
                }
            }
            return null;
        }
    }
}

