/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.configurable;

import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.configurable.PropertyDirectory;
import com.eucalyptus.configurable.PropertyTypeParser;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Exceptions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.NoSuchElementException;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;

public abstract class AbstractConfigurableProperty
implements ConfigurableProperty {
    private static Logger LOG = Logger.getLogger(AbstractConfigurableProperty.class);
    private final String entrySetName;
    private final String fieldName;
    private final String qualifiedName;
    private final String description;
    private final PropertyTypeParser typeParser;
    private final String defaultValue;
    private final Class definingClass;
    private final Constructor noArgConstructor;
    private final Boolean readOnly;
    private final String displayName;
    private final ConfigurableFieldType widgetType;
    private final String alias;
    private final PropertyChangeListener changeListener;
    private final Field field;
    private final Method getter;
    private final Method setter;
    private final Class[] setArgs;
    private final boolean deferred;

    public AbstractConfigurableProperty(Class definingClass, String entrySetName, Field field, String defaultValue, String description, PropertyTypeParser typeParser, Boolean readOnly, String displayName, ConfigurableFieldType widgetType, String alias) {
        this(definingClass, entrySetName, field, defaultValue, description, typeParser, readOnly, displayName, widgetType, alias, PropertyDirectory.NoopEventListener.NOOP);
    }

    public AbstractConfigurableProperty(Class definingClass, String entrySetName, Field field, String defaultValue, String description, PropertyTypeParser typeParser, Boolean readOnly, String displayName, ConfigurableFieldType widgetType, String alias, PropertyChangeListener changeListener) {
        Constructor cons;
        block2: {
            this.definingClass = definingClass;
            this.field = field;
            this.fieldName = this.field.getName().toLowerCase();
            this.entrySetName = entrySetName.toLowerCase();
            this.qualifiedName = this.entrySetName + "." + this.fieldName;
            this.description = description;
            this.typeParser = typeParser;
            this.defaultValue = defaultValue;
            this.readOnly = readOnly;
            this.displayName = displayName;
            this.widgetType = widgetType;
            this.alias = alias;
            this.changeListener = changeListener;
            cons = null;
            try {
                cons = this.definingClass.getConstructor(new Class[0]);
                cons.setAccessible(true);
            }
            catch (Exception ex) {
                if (Modifier.isStatic(field.getModifiers())) break block2;
                LOG.debug((Object)("Known declared constructors: " + this.getDefiningClass().getDeclaredConstructors()));
                LOG.debug((Object)("Known constructors: " + this.getDefiningClass().getConstructors()));
                LOG.debug((Object)ex, (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        this.noArgConstructor = cons;
        this.setArgs = new Class[]{this.field.getType()};
        this.getter = this.getReflectedMethod("get", this.field, new Class[0]);
        this.setter = this.getReflectedMethod("set", this.field, this.setArgs);
        ConfigurableClass configurableAnnot = definingClass.getAnnotation(ConfigurableClass.class);
        this.deferred = configurableAnnot.deferred();
    }

    private Method getReflectedMethod(String namePrefix, Field field, Class ... setArgs2) {
        try {
            String name = namePrefix + this.field.getName().substring(0, 1).toUpperCase() + this.field.getName().substring(1);
            Method m = this.definingClass.getDeclaredMethod(name, setArgs2);
            m.setAccessible(true);
            return m;
        }
        catch (Exception e) {
            if (!Modifier.isStatic(field.getModifiers())) {
                LOG.debug((Object)("Known declared methods: " + this.getDefiningClass().getDeclaredMethods()));
                LOG.debug((Object)("Known methods: " + this.getDefiningClass().getMethods()));
                LOG.debug((Object)e, (Throwable)e);
            }
            return null;
        }
    }

    protected abstract Object getQueryObject() throws Exception;

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getEntrySetName() {
        return this.entrySetName;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public PropertyTypeParser getTypeParser() {
        return this.typeParser;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getValue() {
        try {
            EntityTransaction trans = Entities.get(this.getDefiningClass());
            try {
                Object o = Entities.uniqueResult(this.getQueryObject());
                Object prop = this.getter.invoke(o, new Object[0]);
                String result = prop != null ? prop.toString() : "<unset>";
                trans.commit();
                return result;
            }
            catch (Exception e) {
                Logs.exhaust().error((Object)e, (Throwable)e);
                trans.rollback();
                return "<unset>";
            }
        }
        catch (Exception e) {
            Logs.exhaust().error((Object)e, (Throwable)e);
            return "<unset>";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String setValue(String s) throws ConfigurablePropertyException {
        try (TransactionResource trans = Entities.transactionFor(this.getDefiningClass());){
            List<Object> resultList = Entities.query(this.getQueryObject());
            Object prop = this.getTypeParser().apply(s);
            if (resultList == null) throw new NoSuchElementException("no entities found for property");
            if (resultList.size() == 0) {
                throw new NoSuchElementException("no entities found for property");
            }
            this.fireChange(prop);
            LOG.debug((Object)"Running setters.");
            for (Object obj : resultList) {
                this.setter.invoke(obj, prop);
            }
            trans.commit();
            String string = s;
            return string;
        }
        catch (Exception e) {
            Logs.exhaust().error((Object)e, (Throwable)e);
            Exceptions.findAndRethrow(e, ConfigurablePropertyException.class);
            throw new ConfigurablePropertyException(e.getMessage(), e);
        }
    }

    @Override
    public Class getDefiningClass() {
        return this.definingClass;
    }

    public Constructor getNoArgConstructor() {
        return this.noArgConstructor;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public ConfigurableFieldType getWidgetType() {
        return this.widgetType;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    protected void fireChange(Object newValue) throws ConfigurablePropertyException {
        if (!PropertyDirectory.NoopEventListener.class.equals(this.changeListener.getClass())) {
            this.changeListener.fireChange(this, newValue);
        }
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public PropertyChangeListener getChangeListener() {
        return this.changeListener;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public boolean isDeferred() {
        return this.deferred;
    }
}

