/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.config;

import com.eucalyptus.bootstrap.CanBootstrap;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentFullName;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.Internets;
import com.eucalyptus.util.fsm.StateMachine;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.NoSuchElementException;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;

@Entity
@PersistenceContext(name="eucalyptus_config")
@Table(name="config_component_base")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(length=255)
public class ComponentConfiguration
extends AbstractPersistent
implements ServiceConfiguration {
    @Transient
    private static final long serialVersionUID = 1L;
    @Transient
    private static Logger LOG = Logger.getLogger(ComponentConfiguration.class);
    @Column(name="config_component_partition")
    private String partition;
    @NaturalId
    @Column(name="config_component_name", updatable=false, unique=true, nullable=false)
    private String name;
    @ConfigurableField(description="Address which the cloud controller should use to contact this service.", displayName="Host name", readonly=true)
    @Column(name="config_component_hostname")
    private volatile String hostName;
    @Column(name="config_component_port")
    private volatile Integer port;
    @Column(name="config_component_service_path")
    private String servicePath;

    protected ComponentConfiguration() {
    }

    protected ComponentConfiguration(String partition, String name, String hostName, String servicePath) {
        this.partition = partition;
        this.name = name;
        this.hostName = hostName;
        this.servicePath = servicePath;
    }

    protected ComponentConfiguration(String partition, String name, String hostName, Integer port, String servicePath) {
        this.partition = partition;
        this.name = name;
        this.hostName = hostName;
        this.port = port;
        this.servicePath = servicePath;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.getHostName(), (int)this.getPort());
    }

    @Override
    public InetAddress getInetAddress() {
        return this.getSocketAddress().getAddress();
    }

    @Override
    @Deprecated
    public URI getUri() {
        return ServiceUris.remote(this, new String[0]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Deprecated
    public final ComponentId getComponentId() {
        return this.lookupComponentId();
    }

    public ComponentId lookupComponentId() {
        if (!Ats.from(this).has(ComponentPart.class)) {
            throw new RuntimeException("BUG: A component configuration must have the @ComponentPart(ComponentId.class) annotation");
        }
        return ComponentIds.lookup(Ats.from(this).get(ComponentPart.class).value());
    }

    @Override
    public final CanBootstrap lookupBootstrapper() {
        return Components.lookup(this.lookupComponentId()).getBootstrapper();
    }

    @Override
    public Boolean isHostLocal() {
        try {
            return this.port == -1 ? true : Internets.testLocal(this.getHostName());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Boolean isVmLocal() {
        try {
            return this.port == -1 ? true : Internets.testLocal(this.getHostName());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public final FullName getFullName() {
        return ComponentFullName.getInstance(this, new String[0]);
    }

    @Override
    public int compareTo(ServiceConfiguration that) {
        return (this.partition + this.name).compareTo(that.getPartition() + that.getName());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ServiceConfiguration ").append(this.lookupComponentId().name()).append(" ");
        try {
            builder.append(this.getFullName().toString()).append(" ").append(this.hostName).append(":").append(this.port).append(":").append(this.servicePath).append(":");
        }
        catch (Exception ex) {
            builder.append(this.partition).append(":").append(this.name).append(":").append(this.hostName).append(":").append(this.port).append(":").append(this.servicePath).append(":");
        }
        if (this.isVmLocal().booleanValue()) {
            builder.append("vm-local:");
        }
        if (this.isHostLocal().booleanValue()) {
            builder.append("host-local:");
        }
        builder.append(this.lookupState());
        return builder.toString();
    }

    public String toStrings() {
        return String.format("ServiceConfiguration %s:%s:%s:%s:%s:%s:%s%s", this.getComponentId().name(), this.partition, this.name, this.hostName, this.port, this.servicePath, this.isVmLocal() != false ? "vm-local:" : "", this.isHostLocal() != false ? "host-local:" : "");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 0;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!this.getClass().equals(that.getClass())) {
            return false;
        }
        ComponentConfiguration other = (ComponentConfiguration)that;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public String getPartition() {
        return this.partition;
    }

    @Override
    public void setPartition(String partition) {
        this.partition = partition;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public void setPort(Integer port) {
        this.port = port;
    }

    @Override
    public String getServicePath() {
        return this.servicePath;
    }

    @Override
    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Partition lookupPartition() {
        return Partitions.lookupByName(this.getPartition());
    }

    @Override
    public StateMachine<ServiceConfiguration, Component.State, Component.Transition> getStateMachine() {
        return Components.lookup(this.lookupComponentId()).getStateMachine(this);
    }

    @Override
    public StateMachine<ServiceConfiguration, Component.State, Component.Transition> lookupStateMachine() {
        return this.getStateMachine();
    }

    @Override
    public Component.State lookupState() {
        try {
            return this.lookupStateMachine().getState();
        }
        catch (NoSuchElementException ex) {
            return Component.State.PRIMORDIAL;
        }
    }
}

