/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component.id;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.component.annotation.Description;
import com.eucalyptus.component.annotation.FaultLogPrefix;
import com.eucalyptus.component.annotation.InternalService;
import com.eucalyptus.component.annotation.Partition;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.util.Internets;
import org.jboss.netty.channel.ChannelPipelineFactory;

@Partition(value={Eucalyptus.class})
@FaultLogPrefix(value="cloud")
@Description(value="The Cluster Controller service")
public class ClusterController
extends ComponentId {
    private static final long serialVersionUID = 1L;
    public static final ComponentId INSTANCE = new ClusterController();
    private static ChannelPipelineFactory clusterPipeline;

    public ClusterController() {
        super("cluster");
    }

    @Override
    public Integer getPort() {
        return 8774;
    }

    @Override
    public String getLocalEndpointName() {
        return ServiceUris.remote((ComponentId)this, Internets.localHostInetAddress(), this.getPort(), new String[0]).toASCIIString();
    }

    @Override
    public ChannelPipelineFactory getClientPipeline() {
        ChannelPipelineFactory factory = null;
        factory = super.getClientPipeline();
        if (factory == null) {
            clusterPipeline = clusterPipeline != null ? clusterPipeline : ClusterController.helpGetClientPipeline("com.eucalyptus.ws.client.pipeline.ClusterClientPipelineFactory");
            factory = clusterPipeline;
        }
        return factory;
    }

    @Override
    public String getServicePath(String ... pathParts) {
        return "/axis2/services/EucalyptusCC";
    }

    @Override
    public String getInternalServicePath(String ... pathParts) {
        return this.getServicePath(pathParts);
    }

    @Partition(value={ClusterController.class})
    @InternalService
    @FaultLogPrefix(value="cloud")
    public static class GatherLogService
    extends ComponentId {
        private static final long serialVersionUID = 1L;
        private static ChannelPipelineFactory logPipeline;

        public GatherLogService() {
            super("gatherlog");
        }

        @Override
        public Integer getPort() {
            return 8774;
        }

        @Override
        public String getLocalEndpointName() {
            return ServiceUris.remote((ComponentId)this, Internets.localHostInetAddress(), this.getPort(), new String[0]).toASCIIString();
        }

        @Override
        public String getServicePath(String ... pathParts) {
            return "/axis2/services/EucalyptusGL";
        }

        @Override
        public String getInternalServicePath(String ... pathParts) {
            return this.getServicePath(pathParts);
        }

        @Override
        public ChannelPipelineFactory getClientPipeline() {
            ChannelPipelineFactory factory = null;
            factory = super.getClientPipeline();
            if (factory == null) {
                logPipeline = logPipeline != null ? logPipeline : GatherLogService.helpGetClientPipeline("com.eucalyptus.ws.client.pipeline.GatherLogClientPipeline");
                factory = logPipeline;
            }
            return factory;
        }
    }
}

