/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component.groups;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.groups.ServiceGroup;
import com.eucalyptus.component.groups.ServiceGroupConfiguration;
import com.eucalyptus.util.Classes;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class ServiceGroups {
    private static Logger LOG = Logger.getLogger(ServiceGroups.class);

    public static ServiceGroup lookup(ServiceConfiguration config) {
        if (ServiceGroups.isGroup(config)) {
            return (ServiceGroup)config.getComponentId();
        }
        throw new NoSuchElementException("Failed to lookup service group for: " + config);
    }

    public static boolean isGroup(ServiceConfiguration config) {
        return config.getComponentId() instanceof ServiceGroup;
    }

    public static Collection<ServiceGroup> listMembership(ComponentId member) {
        ArrayList members = Lists.newArrayList();
        for (ServiceGroup g : ((Multimap)ServiceGroupTableSupplier.INSTANCE.get()).keySet()) {
            if (!g.apply(member)) continue;
            members.add(g);
        }
        return members;
    }

    public static Collection<? extends ComponentId> listMembers(ServiceGroup g) {
        return ((Multimap)ServiceGroupTableSupplier.INSTANCE.get()).get((Object)g);
    }

    public static Collection<Class<? extends ComponentId>> listGroups() {
        return Collections2.filter(ComponentIds.listTypes(), Classes.subclassOf(ServiceGroup.class));
    }

    public static Collection<ServiceConfiguration> list(ServiceGroupConfiguration config) {
        ArrayList members = Lists.newArrayList();
        for (ComponentId compId : Collections2.filter(ComponentIds.list(), (Predicate)config.lookupServiceGroup())) {
            members.addAll(Collections2.filter(Components.lookup(compId).services(), config.filterMembers()));
        }
        return members;
    }

    static enum ServiceGroupTableSupplier implements Supplier<Multimap<ServiceGroup, ? extends ComponentId>>
    {
        INSTANCE{

            public Multimap<ServiceGroup, ? extends ComponentId> get() {
                return (Multimap)memo.get();
            }
        }
        ,
        REAL{

            public Multimap<ServiceGroup, ? extends ComponentId> get() {
                ArrayListMultimap map = ArrayListMultimap.create();
                for (Class<? extends ComponentId> g : ServiceGroups.listGroups()) {
                    ServiceGroup svc = (ServiceGroup)Classes.newInstance(g, new Object[0]);
                    map.putAll((Object)svc, svc.list());
                }
                return map;
            }
        };

        private static Supplier<Multimap<ServiceGroup, ? extends ComponentId>> memo;

        static {
            memo = Suppliers.memoize((Supplier)REAL);
        }
    }
}

