/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component.groups;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ServiceBuilders;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.groups.ServiceGroup;
import com.eucalyptus.component.groups.ServiceGroupConfiguration;
import com.eucalyptus.config.ComponentConfiguration;
import com.eucalyptus.empyrean.Empyrean;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import java.io.Serializable;

public abstract class BaseServiceGroupConfiguration
extends ComponentConfiguration
implements Serializable,
ServiceGroupConfiguration {
    protected BaseServiceGroupConfiguration() {
    }

    BaseServiceGroupConfiguration(String partition, String name, String hostName, String servicePath) {
        this(partition, name, hostName, 8773, servicePath);
    }

    BaseServiceGroupConfiguration(String partition, String name, String hostName, Integer port, String servicePath) {
        super(partition, name, hostName, port, servicePath);
    }

    @Override
    public final Predicate<? super ComponentId> filterComponentIds() {
        return this.lookupServiceGroup();
    }

    @Override
    public final Predicate<ServiceConfiguration> filterMembers() {
        return new Predicate<ServiceConfiguration>(){

            public boolean apply(ServiceConfiguration input) {
                return input.getPartition().equals(BaseServiceGroupConfiguration.this.getName());
            }
        };
    }

    protected BaseServiceGroupConfiguration(String groupName, String hostName) {
        this(groupName, groupName, hostName, 8773, Empyrean.INSTANCE.getServicePath(new String[0]));
    }

    @Override
    public ServiceGroup lookupServiceGroup() {
        return (ServiceGroup)super.lookupComponentId();
    }

    public ServiceConfiguration newInstance(ComponentId memberComponent) {
        return ServiceBuilders.lookup(memberComponent.getClass()).newInstance(this.getName(), Joiner.on((String)".").join((Object)this.getName(), (Object)memberComponent.name(), new Object[0]), this.getHostName(), this.getPort());
    }
}

