/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component.groups;

import com.eucalyptus.component.AbstractServiceBuilder;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceRegistrationException;
import com.eucalyptus.component.groups.BaseServiceGroupConfiguration;
import com.eucalyptus.component.groups.ServiceGroupBuilder;
import com.eucalyptus.component.groups.ServiceGroups;
import com.eucalyptus.config.ComponentConfiguration;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public abstract class BaseServiceGroupBuilder<T extends BaseServiceGroupConfiguration>
extends AbstractServiceBuilder<T>
implements ServiceGroupBuilder<T> {
    private static Logger LOG = Logger.getLogger(BaseServiceGroupBuilder.class);

    @Override
    public final boolean __MUST_EXTEND_BASE_SERVICE_BUILDER() {
        return true;
    }

    @Override
    public final ComponentId getComponentId() {
        return ((ComponentConfiguration)this.newInstance()).getComponentId();
    }

    @Override
    public final boolean checkAdd(String partition, String name, String host, Integer port) throws ServiceRegistrationException {
        return super.checkAdd(partition, name, host, port);
    }

    @Override
    public final boolean checkUpdate(String partition, String name, String host, Integer port) throws ServiceRegistrationException {
        return super.checkUpdate(partition, name, host, port);
    }

    @Override
    public final void fireLoad(ServiceConfiguration config) throws ServiceRegistrationException {
        LOG.debug((Object)("Loading " + config));
    }

    @Override
    public final void fireStart(ServiceConfiguration config) throws ServiceRegistrationException {
        LOG.debug((Object)("Starting " + config));
    }

    @Override
    public final void fireStop(ServiceConfiguration config) throws ServiceRegistrationException {
        LOG.debug((Object)("Stopping " + config));
    }

    @Override
    public final void fireEnable(ServiceConfiguration config) throws ServiceRegistrationException {
        LOG.debug((Object)("Enabling " + config));
    }

    @Override
    public final void fireDisable(ServiceConfiguration config) throws ServiceRegistrationException {
        LOG.debug((Object)("Disabling " + config));
    }

    @Override
    public final void fireCheck(ServiceConfiguration config) throws ServiceRegistrationException, Faults.CheckException {
        LOG.trace((Object)("Checking " + config));
    }

    @Override
    public abstract T newInstance(String var1, String var2, String var3, Integer var4);

    @Override
    public abstract T newInstance();

    @Override
    public Collection<ServiceConfiguration> onDeregister(T config) {
        return ServiceGroups.list(config);
    }

    @Override
    public Collection<ServiceConfiguration> onRegister(T config) {
        ArrayList members = Lists.newArrayList();
        for (ComponentId compId : Collections2.filter(ComponentIds.list(), ((BaseServiceGroupConfiguration)config).filterComponentIds())) {
            members.add(((BaseServiceGroupConfiguration)config).newInstance(compId));
        }
        return members;
    }

    @Override
    public Collection<ServiceConfiguration> onUpdate(T config) {
        return ServiceGroups.list(config);
    }

    @Override
    public Collection<ServiceConfiguration> onEnabled(T config) {
        return ServiceGroups.list(config);
    }

    @Override
    public Collection<ServiceConfiguration> onDisabled(T config) {
        return ServiceGroups.list(config);
    }

    @Override
    public Collection<ServiceConfiguration> onNotready(T config) {
        return ServiceGroups.list(config);
    }

    @Override
    public Collection<ServiceConfiguration> onStarted(T config) {
        return ServiceGroups.list(config);
    }

    @Override
    public Collection<ServiceConfiguration> onStopped(T config) {
        return ServiceGroups.list(config);
    }
}

