/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component.groups;

import com.eucalyptus.bootstrap.Handles;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.component.annotation.Description;
import com.eucalyptus.component.annotation.FaultLogPrefix;
import com.eucalyptus.component.annotation.Partition;
import com.eucalyptus.component.annotation.PublicService;
import com.eucalyptus.component.groups.BaseServiceGroupBuilder;
import com.eucalyptus.component.groups.BaseServiceGroupConfiguration;
import com.eucalyptus.component.groups.ServiceGroup;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.techpreview.TechPreviews;
import java.io.Serializable;
import javax.annotation.Nullable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@FaultLogPrefix(value="cloud")
@Partition(value={ApiEndpointServicesGroup.class}, manyToOne=true)
@Description(value="The service group of all user-facing API endpoint services")
public class ApiEndpointServicesGroup
extends ServiceGroup {
    private static Logger LOG = Logger.getLogger(ApiEndpointServicesGroup.class);

    public ApiEndpointServicesGroup() {
        super("User-API");
    }

    @Override
    public boolean apply(@Nullable ComponentId componentId) {
        return componentId != null && Ats.from(componentId).has(PublicService.class) && componentId.isRegisterable() && !TechPreviews.isTechPreview(componentId);
    }

    @ComponentPart(value=ApiEndpointServicesGroup.class)
    @Handles(value={})
    public static class ApiEndpointServiceBuilder
    extends BaseServiceGroupBuilder<ApiEndpointGroup> {
        @Override
        public ApiEndpointGroup newInstance(String partition, String name, String host, Integer port) {
            return new ApiEndpointGroup(name, host);
        }

        @Override
        public ApiEndpointGroup newInstance() {
            return new ApiEndpointGroup();
        }
    }

    @Entity
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    @PersistenceContext(name="eucalyptus_config")
    @ComponentPart(value=ApiEndpointServicesGroup.class)
    @DiscriminatorValue(value="ApiEndpointGroup")
    public static class ApiEndpointGroup
    extends BaseServiceGroupConfiguration
    implements Serializable {
        public ApiEndpointGroup(String groupName, String hostName) {
            super(groupName, hostName);
        }

        public ApiEndpointGroup() {
        }
    }
}

