/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component.fault;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.fault.FaultLogger;
import com.eucalyptus.component.fault.FaultRegistry;
import com.eucalyptus.system.BaseDirectory;
import com.eucalyptus.system.SubDirectory;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;

public class FaultSubsystemManager {
    private static final Logger LOG = Logger.getLogger(FaultSubsystemManager.class);
    private Map<String, FaultLogger> loggerMap = new ConcurrentHashMap<String, FaultLogger>();
    private FaultRegistry faultRegistry = new FaultRegistry();
    private static final String DEFAULT_LOCALE = "en_US";

    public FaultSubsystemManager() {
        String locale = System.getenv("LOCALE");
        this.faultRegistry.crawlDirectory(SubDirectory.SYSFAULTS.getChildFile(DEFAULT_LOCALE));
        if (locale != null && !locale.equals(DEFAULT_LOCALE)) {
            this.faultRegistry.crawlDirectory(SubDirectory.SYSFAULTS.getChildFile(locale));
        }
        this.faultRegistry.crawlDirectory(SubDirectory.CUSTOMFAULTS.getChildFile(DEFAULT_LOCALE));
        if (locale != null && !locale.equals(DEFAULT_LOCALE)) {
            this.faultRegistry.crawlDirectory(SubDirectory.CUSTOMFAULTS.getChildFile(locale));
        }
    }

    public synchronized FaultLogger getFaultLogger(Class<? extends ComponentId> componentIdClass) {
        if (componentIdClass == null) {
            throw new IllegalArgumentException("componentIdClass is null");
        }
        ComponentId componentId = ComponentIds.lookup(componentIdClass);
        if (componentId == null) {
            throw new IllegalArgumentException("componentId is null");
        }
        String faultLogPrefix = componentId.getFaultLogPrefix();
        FaultLogger logger = this.loggerMap.get(faultLogPrefix);
        if (logger == null) {
            logger = this.initLogger(faultLogPrefix);
            this.loggerMap.put(faultLogPrefix, logger);
        }
        return logger;
    }

    private FaultLogger initLogger(String faultLogPrefix) {
        String targetLoggerName = "com.eucalyptus.troubleshooting.fault." + faultLogPrefix + ".log";
        String targetAppenderName = faultLogPrefix + "-fault-log";
        String targetLogFileName = faultLogPrefix + "-fault.log";
        LOG.debug((Object)("looking for logger " + targetLoggerName));
        Logger logger = null;
        Enumeration logEnum = LogManager.getCurrentLoggers();
        while (logEnum.hasMoreElements()) {
            Logger currentLogger = (Logger)logEnum.nextElement();
            if (logger != null || !currentLogger.getName().equals(targetLoggerName)) continue;
            logger = currentLogger;
            LOG.debug((Object)("Found logger " + targetLoggerName));
            break;
        }
        if (logger == null) {
            LOG.debug((Object)("Didn't find logger " + targetLoggerName + ", creating it now"));
            logger = Logger.getLogger((String)targetLoggerName);
            logger.setAdditivity(false);
            logger.setLevel(Level.FATAL);
        }
        LOG.debug((Object)("Checking root logger for appender " + targetAppenderName));
        Appender appender = this.checkAppender(LogManager.getRootLogger(), targetAppenderName);
        if (appender == null) {
            logEnum = LogManager.getCurrentLoggers();
            while (logEnum.hasMoreElements() && appender == null) {
                Logger currentLogger = (Logger)logEnum.nextElement();
                LOG.debug((Object)("Checking " + currentLogger.getName() + " for appender " + targetAppenderName));
                appender = this.checkAppender(currentLogger, targetAppenderName);
            }
        }
        if (appender == null) {
            RollingFileAppender rAppender = new RollingFileAppender();
            rAppender.setFile(BaseDirectory.LOG.getChildFile(targetLogFileName).toString());
            rAppender.setMaxFileSize("10MB");
            rAppender.setMaxBackupIndex(10);
            rAppender.setLayout((Layout)new PatternLayout("%m%n"));
            rAppender.setThreshold((Priority)Level.FATAL);
            rAppender.activateOptions();
            rAppender.setName(targetAppenderName);
            appender = rAppender;
        }
        if (this.checkAppender(logger, targetAppenderName) == null) {
            logger.addAppender(appender);
        }
        FaultLogger faultLogger = new FaultLogger(logger);
        return faultLogger;
    }

    private Appender checkAppender(Logger logger, String targetAppenderName) {
        if (logger == null) {
            return null;
        }
        Enumeration appenderEnum = logger.getAllAppenders();
        while (appenderEnum.hasMoreElements()) {
            Appender currentAppender = (Appender)appenderEnum.nextElement();
            if (currentAppender.getName() == null || !currentAppender.getName().equals(targetAppenderName)) continue;
            return currentAppender;
        }
        return null;
    }

    public FaultRegistry getFaultRegistry() {
        return this.faultRegistry;
    }

    public void init() {
        for (ComponentId componentId : ComponentIds.list()) {
            this.getFaultLogger(componentId.getClass());
        }
    }
}

