/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component.fault;

import com.eucalyptus.component.fault.Common;
import com.eucalyptus.component.fault.Fault;
import com.eucalyptus.component.fault.FaultField;
import com.eucalyptus.component.fault.FaultFieldName;
import com.eucalyptus.component.fault.FaultMessage;
import com.eucalyptus.util.XMLParser;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FaultRegistry {
    private static final Logger LOG = Logger.getLogger(FaultRegistry.class);
    private static final String EUCAFAULTS = "eucafaults";
    private static final String COMMON = "common";
    private static final String VAR = "var";
    private static final String FAULT = "fault";
    private static final String ID = "id";
    private static final String VERSION = "version";
    private static final String DESCRIPTION = "description";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String LOCALIZED = "localized";
    private static final String MESSAGE = "message";
    private static final String XML_SUFFIX = ".xml";
    private static final String COMMON_XML = "common.xml";
    public static final Fault SUPPRESSED_FAULT = new Fault();
    private Set<Integer> suppressedFaults;
    private Map<String, Common> commonMap = new HashMap<String, Common>();
    private Map<Integer, Fault> faultMap = new HashMap<Integer, Fault>();

    public FaultRegistry() {
        this.suppressedFaults = new HashSet<Integer>();
    }

    void crawlDirectory(File rootDir) {
        LOG.debug((Object)("Crawling fault directory " + rootDir));
        if (rootDir != null && rootDir.isDirectory()) {
            File commonXMLFile = new File(rootDir, COMMON_XML);
            this.parseCommonXMLFile(commonXMLFile, this.commonMap);
            File[] faultFiles = rootDir.listFiles(new FaultFileFilter());
            if (faultFiles != null) {
                for (File faultFile : faultFiles) {
                    this.parseFaultXMLFile(faultFile, this.faultMap, this.commonMap, this.suppressedFaults);
                }
            }
        } else {
            LOG.warn((Object)(rootDir + " either does not exist or is not a directory, skipping."));
        }
    }

    private void parseCommonXMLFile(File commonXMLFile, Map<String, Common> commonMap) {
        try {
            LOG.warn((Object)("Parsing common file " + commonXMLFile));
            DocumentBuilder dBuilder = XMLParser.getDocBuilder();
            if (dBuilder != null) {
                Document doc = dBuilder.parse(commonXMLFile);
                Element docElement = doc.getDocumentElement();
                docElement.normalize();
                if (!EUCAFAULTS.equalsIgnoreCase(docElement.getTagName())) {
                    LOG.warn((Object)("File " + commonXMLFile + " contains the wrong outer XML tag, will not be parsed."));
                } else {
                    NodeList children = docElement.getChildNodes();
                    int length = children.getLength();
                    for (int i = 0; i < length; ++i) {
                        Element currentElement;
                        Node currentNode = children.item(i);
                        if (currentNode.getNodeType() != 1 || !COMMON.equalsIgnoreCase((currentElement = (Element)currentNode).getTagName())) continue;
                        this.parseCommonElement(currentElement, commonMap);
                    }
                }
                LOG.debug((Object)("Successfully parsed " + commonXMLFile));
            }
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            LOG.error((Object)ex);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            LOG.error((Object)ex);
        }
    }

    private void parseFaultXMLFile(File faultXMLFile, Map<Integer, Fault> faultMap, Map<String, Common> commonMap, Set<Integer> suppressedFaults) {
        try {
            LOG.debug((Object)("Parsing fault file " + faultXMLFile));
            int faultId = this.parseIdFromFileName(faultXMLFile.getName());
            if (suppressedFaults.contains(faultId) && faultXMLFile.length() != 0L) {
                LOG.debug((Object)("Unsupressing fault " + faultId));
                suppressedFaults.remove(faultId);
            } else if (faultXMLFile.exists() && faultXMLFile.length() == 0L) {
                LOG.debug((Object)("Supressing fault " + faultId));
                faultMap.remove(faultId);
                suppressedFaults.add(faultId);
                return;
            }
            DocumentBuilder dBuilder = XMLParser.getDocBuilder();
            Document doc = dBuilder.parse(faultXMLFile);
            Element docElement = doc.getDocumentElement();
            docElement.normalize();
            if (!EUCAFAULTS.equalsIgnoreCase(docElement.getTagName())) {
                LOG.warn((Object)("File " + faultXMLFile + " contains the wrong outer XML tag, will not be parsed."));
            } else {
                commonMap.clear();
                NodeList children = docElement.getChildNodes();
                int length = children.getLength();
                for (int i = 0; i < length; ++i) {
                    Element currentElement;
                    Node currentNode = children.item(i);
                    if (currentNode.getNodeType() != 1 || !FAULT.equalsIgnoreCase((currentElement = (Element)currentNode).getTagName())) continue;
                    Fault fault = this.parseFaultElement(currentElement, commonMap);
                    if (fault.getId() != faultId) {
                        LOG.warn((Object)("Fault " + fault.getId() + " found in file " + faultXMLFile + ", in the wrong file.  Will not be processed"));
                        continue;
                    }
                    LOG.debug((Object)("Successfully parsed " + faultXMLFile + " and read in fault " + fault.getId()));
                    faultMap.put(fault.getId(), fault);
                }
            }
        }
        catch (SAXException ex) {
            LOG.error((Object)ex);
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
        }
    }

    private Fault parseFaultElement(Element element, Map<String, Common> commonMap2) {
        if (element == null) {
            return null;
        }
        Fault fault = new Fault();
        fault.setId(-1);
        try {
            fault.setId(Integer.parseInt(this.getAttribute(element, ID)));
        }
        catch (Exception ex) {
            LOG.warn((Object)"Illegal ID passed in, will use -1");
        }
        fault.setCommonMap(this.commonMap);
        FaultMessage message = new FaultMessage();
        fault.setMessage(message);
        message.setMessage(this.getAttribute(element, MESSAGE));
        message.setLocalized(this.getAttribute(element, LOCALIZED));
        fault.setFaultFieldMap(new HashMap<FaultFieldName, FaultField>());
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node currentNode = children.item(i);
            if (currentNode.getNodeType() != 1) continue;
            Element currentElement = (Element)currentNode;
            FaultFieldName name = null;
            try {
                name = FaultFieldName.valueOf(currentElement.getTagName());
            }
            catch (Exception ex) {
                continue;
            }
            FaultField faultField = new FaultField();
            faultField.setName(name);
            faultField.setLocalizedAttribute(this.getAttribute(currentElement, LOCALIZED));
            faultField.setMessageAttribute(this.getAttribute(currentElement, MESSAGE));
            faultField.setLocalizedElement(this.getTextElement(currentElement, LOCALIZED));
            faultField.setMessageElement(this.getTextElement(currentElement, MESSAGE));
            fault.getFaultFieldMap().put(faultField.getName(), faultField);
        }
        return fault;
    }

    private String getTextElement(Element element, String subElementName) {
        if (element == null || subElementName == null) {
            return null;
        }
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Element currentElement;
            Node currentNode = children.item(i);
            if (currentNode.getNodeType() != 1 || !subElementName.equalsIgnoreCase((currentElement = (Element)currentNode).getTagName())) continue;
            try {
                return currentElement.getChildNodes().item(0).getNodeValue();
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    private int parseIdFromFileName(String name) {
        try {
            return Integer.parseInt(name.substring(0, name.length() - XML_SUFFIX.length()));
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private void parseCommonElement(Element element, Map<String, Common> commonMap) {
        if (element == null) {
            return;
        }
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Element currentElement;
            Node currentNode = children.item(i);
            if (currentNode.getNodeType() != 1 || !VAR.equalsIgnoreCase((currentElement = (Element)currentNode).getTagName())) continue;
            Common common = new Common();
            common.setName(this.getAttribute(currentElement, NAME));
            common.setValue(this.getAttribute(currentElement, VALUE));
            common.setLocalized(this.getAttribute(currentElement, LOCALIZED));
            if (common.getName() == null) continue;
            commonMap.put(common.getName(), common);
        }
    }

    private String getAttribute(Element element, String attributeName) {
        if (element == null) {
            return null;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        Node localizedNode = namedNodeMap.getNamedItem(attributeName);
        if (localizedNode == null) {
            return null;
        }
        return localizedNode.getNodeValue();
    }

    public Fault lookupFault(int id) {
        if (this.suppressedFaults.contains(id)) {
            return SUPPRESSED_FAULT;
        }
        Fault fault = this.faultMap.get(id);
        if (fault == null) {
            return fault;
        }
        return (Fault)fault.clone();
    }

    public class FaultFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File f) {
            if (f != null && f.isFile() && f.getName().toLowerCase().endsWith(FaultRegistry.XML_SUFFIX)) {
                String name = f.getName().toLowerCase();
                String prefix = name.substring(0, name.length() - FaultRegistry.XML_SUFFIX.length());
                try {
                    return Integer.parseInt(prefix) > 0;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

