/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component.fault;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.fault.Fault;
import com.eucalyptus.component.fault.FaultLogger;
import com.eucalyptus.component.fault.FaultRegistry;
import com.eucalyptus.component.fault.FaultSubsystemManager;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class FaultBuilderImpl
implements Faults.FaultBuilder {
    private static final Logger LOG = Logger.getLogger(Faults.FaultBuilder.class);
    private FaultSubsystemManager faultSubsystemManager;
    private Class<? extends ComponentId> componentIdClass;
    private ArrayList<NameValuePair> vars = new ArrayList();
    private int faultId;

    public FaultBuilderImpl(FaultSubsystemManager faultSubsystemManager, Class<? extends ComponentId> componentIdClass) {
        this.faultSubsystemManager = faultSubsystemManager;
        this.componentIdClass = componentIdClass;
    }

    @Override
    public Faults.FaultBuilder withVar(String name, String value) {
        this.vars.add(new NameValuePair(name, value));
        return this;
    }

    @Override
    public Faults.FaultBuilder havingId(int faultId) {
        this.faultId = faultId;
        return this;
    }

    @Override
    public String log() {
        String faultMessage = "";
        try {
            FaultLogger faultLogger = this.faultSubsystemManager.getFaultLogger(this.componentIdClass);
            Fault fault = this.faultSubsystemManager.getFaultRegistry().lookupFault(this.faultId);
            if (fault == FaultRegistry.SUPPRESSED_FAULT) {
                faultMessage = "Fault " + this.faultId + " detected, will not be logged because it has been configured to be suppressed.";
                LOG.debug((Object)faultMessage);
            } else if (fault == null) {
                faultMessage = "Fault " + this.faultId + " detected, could not find fault id in registry.";
                LOG.error((Object)faultMessage);
            } else {
                for (NameValuePair nameValuePair : this.vars) {
                    fault = fault.withVar(nameValuePair.getName(), nameValuePair.getValue());
                }
                faultLogger.log(fault);
                faultMessage = fault.toString();
            }
        }
        catch (Exception ex) {
            faultMessage = "Error writing fault with id " + this.faultId + "  for component " + this.componentIdClass.getName();
            LOG.error((Object)faultMessage);
            ex.printStackTrace();
        }
        return faultMessage;
    }

    @Override
    public Callable<String> logOnFirstRun() {
        return new Callable<String>(){
            private final AtomicBoolean logged = new AtomicBoolean(false);
            private String faultMessage;

            @Override
            public String call() {
                if (this.logged.compareAndSet(false, true)) {
                    this.faultMessage = FaultBuilderImpl.this.log();
                }
                return this.faultMessage;
            }
        };
    }

    private class NameValuePair {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public NameValuePair(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

