/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component.fault;

import com.eucalyptus.component.fault.Common;
import com.eucalyptus.component.fault.EffectiveValue;
import com.eucalyptus.component.fault.FaultField;
import com.eucalyptus.component.fault.FaultFieldName;
import com.eucalyptus.component.fault.FaultMessage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;

public class Fault
implements Cloneable {
    private int id;
    private FaultMessage message;
    private Map<String, Common> commonMap;
    private Map<FaultFieldName, FaultField> faultFieldMap;
    private String stringRepresentation;
    private static final String INNER_FAULT_PREFIX = "  ";
    private static final String UNKNOWN = "unknown";

    public synchronized Fault withVar(String key, String value) {
        this.toString();
        String realKey = "${" + key + "}";
        this.stringRepresentation = this.stringRepresentation.replace(realKey, value);
        return this;
    }

    public synchronized String toString() {
        String nameStr;
        if (this.stringRepresentation != null) {
            return this.stringRepresentation;
        }
        StringWriter sWriter = new StringWriter();
        PrintWriter out = new PrintWriter(sWriter);
        String lineOfAsterisks = this.stringFill(72, '*');
        out.println(lineOfAsterisks);
        out.println(INNER_FAULT_PREFIX + this.headerLine());
        out.println();
        int fieldWidth = 0;
        for (FaultFieldName name : FaultFieldName.values()) {
            nameStr = name.toString();
            if (this.commonMap.get(nameStr) != null && this.commonMap.get(nameStr).getEffectiveValue() != null) {
                nameStr = this.commonMap.get(nameStr).getEffectiveValue();
            }
            fieldWidth = Math.max(fieldWidth, nameStr.length());
        }
        for (FaultFieldName name : FaultFieldName.values()) {
            nameStr = name.toString();
            if (this.commonMap.get(nameStr) != null && this.commonMap.get(nameStr).getEffectiveValue() != null) {
                nameStr = this.commonMap.get(nameStr).getEffectiveValue();
            }
            FaultField faultField = this.faultFieldMap.get((Object)name);
            String faultFieldValue = this.getEffectiveValueOrUnknown(faultField);
            out.println(INNER_FAULT_PREFIX + this.lpad(nameStr, fieldWidth) + ": " + faultFieldValue);
        }
        out.println(lineOfAsterisks);
        out.close();
        this.stringRepresentation = sWriter.toString();
        return this.stringRepresentation;
    }

    private String lpad(String s, int fieldWidth) {
        String paddedStringTotal = this.stringFill(fieldWidth, ' ') + s;
        return paddedStringTotal.substring(paddedStringTotal.length() - fieldWidth);
    }

    private String getEffectiveValueOrUnknown(EffectiveValue effectiveValue) {
        Common unknownCommon = this.commonMap.get(UNKNOWN);
        String localizedUnknown = UNKNOWN;
        if (unknownCommon != null && unknownCommon.getEffectiveValue() != null) {
            localizedUnknown = unknownCommon.getEffectiveValue();
        }
        if (effectiveValue != null && effectiveValue.getEffectiveValue() != null) {
            return effectiveValue.getEffectiveValue();
        }
        return localizedUnknown;
    }

    private String headerLine() {
        DecimalFormat df = new DecimalFormat("0000");
        StringBuilder builder = new StringBuilder();
        builder.append("ERR-" + df.format(this.id));
        builder.append(" ");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        builder.append(sdf.format(new Date()));
        builder.append(" ");
        builder.append(this.getEffectiveValueOrUnknown(this.message));
        return builder.toString();
    }

    private String stringFill(int length, char c) {
        char[] buff = new char[length];
        Arrays.fill(buff, c);
        return new String(buff);
    }

    FaultMessage getMessage() {
        return this.message;
    }

    void setMessage(FaultMessage message) {
        this.message = message;
    }

    Map<FaultFieldName, FaultField> getFaultFieldMap() {
        return this.faultFieldMap;
    }

    void setFaultFieldMap(Map<FaultFieldName, FaultField> faultFieldMap) {
        this.faultFieldMap = faultFieldMap;
    }

    protected Object clone() {
        Fault clone = new Fault();
        clone.id = this.id;
        clone.faultFieldMap = this.faultFieldMap;
        clone.commonMap = this.commonMap;
        clone.message = this.message;
        return clone;
    }

    int getId() {
        return this.id;
    }

    void setId(int id) {
        this.id = id;
    }

    Map<String, Common> getCommonMap() {
        return this.commonMap;
    }

    void setCommonMap(Map<String, Common> commonMap) {
        this.commonMap = commonMap;
    }
}

