/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component.events;

import com.eucalyptus.bootstrap.Host;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentRegistrationHandler;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.Topology;
import com.eucalyptus.empyrean.DisableServiceType;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.empyrean.EnableServiceType;
import com.eucalyptus.empyrean.ServiceId;
import com.eucalyptus.empyrean.ServiceTransitionType;
import com.eucalyptus.empyrean.StartServiceType;
import com.eucalyptus.empyrean.StopServiceType;
import com.eucalyptus.event.Event;
import com.eucalyptus.event.EventFailedException;
import com.eucalyptus.event.ListenerRegistry;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.TypeMappers;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.Futures;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class ServiceEvents {
    private static Logger LOG = Logger.getLogger(ServiceEvents.class);

    public static void fire(ServiceConfiguration config, Component.State state) {
        try {
            ServiceTransitionType msg = null;
            switch (state) {
                case ENABLED: {
                    msg = new EnableServiceType();
                    break;
                }
                case DISABLED: {
                    msg = new DisableServiceType();
                    break;
                }
                case STOPPED: {
                    msg = new StopServiceType();
                    break;
                }
                case NOTREADY: {
                    msg = new StartServiceType();
                    break;
                }
            }
            if (msg != null) {
                msg.getServices().add(TypeMappers.transform(config, ServiceId.class));
                for (Host h : Hosts.list()) {
                    if (h.isLocalHost() || h.getHostAddresses().contains((Object)config.getInetAddress())) continue;
                    try {
                        AsyncRequests.sendSync(ServiceConfigurations.createEphemeral(Empyrean.INSTANCE, h.getBindAddress()), msg);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    public static RegistrationBuilder forConfiguration(final ServiceConfiguration configuration) {
        return new RegistrationBuilder(){
            {
                this.config = configuration;
            }
        };
    }

    public static Function<? super ServiceConfiguration, Future<ServiceConfiguration>> deregisterFunction() {
        return DeregisterFunction.INSTANCE;
    }

    public static Function<? super ServiceConfiguration, Future<ServiceConfiguration>> registerFunction() {
        return RegisterFunction.INSTANCE;
    }

    public static class DeregistrationEvent
    extends ServiceEvent {
    }

    public static class UpdateRegistrationEvent
    extends ServiceEvent {
    }

    public static class RegistrationEvent
    extends ServiceEvent {
    }

    public static class StoppedEvent
    extends ServiceEvent {
    }

    public static class StartedEvent
    extends ServiceEvent {
    }

    public static class NotreadyEvent
    extends ServiceEvent {
    }

    public static class DisabledEvent
    extends ServiceEvent {
    }

    public static class EnabledEvent
    extends ServiceEvent {
    }

    public static class ServiceEvent
    implements Event {
        private ServiceConfiguration configuration;

        public ServiceConfiguration getConfiguration() {
            return this.configuration;
        }

        public <T extends ServiceEvent> T setConfiguration(ServiceConfiguration configuration) {
            this.configuration = configuration;
            return (T)this;
        }
    }

    public static class RegistrationBuilder {
        ServiceConfiguration config;

        public Future<ServiceConfiguration> register() {
            LOG.debug((Object)("Registering: " + this.config));
            try {
                ServiceConfiguration resultConfig = ComponentRegistrationHandler.register(this.config.getComponentId(), this.config.getPartition(), this.config.getName(), this.config.getHostName(), this.config.getPort());
                if (resultConfig != null) {
                    Object event = new RegistrationEvent().setConfiguration(resultConfig);
                    try {
                        ListenerRegistry.getInstance().fireEvent((Event)event);
                    }
                    catch (EventFailedException e) {
                        LOG.trace((Object)e);
                    }
                    return Futures.predestinedFuture(resultConfig);
                }
                return Futures.predestinedFuture(this.config);
            }
            catch (Exception e) {
                String errorMessage = Joiner.on((String)" ").join((Object)"Registering ", (Object)this.config.getFullName(), new Object[]{" failed because of ", e.getMessage()});
                LOG.debug((Object)errorMessage);
                LOG.trace((Object)e, (Throwable)e);
                return Futures.predestinedFailedFuture(Exceptions.toUndeclared((String)errorMessage, (Throwable[])new Throwable[0]));
            }
        }

        public Future<ServiceConfiguration> deregister() {
            LOG.debug((Object)("Deregistering: " + this.config));
            try {
                ServiceConfiguration resultConfig = ComponentRegistrationHandler.deregister(this.config.getComponentId(), this.config.getName());
                if (resultConfig != null) {
                    DeregistrationEvent event = (DeregistrationEvent)new DeregistrationEvent().setConfiguration(resultConfig);
                    try {
                        ListenerRegistry.getInstance().fireEvent(event);
                    }
                    catch (EventFailedException e) {
                        LOG.trace((Object)e);
                    }
                    try {
                        Topology.destroy(resultConfig).get();
                    }
                    catch (Exception e) {
                        LOG.error((Object)e);
                    }
                    return Futures.predestinedFuture(resultConfig);
                }
                return Futures.predestinedFuture(this.config);
            }
            catch (Exception e) {
                String errorMessage = Joiner.on((String)" ").join((Object)"Deregistering ", (Object)this.config.getFullName(), new Object[]{" failed because of ", e.getMessage()});
                LOG.debug((Object)errorMessage);
                LOG.trace((Object)e, (Throwable)e);
                return Futures.predestinedFailedFuture(Exceptions.toUndeclared((String)errorMessage, (Throwable[])new Throwable[0]));
            }
        }
    }

    public static enum RegisterFunction implements Function<ServiceConfiguration, Future<ServiceConfiguration>>
    {
        INSTANCE;


        public Future<ServiceConfiguration> apply(ServiceConfiguration input) {
            return ServiceEvents.forConfiguration(input).register();
        }
    }

    public static enum DeregisterFunction implements Function<ServiceConfiguration, Future<ServiceConfiguration>>
    {
        INSTANCE;


        public Future<ServiceConfiguration> apply(ServiceConfiguration input) {
            return ServiceEvents.forConfiguration(input).deregister();
        }
    }
}

