/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component.auth;

import com.eucalyptus.auth.util.X509CertHelper;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.DependsLocal;
import com.eucalyptus.bootstrap.DependsRemote;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.NoSuchComponentException;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.component.id.HttpService;
import com.eucalyptus.crypto.Certs;
import com.eucalyptus.crypto.KeyStore;
import com.eucalyptus.crypto.util.AbstractKeyStore;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.crypto.util.PEMFiles;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.system.SubDirectory;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;

public class SystemCredentials {
    private static Logger LOG = Logger.getLogger(SystemCredentials.class);
    private static ConcurrentMap<String, Credentials> providers = new ConcurrentHashMap<String, Credentials>();

    public static <T extends ComponentId> Credentials lookup(ComponentId compId) {
        if (providers.containsKey(compId.name())) {
            return (Credentials)providers.get(compId.name());
        }
        try {
            return new Credentials(compId);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            throw new RuntimeException("Failed to lookup system credentials for: " + compId + " because: " + ex.getMessage(), ex);
        }
    }

    public static <T extends ComponentId> Credentials lookup(Class<T> compId) {
        return SystemCredentials.lookup(ComponentIds.lookup(compId));
    }

    static boolean checkKeystore(ComponentId name) throws Exception {
        return EucaKeyStore.getCleanInstance().containsEntry(name.name());
    }

    static boolean check(Class<? extends ComponentId> compIdType) {
        return SystemCredentials.check(ComponentIds.lookup(compIdType));
    }

    static boolean check(ComponentId compId) {
        if (!compId.hasCredentials().booleanValue()) {
            return true;
        }
        return EucaKeyStore.getInstance().containsEntry(compId.name());
    }

    private static Credentials create(ComponentId compId) throws Exception {
        if (!SystemCredentials.check(compId)) {
            KeyPair sysKp = Certs.generateKeyPair();
            X509Certificate sysX509 = Certs.generateServiceCertificate(sysKp, compId.name());
            if (ComponentIds.lookup(Eucalyptus.class).name().equals(compId.name())) {
                PEMFiles.write(SubDirectory.KEYS.toString() + "/cloud-cert.pem", sysX509);
                PEMFiles.write(SubDirectory.KEYS.toString() + "/cloud-pk.pem", sysKp.getPrivate());
            }
            EucaKeyStore.getInstance().addKeyPair(compId.name(), sysX509, sysKp.getPrivate(), compId.name());
            EucaKeyStore.getInstance().store();
        }
        return new Credentials(compId);
    }

    private static boolean checkAllKeys() {
        for (ComponentId c : ComponentIds.list()) {
            if (!c.hasCredentials().booleanValue()) continue;
            try {
                if (EucaKeyStore.getCleanInstance().containsEntry(c.name())) continue;
                LOG.error((Object)("Failed to lookup key for " + c.getCapitalizedName() + " with alias=" + c.name() + " in file " + EucaKeyStore.getInstance().getFileName()));
                return false;
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static boolean initialize() {
        try {
            if (!SystemCredentials.check(Eucalyptus.class)) {
                SystemCredentials.create(Eucalyptus.INSTANCE);
            }
            for (ComponentId c : ComponentIds.list()) {
                if (SystemCredentials.check(c)) continue;
                SystemCredentials.create(c);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            return false;
        }
        return true;
    }

    public static final KeyStore getKeyStore() {
        return EucaKeyStore.getInstance();
    }

    private static final class EucaKeyStore
    extends AbstractKeyStore {
        public static String FORMAT = "pkcs12";
        private static String KEY_STORE_PASS = "eucalyptus";
        private static String FILENAME = "euca.p12";
        private static KeyStore singleton = EucaKeyStore.getInstance();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static KeyStore getInstance() {
            Class<EucaKeyStore> clazz = EucaKeyStore.class;
            synchronized (EucaKeyStore.class) {
                if (singleton == null) {
                    try {
                        singleton = new EucaKeyStore();
                    }
                    catch (Exception e) {
                        LOG.error((Object)e, (Throwable)e);
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return singleton;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static KeyStore getCleanInstance() throws Exception {
            Class<EucaKeyStore> clazz = EucaKeyStore.class;
            synchronized (EucaKeyStore.class) {
                singleton = new EucaKeyStore();
                // ** MonitorExit[var0] (shouldn't be in output)
                return singleton;
            }
        }

        private EucaKeyStore() throws GeneralSecurityException, IOException {
            super(SubDirectory.KEYS.toString() + File.separator + FILENAME, KEY_STORE_PASS, FORMAT);
        }

        @Override
        public boolean check() throws GeneralSecurityException {
            return this.getCertificate(ComponentIds.lookup(HttpService.class).name()) != null && this.getCertificate(ComponentIds.lookup(Eucalyptus.class).name()) != null;
        }

        @Override
        public final KeyPair getKeyPair(String alias, String password) throws GeneralSecurityException {
            KeyPair keyPair = super.getKeyPair(alias, password);
            RestrictSize.INSTANCE.apply(keyPair.getPrivate());
            RestrictSize.INSTANCE.apply(keyPair.getPublic());
            return keyPair;
        }

        @Override
        public final X509Certificate getCertificate(String alias) throws GeneralSecurityException {
            X509Certificate certificate = super.getCertificate(alias);
            RestrictSize.INSTANCE.apply(certificate.getPublicKey());
            return certificate;
        }

        @Override
        public final Key getKey(String alias, String password) throws GeneralSecurityException {
            Key key = super.getKey(alias, password);
            RestrictSize.INSTANCE.apply(key);
            return key;
        }

        @Override
        public final void addCertificate(String alias, X509Certificate cert) throws IOException, GeneralSecurityException {
            RestrictSize.INSTANCE.apply(cert.getPublicKey());
            super.addCertificate(alias, cert);
        }

        @Override
        public final void addKeyPair(String alias, X509Certificate cert, PrivateKey privateKey, String keyPassword) throws IOException, GeneralSecurityException {
            RestrictSize.INSTANCE.apply(cert.getPublicKey());
            RestrictSize.INSTANCE.apply(privateKey);
            super.addKeyPair(alias, cert, privateKey, keyPassword);
        }

        private static enum RestrictSize implements Predicate<Key>
        {
            INSTANCE;

            private static final int MAX_SIZE = 4096;

            public boolean apply(Key arg0) {
                RSAKey key = (RSAKey)((Object)arg0);
                if (key.getModulus().bitLength() > 4096) {
                    SecurityException ex = new SecurityException("Illegal key size: " + key.getModulus().bitLength() + " > " + 4096 + " (max key size)");
                    LOG.trace((Object)ex, (Throwable)ex);
                    throw ex;
                }
                return true;
            }
        }
    }

    @Provides(value=Empyrean.class)
    @RunDuring(value=Bootstrap.Stage.SystemCredentialsInit)
    @DependsRemote(value={Eucalyptus.class})
    public static class RemoteComponentCredentialBootstrapper
    extends Bootstrapper.Simple {
        @Override
        public boolean load() throws Exception {
            while (!SystemCredentials.checkAllKeys()) {
                LOG.fatal((Object)"Waiting for system credentials before proceeding with startup...");
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            for (ComponentId c : ComponentIds.list()) {
                if (!c.hasCredentials().booleanValue()) continue;
                LOG.info((Object)("Initializing system credentials for " + c.name()));
                SystemCredentials.lookup(c);
            }
            return true;
        }
    }

    @Provides(value=Empyrean.class)
    @RunDuring(value=Bootstrap.Stage.SystemCredentialsInit)
    @DependsLocal(value={Eucalyptus.class})
    public static class SystemCredentialBootstrapper
    extends Bootstrapper.Simple {
        @Override
        public boolean load() throws Exception {
            try {
                if (!SystemCredentials.check(Eucalyptus.class)) {
                    SystemCredentials.lookup(Eucalyptus.INSTANCE);
                }
                for (ComponentId c : ComponentIds.list()) {
                    if (SystemCredentials.check(c)) continue;
                    try {
                        SystemCredentials.lookup(c);
                    }
                    catch (Exception ex) {
                        SystemCredentials.create(c);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
                return false;
            }
            return true;
        }
    }

    public static class Credentials {
        private final ComponentId componentId;
        private final String name;
        private final X509Certificate cert;
        private final KeyPair keyPair;
        private final String certFingerprint;

        private Credentials(ComponentId componentId) throws Exception {
            this.componentId = componentId;
            this.name = componentId.name();
            this.cert = this.loadCertificate(componentId);
            this.keyPair = this.loadKeyPair(componentId);
            this.certFingerprint = X509CertHelper.calcFingerprint(this.cert);
            EventRecord.here(SystemCredentials.class, EventType.COMPONENT_INFO, "initialized", this.name, this.cert.getSubjectDN().toString()).info();
            providers.put(this.name, this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Credentials other = (Credentials)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        private KeyPair loadKeyPair(ComponentId componentId) throws Exception {
            if (this.componentId.hasCredentials().booleanValue() && EucaKeyStore.getInstance().containsEntry(this.name)) {
                try {
                    EventRecord.here(SystemCredentials.class, EventType.COMPONENT_INFO, "initializing", this.name).info();
                    return EucaKeyStore.getInstance().getKeyPair(this.name, this.name);
                }
                catch (Exception e) {
                    LOG.fatal((Object)("Failed to read keys from the keystore: " + componentId + ".  Please repair the keystore by hand."));
                    LOG.fatal((Object)e, (Throwable)e);
                    throw e;
                }
            }
            throw new NoSuchComponentException("Failed to find credentials for: " + componentId);
        }

        private X509Certificate loadCertificate(ComponentId componentId) throws Exception {
            if (this.componentId.hasCredentials().booleanValue() && EucaKeyStore.getInstance().containsEntry(this.name)) {
                try {
                    EventRecord.here(SystemCredentials.class, EventType.COMPONENT_INFO, "initializing", this.name).info();
                    return EucaKeyStore.getInstance().getCertificate(this.name);
                }
                catch (Exception e) {
                    LOG.fatal((Object)("Failed to read certificate from the keystore: " + componentId + ".  Please repair the keystore by hand."));
                    LOG.fatal((Object)e, (Throwable)e);
                    throw e;
                }
            }
            throw new NoSuchComponentException("Failed to find credentials for: " + componentId);
        }

        public String getPem() {
            return B64.url.encString(PEMFiles.getBytes(this.getCertificate()));
        }

        public X509Certificate getCertificate() {
            return this.cert;
        }

        public PrivateKey getPrivateKey() {
            return this.keyPair.getPrivate();
        }

        public KeyPair getKeyPair() {
            return this.keyPair;
        }

        public String getCertFingerprint() {
            return this.certFingerprint;
        }
    }
}

