/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component.annotation;

import com.google.common.base.Enums;
import com.google.common.base.Objects;

public enum DatabaseNamingStrategy {
    Database{

        @Override
        public String getDatabaseName(String context) {
            return context;
        }

        @Override
        public String getSchemaName(String context) {
            return null;
        }
    }
    ,
    Schema{

        @Override
        public String getDatabaseName(String context) {
            return DatabaseNamingStrategy.SHARED_DATABASE_NAME;
        }

        @Override
        public String getSchemaName(String context) {
            return context;
        }
    };

    public static final String SHARED_DATABASE_NAME = "eucalyptus_shared";

    public static DatabaseNamingStrategy defaultStrategy() {
        return DatabaseNamingStrategy.propertyValueIfPresent("com.eucalyptus.component.defaultDatabaseNamingStrategy", Schema);
    }

    public static DatabaseNamingStrategy overrideStrategy(DatabaseNamingStrategy strategy) {
        return DatabaseNamingStrategy.propertyValueIfPresent("com.eucalyptus.component.databaseNamingStrategy", strategy);
    }

    private static DatabaseNamingStrategy propertyValueIfPresent(String propertyName, DatabaseNamingStrategy fallback) {
        return (DatabaseNamingStrategy)((Object)Objects.firstNonNull((Object)Enums.valueOfFunction(DatabaseNamingStrategy.class).apply((Object)System.getProperty(propertyName, "")), (Object)((Object)fallback)));
    }

    public abstract String getDatabaseName(String var1);

    public abstract String getSchemaName(String var1);
}

