/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.bootstrap.Host;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.Topology;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.util.Cidr;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.dns.DnsResolvers;
import com.eucalyptus.util.dns.DomainNameRecords;
import com.eucalyptus.util.dns.DomainNames;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

@ConfigurableClass(root="dns.services", description="Options controlling DNS name resolution for Eucalyptus services.")
public class TopologyDnsResolver
implements DnsResolvers.DnsResolver {
    @ConfigurableField(description="Enable the service topology resolver.  Note: dns.enable must also be 'true'")
    public static Boolean enabled = Boolean.TRUE;
    @ConfigurableField(description="Comma separated list of listener address CIDRs to desired host address CIDRS for services", initial="", changeListener=HostMappingPropertyChangeListener.class)
    public static String hostMapping = "";
    private static final Function<String, Map<Cidr, Cidr>> hostMappings = CacheBuilder.newBuilder().maximumSize(1L).build(CacheLoader.from((Function)CidrMapTransform.INSTANCE));
    private static final LoadingCache<Name, ServiceConfiguration> serviceNameMap = CacheBuilder.newBuilder().refreshAfterWrite(30L, TimeUnit.SECONDS).build(CacheLoader.from(ResolverSupport.SERVICE_FUNCTION));
    private Predicate<ServiceConfiguration> RESOLVABLE_STATE = new Predicate<ServiceConfiguration>(){

        public boolean apply(ServiceConfiguration arg0) {
            return Component.State.ENABLED.equals(arg0.lookupState()) || Component.State.DISABLED.equals(arg0.lookupState());
        }
    };

    @Override
    public boolean checkAccepts(DnsResolvers.DnsRequest request) {
        Record query = request.getQuery();
        if (enabled.booleanValue() && (DnsResolvers.RequestType.A.apply(query) || DnsResolvers.RequestType.AAAA.apply(query))) {
            if (DomainNames.isSystemSubdomain(query.getName())) {
                return ResolverSupport.COMPONENT.apply(query.getName()) || ResolverSupport.SERVICE.apply(query.getName());
            }
            if (query.getName().labels() <= 2 && ResolverSupport.COMPONENT.apply(query.getName())) {
                return true;
            }
            if (query.getName().labels() <= 3 && ResolverSupport.SERVICE.apply(query.getName())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public DnsResolvers.DnsResponse lookupRecords(DnsResolvers.DnsRequest request) {
        Record query = request.getQuery();
        Name name = query.getName();
        if (ResolverSupport.COMPONENT.apply(name)) {
            Class compIdType = (Class)ResolverSupport.COMPONENT_FUNCTION.apply((Object)name);
            Component comp = Components.lookup(compIdType);
            ArrayList configs = Lists.newArrayList();
            ComponentId componentId = comp.getComponentId();
            if (componentId.isPartitioned()) {
                String partitionName = name.getLabelString(1);
                Partition partition = Partitions.lookupByName(partitionName);
                if (componentId.isManyToOnePartition().booleanValue()) {
                    for (ServiceConfiguration conf : Iterables.filter(Components.lookup(compIdType).services(), ServiceConfigurations.filterByPartition(partition))) {
                        configs.add(conf);
                    }
                    Collections.shuffle(configs);
                } else {
                    configs.add(Topology.lookup(compIdType, partition));
                }
            } else if (componentId.isManyToOnePartition().booleanValue()) {
                for (ServiceConfiguration conf : Components.lookup(compIdType).services()) {
                    configs.add(conf);
                }
                Collections.shuffle(configs);
            } else {
                configs.add(Topology.lookup(compIdType, new Partition[0]));
            }
            ArrayList answers = Lists.newArrayList();
            for (ServiceConfiguration config : configs) {
                if (!this.RESOLVABLE_STATE.apply((Object)config)) continue;
                Record aRecord = DomainNameRecords.addressRecord(name, TopologyDnsResolver.maphost(request.getLocalAddress(), config.getInetAddress()));
                answers.add(aRecord);
            }
            return DnsResolvers.DnsResponse.forName(query.getName()).answer(DnsResolvers.RequestType.AAAA.apply(query) ? null : answers);
        }
        if (ResolverSupport.SERVICE.apply(name)) {
            ServiceConfiguration config = (ServiceConfiguration)ResolverSupport.SERVICE_FUNCTION.apply((Object)name);
            return DnsResolvers.DnsResponse.forName(query.getName()).answer(DnsResolvers.RequestType.AAAA.apply(query) ? null : DomainNameRecords.addressRecord(name, TopologyDnsResolver.maphost(request.getLocalAddress(), config.getInetAddress())));
        }
        throw new NoSuchElementException("Failed to lookup name: " + name);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static InetAddress maphost(InetAddress listenerAddress, InetAddress hostAddress) {
        Map mappings = (Map)hostMappings.apply((Object)hostMapping);
        InetAddress result = hostAddress;
        for (Map.Entry mapping : mappings.entrySet()) {
            Host host;
            if (!((Cidr)mapping.getKey()).apply(listenerAddress) || (host = Hosts.lookup(hostAddress)) == null) continue;
            result = (InetAddress)Iterables.tryFind(host.getHostAddresses(), (Predicate)((Predicate)mapping.getValue())).or((Object)result);
        }
        return result;
    }

    private static Map<Cidr, Cidr> parse(Function<String, Cidr> cidrTransform, String cidrMappingList) {
        Map cidrMappingText = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)",;:")).omitEmptyStrings().trimResults().withKeyValueSeparator(Splitter.on((Pattern)Pattern.compile("-?>")).omitEmptyStrings().trimResults().limit(2)).split((CharSequence)Objects.toString(cidrMappingList, ""));
        return CollectionUtils.transform(cidrMappingText, Maps.newHashMap(), cidrTransform, cidrTransform);
    }

    private static enum CidrMapTransform implements Function<String, Map<Cidr, Cidr>>
    {
        INSTANCE;


        public Map<Cidr, Cidr> apply(String cidrMappingList) {
            return TopologyDnsResolver.parse((Function<String, Cidr>)Functions.compose(CollectionUtils.optionalOrNull(), Cidr.parse()), cidrMappingList);
        }
    }

    public static final class HostMappingPropertyChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                TopologyDnsResolver.parse((Function<String, Cidr>)Cidr.parseUnsafe(), Objects.toString(newValue, ""));
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException(e.getMessage());
            }
        }
    }

    static enum ResolverSupport implements Predicate<Name>
    {
        COMPONENT{

            @Override
            public boolean apply(Name input) {
                boolean exists = false;
                try {
                    ComponentId compId = ComponentIds.lookup(input.getLabelString(0));
                    exists |= compId.isPublicService();
                    exists |= compId.isAdminService();
                    exists |= compId.isRegisterable();
                    if ((exists |= compId.isInternal()) && compId.isPartitioned()) {
                        exists &= Partitions.exists(input.getLabelString(1));
                    }
                    exists &= compId.isDnsSupported();
                }
                catch (NoSuchElementException ex) {
                    exists = false;
                }
                return exists;
            }
        }
        ,
        SERVICE{

            @Override
            public boolean apply(Name input) {
                boolean exists;
                boolean bl = exists = input.labels() >= 2;
                if (exists) {
                    try {
                        ComponentId compId = ComponentIds.lookup(input.getLabelString(1));
                        exists |= compId.isPublicService();
                        exists |= compId.isAdminService();
                        if ((exists |= compId.isRegisterable()) && compId.isPartitioned() && input.labels() >= 3) {
                            exists &= Partitions.exists(input.getLabelString(2));
                        }
                        if (exists) {
                            Components.lookup(compId).lookup(input.getLabelString(0));
                            exists = true;
                        }
                    }
                    catch (NoSuchElementException ex) {
                        exists = false;
                    }
                }
                return exists;
            }
        };

        public static final Function<Name, ServiceConfiguration> SERVICE_FUNCTION;
        public static final Function<Name, Class<? extends ComponentId>> COMPONENT_FUNCTION;

        public abstract boolean apply(Name var1);

        static {
            SERVICE_FUNCTION = new Function<Name, ServiceConfiguration>(){

                public ServiceConfiguration apply(Name name) {
                    if (!DomainNames.isSystemSubdomain(name)) {
                        throw new IllegalArgumentException("Cannot resolve service for " + name + "because it is outside the system domains");
                    }
                    try {
                        String serviceName = name.getLabelString(0);
                        String componentName = name.getLabelString(1);
                        return Components.lookup(componentName).lookup(serviceName);
                    }
                    catch (Exception ex) {
                        try {
                            return ServiceConfigurations.lookupByName(name.getLabelString(0));
                        }
                        catch (Exception ex1) {
                            throw new IllegalArgumentException("Cannot resolve service for " + name + " because of: " + ex.getMessage());
                        }
                    }
                }
            };
            COMPONENT_FUNCTION = new Function<Name, Class<? extends ComponentId>>(){

                public Class<? extends ComponentId> apply(Name name) {
                    if (!DomainNames.isSystemSubdomain(name)) {
                        throw new IllegalArgumentException("Cannot resolve a component type for " + name + "which is outside the system domains");
                    }
                    try {
                        String componentName = name.getLabelString(0);
                        return ComponentIds.lookup(componentName).getClass();
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException("Cannot resolve a component type for " + name + " because of: " + ex.getMessage());
                    }
                }
            };
        }
    }
}

