/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.component;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.BootstrapArgs;
import com.eucalyptus.bootstrap.Databases;
import com.eucalyptus.bootstrap.Host;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.ServiceTransitions;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.empyrean.DestroyServiceType;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.empyrean.ServiceId;
import com.eucalyptus.empyrean.ServiceTransitionType;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.Internets;
import com.eucalyptus.util.LockResource;
import com.eucalyptus.util.TypeMappers;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.async.Futures;
import com.eucalyptus.util.fsm.ExistingTransitionException;
import com.eucalyptus.util.fsm.OrderlyTransitionException;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

@ConfigurableClass(root="bootstrap.topology", description="Properties controlling the handling of service topology")
public class Topology {
    private static Logger LOG = Logger.getLogger(Topology.class);
    private static Topology singleton = null;
    private Integer currentEpoch = 0;
    @ConfigurableField(description="Backoff between service state checks (in seconds).")
    public static Integer COORDINATOR_CHECK_BACKOFF_SECS = 10;
    @ConfigurableField(description="Backoff between service state checks (in seconds).")
    public static Integer LOCAL_CHECK_BACKOFF_SECS = 10;
    private final ConcurrentMap<ServiceKey, ServiceConfiguration> services = new ConcurrentSkipListMap<ServiceKey, ServiceConfiguration>();
    private static final LoadingCache<Component.State, Function<ServiceConfiguration, ServiceConfiguration>> cloudTransitionCallables = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Component.State, Function<ServiceConfiguration, ServiceConfiguration>>(){

        public Function<ServiceConfiguration, ServiceConfiguration> load(Component.State input) {
            for (Transitions c : Transitions.values()) {
                if (input.equals(c.state)) {
                    return c;
                }
                if (!input.name().startsWith(c.name())) continue;
                return c;
            }
            return Transitions.CHECK;
        }
    });

    public static <T> T doTopologyWork(Callable<T> callable) throws Exception {
        return TopologyTimer.INSTANCE.doWork(callable);
    }

    private Topology(int i) {
        this.currentEpoch = i;
        Listeners.register(ClockTick.class, TopologyTimer.INSTANCE);
    }

    private static Predicate<ServiceConfiguration> componentFilter(final Class<? extends ComponentId> c) {
        return new Predicate<ServiceConfiguration>(){

            public boolean apply(ServiceConfiguration input) {
                return input.getComponentId().getClass().equals(c);
            }
        };
    }

    public static void populateServices(final ServiceConfiguration config, BaseMessage msg) {
        try {
            Predicate<ServiceConfiguration> filter = new Predicate<ServiceConfiguration>(){

                public boolean apply(ServiceConfiguration filterConfig) {
                    ComponentId filteredComponent = filterConfig.getComponentId();
                    ComponentId destComponent = config.getComponentId();
                    if (filteredComponent.isDistributedService()) {
                        if (destComponent.isAlwaysLocal().booleanValue()) {
                            return filterConfig.lookupState().ordinal() >= Component.State.STOPPED.ordinal();
                        }
                        if (destComponent.isPartitioned() && filteredComponent.isPartitioned()) {
                            return config.getPartition().equals(filterConfig.getPartition());
                        }
                        return true;
                    }
                    return false;
                }
            };
            Function<ServiceConfiguration, ServiceId> typeMapper = TypeMappers.lookup(ServiceConfiguration.class, ServiceId.class);
            if (Hosts.isCoordinator()) {
                msg.set_epoch(Topology.epoch());
                for (ServiceConfiguration s : Topology.getInstance().getServices().values()) {
                    if (!filter.apply((Object)s)) continue;
                    msg.get_services().add((ServiceId)typeMapper.apply((Object)s));
                }
                for (Component c : Components.list()) {
                    for (ServiceConfiguration s : c.services()) {
                        if (!filter.apply((Object)s) || msg.get_services().contains(s)) continue;
                        if (Component.State.DISABLED.apply(s)) {
                            msg.get_disabledServices().add((ServiceId)typeMapper.apply((Object)s));
                            continue;
                        }
                        if (Component.State.STOPPED.apply(s)) {
                            msg.get_stoppedServices().add((ServiceId)typeMapper.apply((Object)s));
                            continue;
                        }
                        if (Component.State.NOTREADY.ordinal() >= ((Component.State)s.getStateMachine().getState()).ordinal()) {
                            msg.get_notreadyServices().add((ServiceId)typeMapper.apply((Object)s));
                            continue;
                        }
                        if (!Component.State.ENABLED.apply(s) || !c.getComponentId().isManyToOnePartition().booleanValue() || !c.getComponentId().isDistributedService()) continue;
                        msg.get_services().add((ServiceId)typeMapper.apply((Object)s));
                    }
                }
            }
        }
        catch (Exception ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
        }
    }

    public static void touch(ServiceTransitionType msg) {
        if (!Hosts.isCoordinator() && msg.get_epoch() != null) {
            Topology.update(Iterables.concat(msg.get_services(), msg.get_disabledServices(), msg.get_notreadyServices(), msg.get_stoppedServices()));
            Topology.performTransitionsById(msg.get_services(), Topology.transition(Component.State.ENABLED));
            Topology.extractResults(Topology.performTransitionsById(msg.get_disabledServices(), Topology.transition(Component.State.DISABLED)));
            Topology.extractResults(Topology.performTransitions(Topology.extractResults(Topology.performTransitionsById(msg.get_notreadyServices(), Topology.transition(Component.State.DISABLED))), Topology.transition(Component.State.NOTREADY)));
            Topology.extractResults(Topology.performTransitionsById(msg.get_stoppedServices(), Topology.transition(Component.State.STOPPED)));
            Topology.getInstance().currentEpoch = Ints.max((int[])new int[]{Topology.getInstance().currentEpoch, msg.get_epoch()});
        }
    }

    private static Iterable<ServiceId> update(Iterable<ServiceId> iterable) {
        return Iterables.transform(iterable, (Function)UpdateServiceConfiguration.INSTANCE);
    }

    private static List<Future<ServiceConfiguration>> performTransitionsById(Iterable<ServiceId> services, Function<ServiceConfiguration, Future<ServiceConfiguration>> transition) {
        return Topology.performTransitions(Iterables.transform(services, (Function)ServiceConfigurations.ServiceIdToServiceConfiguration.INSTANCE), transition);
    }

    private static List<Future<ServiceConfiguration>> performTransitions(Iterable<ServiceConfiguration> serviceConfigurations, Function<ServiceConfiguration, Future<ServiceConfiguration>> transition) {
        ArrayList futures = Lists.newArrayList();
        for (ServiceConfiguration serviceConfiguration : serviceConfigurations) {
            if (serviceConfiguration.isVmLocal().booleanValue()) continue;
            futures.add(transition.apply((Object)serviceConfiguration));
        }
        return futures;
    }

    private static List<ServiceConfiguration> extractResults(List<Future<ServiceConfiguration>> futures) {
        ArrayList results = Lists.newArrayList();
        for (Future<ServiceConfiguration> future : futures) {
            try {
                results.add(future.get());
            }
            catch (InterruptedException ex) {
                Exceptions.maybeInterrupted(ex);
            }
            catch (ExecutionException ex) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
        }
        return results;
    }

    public static boolean check(BaseMessage msg) {
        if (!Hosts.isCoordinator() && msg.get_epoch() != null) {
            return Topology.epoch() <= msg.get_epoch();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Topology getInstance() {
        if (singleton != null) {
            return singleton;
        }
        Class<Topology> clazz = Topology.class;
        synchronized (Topology.class) {
            if (singleton != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return singleton;
            }
            singleton = new Topology(Hosts.maxEpoch());
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private Integer getEpoch() {
        return this.currentEpoch;
    }

    public static int epoch() {
        return Topology.getInstance().getEpoch();
    }

    public static Function<ServiceConfiguration, Future<ServiceConfiguration>> transition(final Component.State toState) {
        Function<ServiceConfiguration, Future<ServiceConfiguration>> transition = new Function<ServiceConfiguration, Future<ServiceConfiguration>>(){
            private final List<Component.State> serializedStates = Lists.newArrayList((Object[])new Component.State[]{Component.State.ENABLED, Component.State.STOPPED});

            public Future<ServiceConfiguration> apply(ServiceConfiguration input) {
                Callable call = Topology.callable(input, (Function<ServiceConfiguration, ServiceConfiguration>)Topology.get(toState));
                if (this.serializedStates.contains(toState) || this.serializedStates.contains(input.lookupState())) {
                    return Threads.enqueue(input, Topology.class, (Integer)1, call);
                }
                return Queue.EXTERNAL.enqueue(call);
            }
        };
        return transition;
    }

    private static Future<ServiceConfiguration> check(ServiceConfiguration config) {
        return Queue.EXTERNAL.enqueue(Topology.callable(config, Topology.check()));
    }

    public static Future<ServiceConfiguration> stop(ServiceConfiguration config) {
        return (Future)Topology.transition(Component.State.STOPPED).apply((Object)config);
    }

    public static Future<ServiceConfiguration> destroy(final ServiceConfiguration config) {
        try {
            ServiceConfigurations.remove(config);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            Logs.extreme().debug((Object)ex, (Throwable)ex);
        }
        try {
            Topology.disable(config).get();
        }
        catch (Exception ex) {
            Exceptions.maybeInterrupted(ex);
            LOG.error((Object)ex);
            Logs.extreme().debug((Object)ex, (Throwable)ex);
        }
        try {
            Topology.stop(config).get();
        }
        catch (Exception ex) {
            Exceptions.maybeInterrupted(ex);
            LOG.error((Object)ex);
            Logs.extreme().debug((Object)ex, (Throwable)ex);
        }
        try {
            Queue.INTERNAL.enqueue(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try {
                        Component comp = Components.lookup(config.getComponentId());
                        comp.destroy(config);
                    }
                    catch (Exception ex) {
                        Exceptions.maybeInterrupted(ex);
                        LOG.error((Object)ex);
                        Logs.extreme().debug((Object)ex, (Throwable)ex);
                    }
                    return true;
                }
            }).get();
        }
        catch (Exception ex) {
            Exceptions.maybeInterrupted(ex);
            LOG.error((Object)ex);
            Logs.extreme().debug((Object)ex, (Throwable)ex);
        }
        if (Hosts.isCoordinator()) {
            try {
                ServiceId service = TypeMappers.transform(config, ServiceId.class);
                ArrayList futures = Lists.newArrayList();
                for (Host h : Hosts.list()) {
                    if (h.isLocalHost() || !h.hasBootstrapped().booleanValue()) continue;
                    try {
                        DestroyServiceType msg = new DestroyServiceType();
                        msg.getServices().add(service);
                        futures.add(AsyncRequests.dispatch(ServiceConfigurations.createEphemeral(Empyrean.INSTANCE, h.getBindAddress()), msg));
                    }
                    catch (Exception ex) {
                        Exceptions.maybeInterrupted(ex);
                        LOG.error((Object)ex);
                        Logs.extreme().debug((Object)ex, (Throwable)ex);
                    }
                }
                for (CheckedListenableFuture future : futures) {
                    try {
                        future.get();
                    }
                    catch (Exception ex) {
                        Exceptions.maybeInterrupted(ex);
                        LOG.error((Object)ex);
                        Logs.extreme().debug((Object)ex, (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                Logs.extreme().debug((Object)ex, (Throwable)ex);
            }
        }
        try {
            ServiceTransitions.StateCallbacks.PROPERTIES_REMOVE.fire(config);
        }
        catch (Exception ex) {
            Exceptions.maybeInterrupted(ex);
            LOG.error((Object)ex);
            Logs.extreme().debug((Object)ex, (Throwable)ex);
        }
        return Futures.predestinedFuture(config);
    }

    public static Future<ServiceConfiguration> load(ServiceConfiguration config) {
        return (Future)Topology.transition(Component.State.LOADED).apply((Object)config);
    }

    public static Future<ServiceConfiguration> start(ServiceConfiguration config) {
        return (Future)Topology.transition(Component.State.DISABLED).apply((Object)config);
    }

    public static Future<ServiceConfiguration> enable(ServiceConfiguration config) {
        return (Future)Topology.transition(Component.State.ENABLED).apply((Object)config);
    }

    public static Future<ServiceConfiguration> disable(ServiceConfiguration config) {
        return (Future)Topology.transition(Component.State.DISABLED).apply((Object)config);
    }

    private ServiceConfiguration lookup(ServiceKey serviceKey) {
        return (ServiceConfiguration)this.getServices().get(serviceKey);
    }

    private TransitionGuard cloudControllerGuard() {
        return new TransitionGuard(){

            @Override
            public boolean nextEpoch() {
                Topology topology = Topology.this;
                Integer n = topology.currentEpoch;
                Integer n2 = topology.currentEpoch = topology.currentEpoch + 1;
                return true;
            }

            @Override
            public boolean tryEnable(ServiceConfiguration config) {
                ServiceKey serviceKey = ServiceKey.create(config);
                ServiceConfiguration curr = Topology.this.getServices().putIfAbsent(serviceKey, config);
                LOG.trace((Object)("tryEnable():before " + Topology.this.toString() + " => " + config));
                if (curr != null && !curr.equals(config)) {
                    LOG.trace((Object)("tryEnable():false  " + Topology.this.toString() + " => " + config));
                    return false;
                }
                if (curr != null && curr.equals(config)) {
                    LOG.trace((Object)("tryEnable():true   " + Topology.this.toString() + " => " + config));
                    return true;
                }
                Topology topology = Topology.this;
                Integer n = topology.currentEpoch;
                Integer n2 = topology.currentEpoch = topology.currentEpoch + 1;
                LOG.trace((Object)("tryEnable():true   " + Topology.this.toString() + " => " + config));
                return true;
            }

            @Override
            public boolean tryDisable(ServiceConfiguration config) {
                ServiceKey serviceKey = ServiceKey.create(config);
                boolean tryDisable = !config.equals(Topology.this.getServices().get(serviceKey)) || Topology.this.getServices().remove(serviceKey, config) && this.nextEpoch();
                LOG.trace((Object)("tryDisable():" + tryDisable + " " + Topology.this.toString() + " => " + config));
                return tryDisable;
            }
        };
    }

    private TransitionGuard remoteGuard() {
        return new TransitionGuard(){

            @Override
            public boolean nextEpoch() {
                return true;
            }

            @Override
            public boolean tryEnable(ServiceConfiguration config) {
                ServiceKey serviceKey = ServiceKey.create(config);
                LOG.trace((Object)("tryEnable():before " + Topology.this.toString() + " => " + config));
                ServiceConfiguration curr = Topology.this.getServices().put(serviceKey, config);
                Logs.extreme().info((Object)("Current ENABLED: " + curr));
                if (curr != null && !curr.equals(config)) {
                    Topology.transition(Component.State.DISABLED).apply((Object)curr);
                    LOG.trace((Object)("tryEnable():false  " + Topology.this.toString() + " => " + config));
                    return false;
                }
                if (curr != null && curr.equals(config)) {
                    LOG.trace((Object)("tryEnable():true   " + Topology.this.toString() + " => " + config));
                    return true;
                }
                LOG.trace((Object)("tryEnable():true   " + Topology.this.toString() + " => " + config));
                return true;
            }

            @Override
            public boolean tryDisable(ServiceConfiguration config) {
                ServiceKey serviceKey = ServiceKey.create(config);
                LOG.trace((Object)("tryDisable():true   " + Topology.this.toString() + " => " + config));
                return (Topology.this.getServices().remove(serviceKey, config) || !config.equals(Topology.this.getServices().get(serviceKey))) && this.nextEpoch();
            }
        };
    }

    protected static TransitionGuard guard() {
        return Topology.getInstance().getGuard();
    }

    public TransitionGuard getGuard() {
        return Hosts.isCoordinator() ? this.cloudControllerGuard() : this.remoteGuard();
    }

    private ConcurrentMap<ServiceKey, ServiceConfiguration> getServices() {
        return this.services;
    }

    public static ServiceConfiguration lookup(Class<? extends ComponentId> compClass, Partition ... maybePartition) {
        ComponentId compId = ComponentIds.lookup(compClass);
        Partition partition = maybePartition != null && maybePartition.length > 0 ? (compId.isPartitioned() ? maybePartition[0] : null) : null;
        ServiceConfiguration res = null;
        if (ComponentIds.lookup(compClass).isManyToOnePartition().booleanValue()) {
            res = partition != null ? (ServiceConfiguration)Iterables.getFirst(ServiceConfigurations.filter(compClass, ServiceConfigurations.filterByPartition(partition)), null) : (ServiceConfiguration)Iterables.getFirst(ServiceConfigurations.filter(compClass, ServiceConfigurations.filterEnabled()), null);
        } else {
            res = (ServiceConfiguration)Topology.getInstance().getServices().get(ServiceKey.create(ComponentIds.lookup(compClass), partition));
            if (res == null && !compClass.equals(compId.partitionParent().getClass()) && !compId.isAlwaysLocal().booleanValue()) {
                try {
                    ServiceConfiguration parent = (ServiceConfiguration)Topology.getInstance().getServices().get(ServiceKey.create(compId.partitionParent(), null));
                    Partition fakePartition = Partitions.lookupInternal(ServiceConfigurations.createEphemeral(compId, parent.getInetAddress()));
                    res = (ServiceConfiguration)Topology.getInstance().getServices().get(ServiceKey.create(compId, fakePartition));
                }
                catch (RuntimeException e) {
                    res = null;
                }
            } else if (res == null && (compId.isAlwaysLocal().booleanValue() || BootstrapArgs.isCloudController().booleanValue() && compId.isCloudLocal().booleanValue() && !compId.isRegisterable())) {
                res = (ServiceConfiguration)Topology.getInstance().getServices().get(ServiceKey.create(ServiceConfigurations.createEphemeral(compId)));
            }
        }
        String err = "Failed to lookup ENABLED service of type " + compClass.getSimpleName() + (partition != null ? " in partition " + partition : ".");
        if (res == null) {
            throw new NoSuchElementException(err);
        }
        if (!Component.State.ENABLED.apply(res)) {
            throw new NoSuchElementException(err + "  Service is currently ENABLING.");
        }
        return res;
    }

    public static <T extends ServiceConfiguration> Iterable<T> lookupMany(Class<? extends ComponentId> compClass, Partition ... maybePartition) {
        ComponentId compId = ComponentIds.lookup(compClass);
        Partition partition = maybePartition != null && maybePartition.length > 0 ? (compId.isPartitioned() ? maybePartition[0] : null) : null;
        Iterable<Object> res = null;
        if (ComponentIds.lookup(compClass).isManyToOnePartition().booleanValue()) {
            res = partition != null ? ServiceConfigurations.filter(compClass, ServiceConfigurations.filterByPartition(partition)) : ServiceConfigurations.filter(compClass, ServiceConfigurations.filterEnabled());
        }
        String err = "Failed to lookup ENABLED service of type " + compClass.getSimpleName() + (partition != null ? " in partition " + partition : ".");
        if (res == null) {
            throw new NoSuchElementException(err);
        }
        return res;
    }

    public static Collection<ServiceConfiguration> enabledServices(Class<? extends ComponentId> compId) {
        return Collections2.filter(Topology.enabledServices(), Topology.componentFilter(compId));
    }

    public static Collection<ServiceConfiguration> enabledServices() {
        ArrayList enabledServices = Lists.newArrayList();
        Collection activePassiveServices = Topology.getInstance().services.values();
        enabledServices.addAll(activePassiveServices);
        for (Component comp : Components.whichAreManyToOneEnabled()) {
            for (ServiceConfiguration serv : comp.services()) {
                if (enabledServices.contains(serv)) continue;
                enabledServices.add(serv);
            }
        }
        return enabledServices;
    }

    public static boolean isEnabledLocally(Class<? extends ComponentId> compClass) {
        return Iterables.any(Topology.enabledServices(compClass), ServiceConfigurations.filterHostLocal());
    }

    public static boolean isEnabled(Class<? extends ComponentId> compClass) {
        return !Topology.enabledServices(compClass).isEmpty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Topology:currentEpoch=").append(this.currentEpoch).append(":guard=").append(Hosts.isCoordinator() ? "cloud" : "remote");
        return builder.toString();
    }

    private static Function<ServiceConfiguration, ServiceConfiguration> get(Component.State state) {
        return (Function)cloudTransitionCallables.getUnchecked((Object)state);
    }

    private static Function<ServiceConfiguration, ServiceConfiguration> check() {
        return Transitions.CHECK;
    }

    private static Callable<ServiceConfiguration> callable(final ServiceConfiguration config, final Function<ServiceConfiguration, ServiceConfiguration> function) {
        final Long queueStart = System.currentTimeMillis();
        Callable<ServiceConfiguration> call = new Callable<ServiceConfiguration>(){

            @Override
            public ServiceConfiguration call() throws Exception {
                if (Bootstrap.isShuttingDown().booleanValue()) {
                    throw Exceptions.toUndeclared((String)"System is shutting down.", (Throwable[])new Throwable[0]);
                }
                Long serviceStart = System.currentTimeMillis();
                Logs.extreme().debug((Object)EventRecord.here(Topology.class, EventType.DEQUEUE, function.toString(), config.getFullName().toString(), Long.toString(serviceStart - queueStart), "ms"));
                try {
                    ServiceConfiguration result = (ServiceConfiguration)function.apply((Object)config);
                    Logs.extreme().debug((Object)EventRecord.here(Topology.class, EventType.QUEUE, function.toString(), config.getFullName().toString(), Long.toString(System.currentTimeMillis() - serviceStart), "ms"));
                    return result;
                }
                catch (Exception ex) {
                    Throwable t = Exceptions.unwrapCause(ex);
                    Logs.extreme().error((Object)(config.getFullName() + " failed to transition because of:\n" + t.getMessage()));
                    Logs.extreme().error((Object)t, t);
                    throw ex;
                }
            }

            public String toString() {
                return Topology.class.getSimpleName() + ":" + config.getFullName() + " " + function.toString();
            }
        };
        return call;
    }

    private static Callable<ServiceConfiguration> perhapsDisable(final ServiceConfiguration input) {
        return new Callable<ServiceConfiguration>(){

            @Override
            public ServiceConfiguration call() throws Exception {
                if (!Component.State.ENABLED.equals(input.lookupState()) && Topology.getInstance().services.containsValue(input)) {
                    Topology.guard().tryDisable(input);
                }
                return input;
            }
        };
    }

    private static class TopologyChange
    implements Function<ServiceConfiguration, ServiceConfiguration>,
    Supplier<Component.State> {
        private final Transitions transitionName;

        TopologyChange(Transitions transitionName) {
            this.transitionName = transitionName;
        }

        public ServiceConfiguration apply(ServiceConfiguration input) {
            Component.State nextState = null;
            nextState = this.findNextCheckState(input.lookupState());
            if (nextState == null) {
                return input;
            }
            return this.doTopologyChange(input, nextState);
        }

        private ServiceConfiguration doTopologyChange(ServiceConfiguration input, Component.State nextState) throws RuntimeException {
            Component.State initialState = input.lookupState();
            boolean enabledEndState = false;
            ServiceConfiguration endResult = input;
            try {
                endResult = ServiceTransitions.pathTo(input, nextState).get();
                Logs.extreme().debug((Object)this.toString(endResult, initialState, nextState, new Throwable[0]));
                ServiceConfiguration serviceConfiguration = endResult;
                return serviceConfiguration;
            }
            catch (Exception ex) {
                if (Exceptions.isCausedBy(ex, ExistingTransitionException.class)) {
                    LOG.error((Object)this.toString(input, initialState, nextState, ex));
                    enabledEndState = true;
                    throw Exceptions.toUndeclared(ex);
                }
                if (Exceptions.isCausedBy(ex, OrderlyTransitionException.class)) {
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                    throw Exceptions.toUndeclared(ex);
                }
                Exceptions.maybeInterrupted(ex);
                LOG.error((Object)this.toString(input, initialState, nextState, ex));
                Logs.extreme().error((Object)ex, Throwables.getRootCause((Throwable)ex));
                Logs.extreme().error((Object)ex, (Throwable)ex);
                throw Exceptions.toUndeclared(ex);
            }
            finally {
                if (Bootstrap.isFinished().booleanValue() && !(enabledEndState |= Component.State.ENABLED.equals(endResult.lookupState())) && Topology.getInstance().services.containsValue(input)) {
                    Threads.enqueue(input, Topology.class, (Integer)1, Topology.perhapsDisable(input));
                }
            }
        }

        private String toString(ServiceConfiguration endResult, Component.State initialState, Component.State nextState, Throwable ... throwables) {
            return String.format("%s %s %s->%s=%s [%s]\n", this.toString(), endResult.getFullName(), initialState, nextState, endResult.lookupState(), throwables != null && throwables.length > 0 ? Throwables.getRootCause((Throwable)throwables[0]).getMessage() : "WINNING");
        }

        public String toString() {
            return this.transitionName.toString();
        }

        public Component.State get() {
            return this.transitionName.get();
        }

        private Component.State findNextCheckState(Component.State initialState) {
            if (this.get() == null) {
                if (Component.State.NOTREADY.equals(initialState) || Component.State.BROKEN.equals(initialState)) {
                    return Component.State.DISABLED;
                }
                if (initialState.ordinal() < Component.State.NOTREADY.ordinal()) {
                    return null;
                }
                return initialState;
            }
            return this.get();
        }
    }

    public static enum Transitions implements Function<ServiceConfiguration, ServiceConfiguration>,
    Supplier<Component.State>
    {
        START(Component.State.DISABLED),
        STOP(Component.State.STOPPED){

            @Override
            public ServiceConfiguration apply(ServiceConfiguration input) {
                return this.tc.apply(input);
            }
        }
        ,
        INITIALIZE(Component.State.INITIALIZED),
        LOAD(Component.State.LOADED),
        DESTROY(Component.State.PRIMORDIAL),
        ENABLE(Component.State.ENABLED){

            @Override
            public ServiceConfiguration apply(ServiceConfiguration config) {
                boolean busy = config.lookupStateMachine().isBusy();
                boolean tryEnable = false;
                boolean manyToOne = config.getComponentId().isManyToOnePartition();
                if (manyToOne) {
                    return super.apply(config);
                }
                if (Topology.guard().tryEnable(config)) {
                    try {
                        ServiceConfiguration res = super.apply(config);
                        return res;
                    }
                    catch (RuntimeException ex) {
                        Topology.guard().tryDisable(config);
                        throw ex;
                    }
                }
                if (!busy) {
                    try {
                        return ServiceTransitions.pathTo(config, Component.State.DISABLED).get();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw Exceptions.toUndeclared(ex);
                    }
                    catch (ExecutionException ex) {
                        throw Exceptions.toUndeclared(ex);
                    }
                }
                throw new IllegalStateException("Failed to ENABLE " + config.getFullName() + " since manyToOne=" + manyToOne + " tryEnable=" + tryEnable + " fsm.isBusy()=" + busy);
            }
        }
        ,
        DISABLE(Component.State.DISABLED),
        CHECK{

            @Override
            public ServiceConfiguration apply(ServiceConfiguration config) {
                if (!Bootstrap.isFinished().booleanValue()) {
                    LOG.debug((Object)(this.toString() + " aborted because bootstrap is not complete for service: " + config));
                    return config;
                }
                return super.apply(config);
            }
        }
        ,
        RESTART;

        private final Component.State state;
        protected final TopologyChange tc;

        private Transitions() {
            this.state = null;
            this.tc = new TopologyChange(this);
        }

        private Transitions(Component.State state) {
            this.state = state;
            this.tc = new TopologyChange(this);
        }

        public ServiceConfiguration apply(ServiceConfiguration input) {
            Components.lookup(input.getComponentId()).setup(input);
            return this.tc.apply(input);
        }

        public String toString() {
            return this.name() + ":" + this.get() + " ";
        }

        public Component.State get() {
            return this.state;
        }
    }

    static enum UpdateServiceConfiguration implements Function<ServiceId, ServiceId>
    {
        INSTANCE;


        public ServiceId apply(ServiceId serviceId) {
            try {
                ServiceConfiguration configuration = Components.lookup(serviceId.getType()).lookup(serviceId.getName());
                URI uri = new URI(serviceId.getUri());
                ServiceConfigurations.update(configuration, uri.getHost(), uri.getPort());
            }
            catch (URISyntaxException | NoSuchElementException exception) {
                // empty catch block
            }
            return serviceId;
        }
    }

    static enum FailoverPredicate implements Predicate<ServiceConfiguration>
    {
        INSTANCE;


        public boolean apply(ServiceConfiguration arg0) {
            ServiceKey key = ServiceKey.create(arg0);
            if (!Hosts.isCoordinator()) {
                Logs.extreme().debug((Object)("FAILOVER-REJECT: " + Internets.localHostInetAddress() + ": not cloud controller, ignoring promotion for: " + arg0.getFullName()));
                return false;
            }
            if (!arg0.isHostLocal().booleanValue() && !Hosts.contains(arg0.getHostName())) {
                Logs.extreme().debug((Object)("FAILOVER-REJECT: " + arg0.getFullName() + ": host for the service is not available: " + arg0.getHostName()));
                return false;
            }
            if (!arg0.isHostLocal().booleanValue() && Hosts.contains(arg0.getHostName()) && !Hosts.lookup(arg0.getHostName()).hasBootstrapped().booleanValue()) {
                Logs.extreme().debug((Object)("FAILOVER-REJECT: " + arg0.getFullName() + ": host for the service has not yet bootstrapped: " + arg0.getHostName()));
                return false;
            }
            if (Topology.getInstance().getServices().containsKey(key) && arg0.equals(Topology.getInstance().getServices().get(key))) {
                Logs.extreme().debug((Object)("FAILOVER-REJECT: " + arg0.getFullName() + ": service is already ENABLED."));
                return false;
            }
            if (!Topology.getInstance().getServices().containsKey(key)) {
                Logs.extreme().debug((Object)("FAILOVER-ACCEPT: " + arg0.getFullName() + ": service for partition: " + key));
                return true;
            }
            Logs.extreme().debug((Object)("FAILOVER-ACCEPT: " + arg0));
            return true;
        }
    }

    static enum RunChecks implements Callable<List<ServiceConfiguration>>
    {
        INSTANCE;


        @Override
        public List<ServiceConfiguration> call() {
            if (Databases.isVolatile().booleanValue()) {
                return Lists.newArrayList();
            }
            ArrayList allServices = Lists.newArrayList();
            for (Component c : Components.list()) {
                allServices.addAll(c.services());
            }
            Faults.flush();
            List<ServiceConfiguration> checkedServices = RunChecks.submitTransitions(allServices, CheckServiceFilter.INSTANCE, SubmitCheck.INSTANCE);
            if (!checkedServices.isEmpty()) {
                Logs.extreme().debug((Object)("CHECKED: " + Joiner.on((String)"\nCHECKED: ").join((Iterable)Collections2.transform(checkedServices, (Function)ServiceString.INSTANCE))));
            }
            if (Faults.isFailstop()) {
                Hosts.failstop();
                RunChecks.submitTransitions(allServices, CheckServiceFilter.INSTANCE, SubmitCheck.INSTANCE);
                return Lists.newArrayList();
            }
            if (!Hosts.isCoordinator()) {
                Predicate proceedToDisableFilter = Predicates.and(ServiceConfigurations.filterHostLocal(), (Predicate)ProceedToDisabledServiceFilter.INSTANCE);
                RunChecks.submitTransitions(allServices, (Predicate<ServiceConfiguration>)proceedToDisableFilter, SubmitDisable.INSTANCE);
                RunChecks.submitTransitions(allServices, AlwaysLocalServiceFilter.INSTANCE, SubmitEnable.INSTANCE);
                return checkedServices;
            }
            Predicate alwaysTrue = Predicates.alwaysTrue();
            Collections.shuffle(allServices);
            Collection doPass1 = Collections2.filter((Collection)allServices, (Predicate)Predicates.and((Predicate)CheckServiceFilter.INSTANCE, (Predicate)Component.State.NOTREADY));
            List<ServiceConfiguration> disabledPass1 = RunChecks.submitTransitions(Lists.newArrayList((Iterable)doPass1), (Predicate<ServiceConfiguration>)alwaysTrue, SubmitDisable.INSTANCE);
            ArrayList doPass2 = Lists.newArrayList((Iterable)doPass1);
            RunChecks.submitTransitions(doPass2, (Predicate<ServiceConfiguration>)Predicates.not((Predicate)Predicates.in(disabledPass1)), SubmitDisable.INSTANCE);
            Predicate canPromote = Predicates.and((Predicate[])new Predicate[]{Predicates.not((Predicate)Predicates.in((Collection)doPass1)), Component.State.DISABLED, FailoverPredicate.INSTANCE});
            Collection promoteServices = Collections2.filter((Collection)allServices, (Predicate)canPromote);
            List<ServiceConfiguration> result = RunChecks.submitTransitions(allServices, (Predicate<ServiceConfiguration>)canPromote, SubmitEnable.INSTANCE);
            Predicate proceedToDisableFilter = Predicates.and((Predicate)Predicates.not((Predicate)Predicates.in(result)), (Predicate)ProceedToDisabledServiceFilter.INSTANCE);
            RunChecks.submitTransitions(allServices, (Predicate<ServiceConfiguration>)proceedToDisableFilter, SubmitDisable.INSTANCE);
            return result;
        }

        private static List<ServiceConfiguration> submitTransitions(List<ServiceConfiguration> services, Predicate<ServiceConfiguration> serviceFilter, Function<ServiceConfiguration, Future<ServiceConfiguration>> submitFunction) {
            Collection filteredServices = Collections2.filter(services, serviceFilter);
            Collection submittedCallables = Collections2.transform((Collection)filteredServices, submitFunction);
            Collection completedServices = Collections2.filter((Collection)submittedCallables, (Predicate)WaitForResults.INSTANCE);
            ArrayList results = Lists.newArrayList((Iterable)Collections2.transform((Collection)completedServices, (Function)ExtractFuture.INSTANCE));
            RunChecks.printCheckInfo(submitFunction.toString(), results);
            return results;
        }

        private static void printCheckInfo(String action, Collection<ServiceConfiguration> result) {
            if (!result.isEmpty()) {
                Logs.extreme().debug((Object)(action + ": " + Joiner.on((String)("\n" + action + ": ")).join((Iterable)Collections2.transform(result, (Function)ServiceString.INSTANCE))));
            }
        }
    }

    static enum ExtractFuture implements Function<Future<ServiceConfiguration>, ServiceConfiguration>
    {
        INSTANCE;


        public ServiceConfiguration apply(Future<ServiceConfiguration> input) {
            try {
                return input.get();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                Logs.extreme().trace((Object)ex, (Throwable)ex);
            }
            return null;
        }
    }

    static enum ServiceString implements Function<ServiceConfiguration, String>
    {
        INSTANCE;


        public String apply(ServiceConfiguration input) {
            return input.getFullName() + ":" + input.lookupState();
        }
    }

    static enum WaitForResults implements Predicate<Future>
    {
        INSTANCE;


        public boolean apply(Future input) {
            try {
                Object conf = input.get(120L, TimeUnit.SECONDS);
                return true;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                Logs.extreme().trace((Object)ex, (Throwable)ex);
            }
            return false;
        }
    }

    static enum SubmitCheck implements Function<ServiceConfiguration, Future<ServiceConfiguration>>
    {
        INSTANCE;


        public Future<ServiceConfiguration> apply(ServiceConfiguration input) {
            Callable call = Topology.callable(input, (Function<ServiceConfiguration, ServiceConfiguration>)Topology.check());
            Future<ServiceConfiguration> future = Queue.EXTERNAL.enqueue(call);
            return future;
        }

        public String toString() {
            return "CHECKED";
        }
    }

    static enum SubmitDisable implements Function<ServiceConfiguration, Future<ServiceConfiguration>>
    {
        INSTANCE;


        public Future<ServiceConfiguration> apply(ServiceConfiguration input) {
            return (Future)Topology.transition(Component.State.DISABLED).apply((Object)input);
        }

        public String toString() {
            return "DISABLED";
        }
    }

    static enum SubmitEnable implements Function<ServiceConfiguration, Future<ServiceConfiguration>>
    {
        INSTANCE;


        public Future<ServiceConfiguration> apply(ServiceConfiguration input) {
            return (Future)Topology.transition(Component.State.ENABLED).apply((Object)input);
        }

        public String toString() {
            return "ENABLED";
        }
    }

    static enum CheckServiceFilter implements Predicate<ServiceConfiguration>
    {
        INSTANCE;


        public boolean apply(ServiceConfiguration arg0) {
            if (Hosts.isCoordinator() && arg0.getComponentId().isDistributedService()) {
                return true;
            }
            if (arg0.isHostLocal().booleanValue() && BootstrapArgs.isCloudController().booleanValue()) {
                return true;
            }
            return arg0.isVmLocal();
        }
    }

    static enum AlwaysLocalServiceFilter implements Predicate<ServiceConfiguration>
    {
        INSTANCE;


        public boolean apply(ServiceConfiguration arg0) {
            return arg0.isVmLocal() != false && arg0.getComponentId().isAlwaysLocal() != false && arg0.lookupState().ordinal() < Component.State.ENABLED.ordinal() && !Component.State.STOPPED.apply(arg0);
        }
    }

    static enum ProceedToDisabledServiceFilter implements Predicate<ServiceConfiguration>
    {
        INSTANCE;


        public boolean apply(ServiceConfiguration arg0) {
            return arg0.lookupState().ordinal() < Component.State.DISABLED.ordinal() && !Component.State.STOPPED.apply(arg0);
        }
    }

    public static class ServiceKey
    implements Comparable<ServiceKey> {
        private final Partition partition;
        private final ComponentId componentId;

        static ServiceKey create(ComponentId compId, Partition partition) {
            return new ServiceKey(compId, partition);
        }

        static ServiceKey create(ServiceConfiguration config) {
            if (config.getComponentId().isPartitioned() && !Empyrean.class.equals(config.getComponentId().partitionParent().getClass())) {
                Partition p = Partitions.lookup(config);
                return new ServiceKey(config.getComponentId(), p);
            }
            if (config.getComponentId().isAlwaysLocal().booleanValue() || config.getComponentId().isCloudLocal().booleanValue() && !config.getComponentId().isDistributedService()) {
                Partition p = Partitions.lookupInternal(config);
                return new ServiceKey(config.getComponentId(), p);
            }
            return new ServiceKey(config.getComponentId());
        }

        ServiceKey(ComponentId componentId) {
            this(componentId, null);
        }

        ServiceKey(ComponentId componentId, Partition partition) {
            this.partition = partition;
            this.componentId = componentId;
        }

        public Partition getPartition() {
            return this.partition;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ServiceKey ").append(this.componentId.name()).append(":");
            if (this.partition == null) {
                builder.append("cloud-global-service");
            } else {
                builder.append("partition=").append(this.partition);
            }
            return builder.toString();
        }

        public ComponentId getComponentId() {
            return this.componentId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.componentId == null ? 0 : this.componentId.hashCode());
            result = 31 * result + (this.partition == null ? 0 : this.partition.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServiceKey other = (ServiceKey)obj;
            if (this.componentId == null ? other.componentId != null : !this.componentId.equals(other.componentId)) {
                return false;
            }
            return !(this.partition == null ? other.partition != null : !this.partition.equals(other.partition));
        }

        @Override
        public int compareTo(ServiceKey that) {
            if (this.componentId.equals(that.componentId)) {
                if (this.partition == null && that.partition == null) {
                    return 0;
                }
                if (this.partition != null) {
                    return this.partition.compareTo(that.partition);
                }
                return -1;
            }
            return this.componentId.compareTo(that.componentId);
        }
    }

    private static interface TransitionGuard {
        public boolean tryEnable(ServiceConfiguration var1);

        public boolean nextEpoch();

        public boolean tryDisable(ServiceConfiguration var1);
    }

    private static enum TopologyTimer implements EventListener<ClockTick>
    {
        INSTANCE;

        private static final AtomicInteger counter;
        private static final AtomicBoolean busy;
        private static final ReadWriteLock lock;

        @Override
        public void fireEvent(ClockTick event) {
            int backoff = Hosts.isCoordinator() ? COORDINATOR_CHECK_BACKOFF_SECS : LOCAL_CHECK_BACKOFF_SECS;
            Callable<Object> call = new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() {
                    try {
                        Object object = RunChecks.INSTANCE.call();
                        return object;
                    }
                    finally {
                        busy.set(false);
                    }
                }
            };
            if (busy.compareAndSet(false, true)) {
                try {
                    TimeUnit.SECONDS.sleep(backoff);
                }
                catch (InterruptedException ex) {
                    busy.set(false);
                    return;
                }
                if ((Hosts.isCoordinator() || counter.incrementAndGet() % 5 == 0) && lock.writeLock().tryLock()) {
                    lock.writeLock().unlock();
                    try {
                        Queue.INTERNAL.enqueue(call);
                    }
                    catch (Exception ex) {
                        busy.set(false);
                    }
                } else {
                    busy.set(false);
                }
            }
        }

        public <T> T doWork(Callable<T> callable) throws Exception {
            try (LockResource lockResource = LockResource.lock(lock.readLock());){
                T t = callable.call();
                return t;
            }
        }

        static {
            counter = new AtomicInteger(0);
            busy = new AtomicBoolean(false);
            lock = new ReentrantReadWriteLock();
        }
    }

    private static enum Queue implements Function<Callable, Future>
    {
        INTERNAL(1){
            ServiceConfiguration internal;

            @Override
            ServiceConfiguration queue() {
                if (this.internal == null) {
                    this.internal = ServiceConfigurations.createEphemeral(Empyrean.INSTANCE, Topology.class.getSimpleName(), "internal", ServiceUris.internal((ComponentId)Empyrean.INSTANCE, new String[0]));
                }
                return this.internal;
            }
        }
        ,
        EXTERNAL(32){
            ServiceConfiguration external;

            @Override
            ServiceConfiguration queue() {
                if (this.external == null) {
                    this.external = ServiceConfigurations.createEphemeral(Empyrean.INSTANCE, Topology.class.getSimpleName(), "external", ServiceUris.internal((ComponentId)Empyrean.INSTANCE, new String[0]));
                }
                return this.external;
            }
        };

        private final int numWorkers;

        private Queue(int numWorkers) {
            this.numWorkers = numWorkers;
        }

        abstract ServiceConfiguration queue();

        public Future apply(Callable call) {
            Logs.extreme().debug((Object)(Topology.class.getSimpleName() + ": queueing " + call.toString()));
            Logs.extreme().debug((Object)Threads.currentStackRange(3, 9));
            return Threads.enqueue(this.queue(), this.numWorkers, call);
        }

        public <C> Future<C> enqueue(Callable<C> call) {
            return this.apply(call);
        }
    }
}

